/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.knn;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.WritePropertyConfig;
import org.neo4j.gds.config.WriteRelationshipConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.similarity.knn.KnnNodePropertySpec;
import org.neo4j.gds.similarity.knn.KnnNodePropertySpecParser;
import org.neo4j.gds.similarity.knn.KnnSampler;
import org.neo4j.gds.similarity.knn.KnnWriteConfig;

public final class KnnWriteConfigImpl
implements KnnWriteConfig {
    private List<KnnNodePropertySpec> nodeProperties;
    private int topK;
    private double sampleRate;
    private double perturbationRate;
    private double deltaThreshold;
    private double similarityCutoff;
    private int maxIterations;
    private int randomJoins;
    private KnnSampler.SamplerType initialSampler;
    private List<String> relationshipTypes;
    private List<String> nodeLabels;
    @Nullable
    private String usernameOverride;
    private boolean sudo;
    private int concurrency;
    private Optional<Long> randomSeed;
    private String writeProperty;
    private int writeConcurrency;
    private String writeRelationshipType;

    public KnnWriteConfigImpl(@NotNull CypherMapWrapper config) {
        ArrayList<IllegalArgumentException> errors = new ArrayList<IllegalArgumentException>();
        try {
            this.nodeProperties = (List)CypherMapWrapper.failOnNull((String)"nodeProperties", KnnNodePropertySpecParser.parse(config.requireChecked("nodeProperties", Object.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.topK = config.getInt("topK", KnnWriteConfig.super.topK());
            CypherMapWrapper.validateIntegerRange((String)"topK", (int)this.topK, (int)1, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sampleRate = config.getDouble("sampleRate", KnnWriteConfig.super.sampleRate());
            CypherMapWrapper.validateDoubleRange((String)"sampleRate", (double)this.sampleRate, (double)0.0, (double)1.0, (boolean)false, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.perturbationRate = config.getDouble("perturbationRate", KnnWriteConfig.super.perturbationRate());
            CypherMapWrapper.validateDoubleRange((String)"perturbationRate", (double)this.perturbationRate, (double)0.0, (double)1.0, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.deltaThreshold = config.getDouble("deltaThreshold", KnnWriteConfig.super.deltaThreshold());
            CypherMapWrapper.validateDoubleRange((String)"deltaThreshold", (double)this.deltaThreshold, (double)0.0, (double)1.0, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.similarityCutoff = config.getDouble("similarityCutoff", KnnWriteConfig.super.similarityCutoff());
            CypherMapWrapper.validateDoubleRange((String)"similarityCutoff", (double)this.similarityCutoff, (double)0.0, (double)1.0, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.maxIterations = config.getInt("maxIterations", KnnWriteConfig.super.maxIterations());
            CypherMapWrapper.validateIntegerRange((String)"maxIterations", (int)this.maxIterations, (int)1, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.randomJoins = config.getInt("randomJoins", KnnWriteConfig.super.randomJoins());
            CypherMapWrapper.validateIntegerRange((String)"randomJoins", (int)this.randomJoins, (int)0, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.initialSampler = (KnnSampler.SamplerType)((Object)CypherMapWrapper.failOnNull((String)"initialSampler", (Object)((Object)KnnSampler.SamplerType.parse(config.getChecked("initialSampler", (Object)KnnWriteConfig.super.initialSampler(), Object.class)))));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipTypes = (List)CypherMapWrapper.failOnNull((String)"relationshipTypes", (Object)((List)config.getChecked("relationshipTypes", (Object)KnnWriteConfig.super.relationshipTypes(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.nodeLabels = (List)CypherMapWrapper.failOnNull((String)"nodeLabels", (Object)((List)config.getChecked("nodeLabels", (Object)KnnWriteConfig.super.nodeLabels(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.usernameOverride = StringUtils.trimToNull((String)config.getString("username", KnnWriteConfig.super.usernameOverride()));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sudo = config.getBool("sudo", KnnWriteConfig.super.sudo());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.concurrency = config.getInt("concurrency", KnnWriteConfig.super.concurrency());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.randomSeed = (Optional)CypherMapWrapper.failOnNull((String)"randomSeed", (Object)config.getOptional("randomSeed", Long.class));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.writeProperty = (String)CypherMapWrapper.failOnNull((String)"writeProperty", (Object)WritePropertyConfig.validatePropertyName((String)config.requireString("writeProperty")));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.writeConcurrency = config.getInt("writeConcurrency", KnnWriteConfig.super.writeConcurrency());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.writeRelationshipType = (String)CypherMapWrapper.failOnNull((String)"writeRelationshipType", (Object)WriteRelationshipConfig.validatePropertyName((String)config.requireString("writeRelationshipType")));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.validateConcurrency();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.validate();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.validateWriteConcurrency();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                throw (IllegalArgumentException)errors.get(0);
            }
            String combinedErrorMsg = errors.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError = new IllegalArgumentException(combinedErrorMsg);
            errors.forEach(error -> combinedError.addSuppressed((Throwable)error));
            throw combinedError;
        }
    }

    @Override
    public List<KnnNodePropertySpec> nodeProperties() {
        return this.nodeProperties;
    }

    @Override
    public int topK() {
        return this.topK;
    }

    @Override
    public double sampleRate() {
        return this.sampleRate;
    }

    @Override
    public double perturbationRate() {
        return this.perturbationRate;
    }

    @Override
    public double deltaThreshold() {
        return this.deltaThreshold;
    }

    @Override
    public double similarityCutoff() {
        return this.similarityCutoff;
    }

    @Override
    public int maxIterations() {
        return this.maxIterations;
    }

    @Override
    public int randomJoins() {
        return this.randomJoins;
    }

    @Override
    public KnnSampler.SamplerType initialSampler() {
        return this.initialSampler;
    }

    public List<String> relationshipTypes() {
        return this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        return this.nodeLabels;
    }

    public void graphStoreValidation(GraphStore graphStore, Collection<NodeLabel> selectedLabels, Collection<RelationshipType> selectedRelationshipTypes) {
    }

    @Nullable
    public String usernameOverride() {
        return this.usernameOverride;
    }

    public boolean sudo() {
        return this.sudo;
    }

    public Collection<String> configKeys() {
        return Arrays.asList("nodeProperties", "topK", "sampleRate", "perturbationRate", "deltaThreshold", "similarityCutoff", "maxIterations", "randomJoins", "initialSampler", "relationshipTypes", "nodeLabels", "username", "sudo", "concurrency", "randomSeed", "writeProperty", "writeConcurrency", "writeRelationshipType");
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("nodeProperties", KnnNodePropertySpecParser.render(this.nodeProperties()));
        map.put("topK", this.topK());
        map.put("sampleRate", this.sampleRate());
        map.put("perturbationRate", this.perturbationRate());
        map.put("deltaThreshold", this.deltaThreshold());
        map.put("similarityCutoff", this.similarityCutoff());
        map.put("maxIterations", this.maxIterations());
        map.put("randomJoins", this.randomJoins());
        map.put("initialSampler", KnnSampler.SamplerType.toString(this.initialSampler()));
        map.put("relationshipTypes", this.relationshipTypes());
        map.put("nodeLabels", this.nodeLabels());
        map.put("username", this.usernameOverride());
        map.put("sudo", this.sudo());
        map.put("concurrency", this.concurrency());
        this.randomSeed().ifPresent(randomSeed -> map.put("randomSeed", randomSeed));
        map.put("writeProperty", this.writeProperty());
        map.put("writeConcurrency", this.writeConcurrency());
        map.put("writeRelationshipType", this.writeRelationshipType());
        return map;
    }

    public int concurrency() {
        return this.concurrency;
    }

    public Optional<Long> randomSeed() {
        return this.randomSeed;
    }

    public String writeProperty() {
        return this.writeProperty;
    }

    public int writeConcurrency() {
        return this.writeConcurrency;
    }

    public String writeRelationshipType() {
        return this.writeRelationshipType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Object> config = new HashMap<String, Object>();

        public Builder nodeProperties(Object nodeProperties) {
            this.config.put("nodeProperties", nodeProperties);
            return this;
        }

        public Builder topK(int topK) {
            this.config.put("topK", topK);
            return this;
        }

        public Builder sampleRate(double sampleRate) {
            this.config.put("sampleRate", sampleRate);
            return this;
        }

        public Builder perturbationRate(double perturbationRate) {
            this.config.put("perturbationRate", perturbationRate);
            return this;
        }

        public Builder deltaThreshold(double deltaThreshold) {
            this.config.put("deltaThreshold", deltaThreshold);
            return this;
        }

        public Builder similarityCutoff(double similarityCutoff) {
            this.config.put("similarityCutoff", similarityCutoff);
            return this;
        }

        public Builder maxIterations(int maxIterations) {
            this.config.put("maxIterations", maxIterations);
            return this;
        }

        public Builder randomJoins(int randomJoins) {
            this.config.put("randomJoins", randomJoins);
            return this;
        }

        public Builder initialSampler(Object initialSampler) {
            this.config.put("initialSampler", initialSampler);
            return this;
        }

        public Builder relationshipTypes(List<String> relationshipTypes) {
            this.config.put("relationshipTypes", relationshipTypes);
            return this;
        }

        public Builder nodeLabels(List<String> nodeLabels) {
            this.config.put("nodeLabels", nodeLabels);
            return this;
        }

        public Builder usernameOverride(String usernameOverride) {
            this.config.put("username", usernameOverride);
            return this;
        }

        public Builder sudo(boolean sudo) {
            this.config.put("sudo", sudo);
            return this;
        }

        public Builder concurrency(int concurrency) {
            this.config.put("concurrency", concurrency);
            return this;
        }

        public Builder randomSeed(Long randomSeed) {
            this.config.put("randomSeed", randomSeed);
            return this;
        }

        public Builder randomSeed(Optional<Long> randomSeed) {
            randomSeed.ifPresent(actualrandomSeed -> this.config.put("randomSeed", actualrandomSeed));
            return this;
        }

        public Builder writeProperty(String writeProperty) {
            this.config.put("writeProperty", writeProperty);
            return this;
        }

        public Builder writeConcurrency(int writeConcurrency) {
            this.config.put("writeConcurrency", writeConcurrency);
            return this;
        }

        public Builder writeRelationshipType(String writeRelationshipType) {
            this.config.put("writeRelationshipType", writeRelationshipType);
            return this;
        }

        public KnnWriteConfig build() {
            CypherMapWrapper config = CypherMapWrapper.create(this.config);
            return new KnnWriteConfigImpl(config);
        }
    }
}

