/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.knn;

import java.util.SplittableRandom;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.mem.MemoryUsage;
import org.neo4j.gds.similarity.SimilarityResult;

class NeighborList {
    static final int NOT_INSERTED = 0;
    private static final int INSERTED = 1;
    private final int elementCapacity;
    private int elementCount = 0;
    private final long[] priorityElementPairs;

    static MemoryEstimation memoryEstimation(int capacity) {
        return MemoryEstimations.builder(NeighborList.class).fixed("elements", MemoryUsage.sizeOfLongArray((long)(2L * (long)capacity))).build();
    }

    static long clearCheckedFlag(long value) {
        return value & Long.MAX_VALUE;
    }

    private static long setCheckedFlag(long value) {
        return value | Long.MIN_VALUE;
    }

    static boolean isChecked(long value) {
        return value < 0L;
    }

    NeighborList(int elementCapacity) {
        if (elementCapacity <= 0) {
            throw new IllegalArgumentException("Bound cannot be smaller than or equal to 0");
        }
        this.elementCapacity = elementCapacity;
        this.priorityElementPairs = new long[elementCapacity * 2];
    }

    public LongStream elements() {
        return IntStream.range(0, this.elementCount).mapToLong(index -> this.priorityElementPairs[index * 2 + 1]);
    }

    public int size() {
        return this.elementCount;
    }

    long elementAt(int index) {
        return this.priorityElementPairs[index * 2 + 1];
    }

    long getAndFlagAsChecked(int index) {
        long element = this.priorityElementPairs[index * 2 + 1];
        this.priorityElementPairs[index * 2 + 1] = NeighborList.setCheckedFlag(element);
        return element;
    }

    public long add(long element, double priority, SplittableRandom random, double perturbationRate) {
        int insertIdx = 0;
        int currNumElementsWithPriority = this.elementCount * 2;
        if (this.elementCount != 0) {
            int elementsWithPriorityCapacity;
            int lastValueIndex = (this.elementCount - 1) * 2;
            double lowestPriority = Double.longBitsToDouble(this.priorityElementPairs[lastValueIndex]);
            if (priority < lowestPriority && this.elementCount == this.elementCapacity) {
                return 0L;
            }
            int lowerBoundIdxInclusive = currNumElementsWithPriority;
            for (int i = 0; i < currNumElementsWithPriority; i += 2) {
                double storedPriority = Double.longBitsToDouble(this.priorityElementPairs[i]);
                if (!(priority >= storedPriority)) continue;
                lowerBoundIdxInclusive = i;
                break;
            }
            int upperBoundIdxExclusive = currNumElementsWithPriority;
            for (int i = lowerBoundIdxInclusive; i < currNumElementsWithPriority; i += 2) {
                double storedPriority = Double.longBitsToDouble(this.priorityElementPairs[i]);
                if (!(priority > storedPriority)) continue;
                upperBoundIdxExclusive = i;
                break;
            }
            if (upperBoundIdxExclusive == (elementsWithPriorityCapacity = this.elementCapacity * 2) && Double.compare(lowestPriority, priority) == 0) {
                if (perturbationRate > 0.0 && Double.compare(random.nextDouble(), perturbationRate) < 0) {
                    insertIdx = random.nextInt(lowerBoundIdxInclusive / 2, upperBoundIdxExclusive / 2) * 2;
                    this.priorityElementPairs[insertIdx] = Double.doubleToRawLongBits(priority);
                    this.priorityElementPairs[insertIdx + 1] = element;
                    return 1L;
                }
                return 0L;
            }
            if (lowerBoundIdxInclusive < currNumElementsWithPriority && Double.compare(priority, Double.longBitsToDouble(this.priorityElementPairs[lowerBoundIdxInclusive])) == 0) {
                int upperBound = Math.max(upperBoundIdxExclusive, lowerBoundIdxInclusive + 2);
                for (int i = lowerBoundIdxInclusive; i < upperBound; i += 2) {
                    if (NeighborList.clearCheckedFlag(this.priorityElementPairs[i + 1]) != element) continue;
                    return 0L;
                }
            }
            if ((insertIdx = lowerBoundIdxInclusive == upperBoundIdxExclusive ? lowerBoundIdxInclusive : random.nextInt(lowerBoundIdxInclusive / 2, upperBoundIdxExclusive / 2) * 2) != lastValueIndex || this.elementCount != this.elementCapacity) {
                System.arraycopy(this.priorityElementPairs, insertIdx, this.priorityElementPairs, insertIdx + 2, this.priorityElementPairs.length - insertIdx - 2);
            }
        }
        if (this.elementCount != this.elementCapacity) {
            ++this.elementCount;
        }
        this.priorityElementPairs[insertIdx] = Double.doubleToRawLongBits(priority);
        this.priorityElementPairs[insertIdx + 1] = element;
        return 1L;
    }

    public Stream<SimilarityResult> similarityStream(long nodeId) {
        return IntStream.range(0, this.elementCount).mapToObj(index -> {
            double neighborSimilarity = Double.longBitsToDouble(this.priorityElementPairs[index * 2]);
            long neighborId = NeighborList.clearCheckedFlag(this.priorityElementPairs[index * 2 + 1]);
            return new SimilarityResult(nodeId, neighborId, neighborSimilarity);
        });
    }

    public void filterHighSimilarityResults(double threshold) {
        for (int i = 0; i < this.elementCount; ++i) {
            if (!(Double.longBitsToDouble(this.priorityElementPairs[2 * i]) < threshold)) continue;
            this.elementCount = i;
            break;
        }
    }
}

