/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.knn;

import java.util.Arrays;

final class NeighborSort {
    private static final int RADIX = 8;
    private static final int HIST_SIZE = 256;

    public static int[] newHistogram(int length) {
        return new int[Math.max(length, 257)];
    }

    public static long[] newCopy(long[] data) {
        return new long[data.length];
    }

    public static void radixSort(long[] data, long[] copy, int[] histogram, int length) {
        NeighborSort.radixSort(data, copy, histogram, length, 0);
    }

    private static void radixSort(long[] data, long[] copy, int[] histogram, int length, int shift) {
        int hlen = Math.min(256, histogram.length - 1);
        int dlen = Math.min(length, Math.min(data.length, copy.length));
        long loMask = 255L << shift;
        long hiMask = -(256L << shift);
        while (shift < 64) {
            int i;
            Arrays.fill(histogram, 0, 1 + hlen, 0);
            int maxHistIndex = 0;
            long hiBits = 0L;
            for (i = 0; i < dlen; i += 2) {
                hiBits |= data[i] & hiMask;
                int histIndex = (int)((data[i] & loMask) >>> shift);
                maxHistIndex |= histIndex;
                int n = 1 + histIndex;
                histogram[n] = histogram[n] + 2;
            }
            if (hiBits == 0L && maxHistIndex == 0) {
                return;
            }
            if (maxHistIndex != 0) {
                for (i = 0; i < hlen; ++i) {
                    int n = i + 1;
                    histogram[n] = histogram[n] + histogram[i];
                }
                for (i = 0; i < dlen; i += 2) {
                    int n = (int)((data[i] & loMask) >>> shift);
                    int n2 = histogram[n] + 2;
                    histogram[n] = n2;
                    int out = n2;
                    copy[out - 2] = data[i];
                    copy[out - 1] = data[1 + i];
                }
                System.arraycopy(copy, 0, data, 0, dlen);
            }
            shift += 8;
            loMask <<= 8;
            hiMask <<= 8;
        }
    }

    private NeighborSort() {
    }
}

