/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.knn;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.LongArrayList;
import com.carrotsearch.hppc.cursors.IntCursor;
import java.util.SplittableRandom;
import org.neo4j.gds.core.utils.BiLongConsumer;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.similarity.knn.NeighborList;

final class SplitOldAndNewNeighbors
implements BiLongConsumer {
    private final SplittableRandom random;
    private final HugeObjectArray<NeighborList> neighbors;
    private final HugeObjectArray<LongArrayList> allOldNeighbors;
    private final HugeObjectArray<LongArrayList> allNewNeighbors;
    private final int sampledK;
    private final ProgressTracker progressTracker;

    SplitOldAndNewNeighbors(SplittableRandom random, HugeObjectArray<NeighborList> neighbors, HugeObjectArray<LongArrayList> allOldNeighbors, HugeObjectArray<LongArrayList> allNewNeighbors, int sampledK, ProgressTracker progressTracker) {
        this.random = random;
        this.neighbors = neighbors;
        this.allOldNeighbors = allOldNeighbors;
        this.allNewNeighbors = allNewNeighbors;
        this.sampledK = sampledK;
        this.progressTracker = progressTracker;
    }

    public void apply(long start, long end) {
        SplittableRandom rng = this.random.split();
        int sampledK = this.sampledK;
        HugeObjectArray<NeighborList> allNeighbors = this.neighbors;
        HugeObjectArray<LongArrayList> allNewNeighbors = this.allNewNeighbors;
        HugeObjectArray<LongArrayList> allOldNeighbors = this.allOldNeighbors;
        IntArrayList sampled = new IntArrayList(sampledK);
        for (long nodeId = start; nodeId < end; ++nodeId) {
            NeighborList neighbors = (NeighborList)allNeighbors.get(nodeId);
            int k2 = neighbors.size();
            sampled.clear();
            LongArrayList oldNeighbors = null;
            int newNeighborCount = 0;
            for (int neighborIndex = 0; neighborIndex < k2; ++neighborIndex) {
                long neighborElement = neighbors.elementAt(neighborIndex);
                if (NeighborList.isChecked(neighborElement)) {
                    if (oldNeighbors == null) {
                        oldNeighbors = new LongArrayList();
                        allOldNeighbors.set(nodeId, (Object)oldNeighbors);
                    }
                    long neighborNode = NeighborList.clearCheckedFlag(neighborElement);
                    oldNeighbors.add(neighborNode);
                    continue;
                }
                if (newNeighborCount < sampledK) {
                    sampled.add(neighborIndex);
                } else {
                    int randomNode = rng.nextInt(newNeighborCount + 1);
                    if (randomNode < sampledK) {
                        sampled.set(randomNode, neighborIndex);
                    }
                }
                ++newNeighborCount;
            }
            if (sampled.isEmpty()) continue;
            LongArrayList newNeighbors = new LongArrayList();
            allNewNeighbors.set(nodeId, (Object)newNeighbors);
            for (IntCursor neighborIndex : sampled) {
                long neighborNode = neighbors.getAndFlagAsChecked(neighborIndex.value);
                assert (nodeId != neighborNode);
                assert (neighborNode >= 0L);
                newNeighbors.add(neighborNode);
            }
        }
        this.progressTracker.logProgress(end - start);
    }
}

