/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.knn;

import java.util.SplittableRandom;
import java.util.function.LongPredicate;
import org.neo4j.gds.core.utils.mem.MemoryRange;
import org.neo4j.gds.mem.MemoryUsage;
import org.neo4j.gds.ml.core.samplers.LongUniformSamplerFromRange;
import org.neo4j.gds.similarity.knn.KnnSampler;

class UniformKnnSampler
implements KnnSampler {
    private final LongUniformSamplerFromRange uniformSamplerFromRange;
    private final long exclusiveMax;

    UniformKnnSampler(SplittableRandom random, long exclusiveMax) {
        this.uniformSamplerFromRange = new LongUniformSamplerFromRange(random);
        this.exclusiveMax = exclusiveMax;
    }

    public static MemoryRange memoryEstimation(long boundedK) {
        return LongUniformSamplerFromRange.memoryEstimation((long)boundedK).add(MemoryRange.of((long)MemoryUsage.sizeOfInstance(UniformKnnSampler.class)));
    }

    @Override
    public long[] sample(long unused, long lowerBoundOnValidSamplesInRange, int numberOfSamples, LongPredicate isInvalidSample) {
        return this.uniformSamplerFromRange.sample(0L, this.exclusiveMax, lowerBoundOnValidSamplesInRange, numberOfSamples, isInvalidSample);
    }
}

