/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.knn.metrics;

import java.util.List;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.similarity.knn.KnnNodePropertySpec;
import org.neo4j.gds.similarity.knn.metrics.SimilarityComputer;

final class CombinedSimilarityComputer
implements SimilarityComputer {
    private final SimilarityComputer[] similarityComputers;
    private final int numOfProperties;

    CombinedSimilarityComputer(Graph graph, List<KnnNodePropertySpec> propertyNames) {
        this.numOfProperties = propertyNames.size();
        this.similarityComputers = new SimilarityComputer[this.numOfProperties];
        for (int i = 0; i < this.numOfProperties; ++i) {
            this.similarityComputers[i] = SimilarityComputer.ofProperty(graph, propertyNames.get(i));
        }
    }

    @Override
    public double similarity(long firstNodeId, long secondNodeId) {
        double sum = 0.0;
        for (SimilarityComputer similarityComputer : this.similarityComputers) {
            sum += similarityComputer.safeSimilarity(firstNodeId, secondNodeId);
        }
        return sum / (double)this.numOfProperties;
    }
}

