/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.knn.metrics;

import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.similarity.knn.metrics.DoubleArraySimilarityMetric;
import org.neo4j.gds.similarity.knn.metrics.SimilarityComputer;

final class DoubleArrayPropertySimilarityComputer
implements SimilarityComputer {
    private final NodeProperties nodeProperties;
    private final DoubleArraySimilarityMetric metric;

    DoubleArrayPropertySimilarityComputer(NodeProperties nodeProperties, DoubleArraySimilarityMetric metric) {
        this.metric = metric;
        if (nodeProperties.valueType() != ValueType.DOUBLE_ARRAY) {
            throw new IllegalArgumentException("The property is not of type DOUBLE_ARRAY");
        }
        this.nodeProperties = nodeProperties;
    }

    @Override
    public double similarity(long firstNodeId, long secondNodeId) {
        double[] left = this.nodeProperties.doubleArrayValue(firstNodeId);
        double[] right = this.nodeProperties.doubleArrayValue(secondNodeId);
        return this.metric.compute(left, right);
    }
}

