/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.knn.metrics;

import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.similarity.knn.metrics.SimilarityComputer;

final class DoublePropertySimilarityComputer
implements SimilarityComputer {
    private final NodeProperties nodeProperties;

    DoublePropertySimilarityComputer(NodeProperties nodeProperties) {
        if (nodeProperties.valueType() != ValueType.DOUBLE) {
            throw new IllegalArgumentException("The property is not of type DOUBLE");
        }
        this.nodeProperties = nodeProperties;
    }

    @Override
    public double similarity(long firstNodeId, long secondNodeId) {
        double left = this.nodeProperties.doubleValue(firstNodeId);
        double right = this.nodeProperties.doubleValue(secondNodeId);
        return 1.0 / (1.0 + Math.abs(left - right));
    }
}

