/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.knn.metrics;

import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.similarity.knn.metrics.FloatArraySimilarityMetric;
import org.neo4j.gds.similarity.knn.metrics.SimilarityComputer;

final class FloatArrayPropertySimilarityComputer
implements SimilarityComputer {
    private final NodeProperties nodeProperties;
    private final FloatArraySimilarityMetric metric;

    FloatArrayPropertySimilarityComputer(NodeProperties nodeProperties, FloatArraySimilarityMetric metric) {
        this.metric = metric;
        if (nodeProperties.valueType() != ValueType.FLOAT_ARRAY) {
            throw new IllegalArgumentException("The property is not of type FLOAT_ARRAY");
        }
        this.nodeProperties = nodeProperties;
    }

    @Override
    public double similarity(long firstNodeId, long secondNodeId) {
        float[] left = this.nodeProperties.floatArrayValue(firstNodeId);
        float[] right = this.nodeProperties.floatArrayValue(secondNodeId);
        return this.metric.compute(left, right);
    }
}

