/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.knn.metrics;

import java.util.Arrays;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.api.nodeproperties.LongArrayNodeProperties;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;
import org.neo4j.gds.similarity.knn.metrics.LongArraySimilarityMetric;
import org.neo4j.gds.similarity.knn.metrics.SimilarityComputer;

final class LongArrayPropertySimilarityComputer
implements SimilarityComputer {
    private final NodeProperties nodeProperties;
    private final LongArraySimilarityMetric metric;

    LongArrayPropertySimilarityComputer(NodeProperties nodeProperties, LongArraySimilarityMetric metric) {
        if (nodeProperties.valueType() != ValueType.LONG_ARRAY) {
            throw new IllegalArgumentException("The property is not of type LONG_ARRAY");
        }
        this.nodeProperties = nodeProperties;
        this.metric = metric;
    }

    @Override
    public double similarity(long firstNodeId, long secondNodeId) {
        long[] left = this.nodeProperties.longArrayValue(firstNodeId);
        long[] right = this.nodeProperties.longArrayValue(secondNodeId);
        return this.metric.compute(left, right);
    }

    static final class SortedLongArrayProperties
    implements LongArrayNodeProperties {
        private final HugeObjectArray<long[]> properties;

        SortedLongArrayProperties(NodeProperties nodeProperties) {
            this.properties = HugeObjectArray.newArray(long[].class, (long)nodeProperties.size());
            this.properties.setAll(i -> {
                long[] value = (long[])nodeProperties.longArrayValue(i).clone();
                Arrays.parallelSort(value);
                return value;
            });
        }

        public long size() {
            return this.properties.size();
        }

        public long[] longArrayValue(long nodeId) {
            return (long[])this.properties.get(nodeId);
        }
    }
}

