/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.knn.metrics;

import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.similarity.knn.metrics.SimilarityComputer;

final class LongPropertySimilarityComputer
implements SimilarityComputer {
    private final NodeProperties nodeProperties;

    LongPropertySimilarityComputer(NodeProperties nodeProperties) {
        if (nodeProperties.valueType() != ValueType.LONG) {
            throw new IllegalArgumentException("The property is not of type LONG");
        }
        this.nodeProperties = nodeProperties;
    }

    @Override
    public double similarity(long firstNodeId, long secondNodeId) {
        long right;
        long left = this.nodeProperties.longValue(firstNodeId);
        long abs = Math.abs(left - (right = this.nodeProperties.longValue(secondNodeId)));
        if (abs == Long.MIN_VALUE) {
            abs = Long.MAX_VALUE;
        }
        return 1.0 / (1.0 + (double)abs);
    }
}

