/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.knn.metrics;

import java.util.List;
import java.util.Objects;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.similarity.knn.KnnNodePropertySpec;
import org.neo4j.gds.similarity.knn.metrics.CombinedSimilarityComputer;
import org.neo4j.gds.similarity.knn.metrics.Cosine;
import org.neo4j.gds.similarity.knn.metrics.DoubleArrayPropertySimilarityComputer;
import org.neo4j.gds.similarity.knn.metrics.DoublePropertySimilarityComputer;
import org.neo4j.gds.similarity.knn.metrics.Euclidean;
import org.neo4j.gds.similarity.knn.metrics.FloatArrayPropertySimilarityComputer;
import org.neo4j.gds.similarity.knn.metrics.Jaccard;
import org.neo4j.gds.similarity.knn.metrics.LongArrayPropertySimilarityComputer;
import org.neo4j.gds.similarity.knn.metrics.LongPropertySimilarityComputer;
import org.neo4j.gds.similarity.knn.metrics.NullCheckingNodeProperties;
import org.neo4j.gds.similarity.knn.metrics.Overlap;
import org.neo4j.gds.similarity.knn.metrics.Pearson;
import org.neo4j.gds.similarity.knn.metrics.SimilarityMetric;
import org.neo4j.gds.utils.StringFormatting;

public interface SimilarityComputer {
    default public double safeSimilarity(long firstNodeId, long secondNodeId) {
        double similarity = this.similarity(firstNodeId, secondNodeId);
        return Double.isFinite(similarity) ? similarity : 0.0;
    }

    public double similarity(long var1, long var3);

    public static SimilarityComputer ofProperties(Graph graph, List<KnnNodePropertySpec> knnNodeProperties) {
        if (knnNodeProperties.size() == 1) {
            return SimilarityComputer.ofProperty(graph, knnNodeProperties.get(0));
        }
        return new CombinedSimilarityComputer(graph, knnNodeProperties);
    }

    public static SimilarityComputer ofProperty(Graph graph, KnnNodePropertySpec knnNodePropertySpec) {
        String propertyName = knnNodePropertySpec.name();
        NodeProperties nodeProperties = Objects.requireNonNull(graph.nodeProperties(propertyName), () -> StringFormatting.formatWithLocale((String)"The property `%s` has not been loaded", (Object[])new Object[]{propertyName}));
        if (knnNodePropertySpec.metric() == SimilarityMetric.DEFAULT) {
            knnNodePropertySpec.setMetric(SimilarityMetric.defaultMetricForType(nodeProperties.valueType()));
        }
        return SimilarityComputer.ofProperty((IdMap)graph, propertyName, nodeProperties, knnNodePropertySpec.metric());
    }

    public static SimilarityComputer ofProperty(IdMap idMap, String propertyName, NodeProperties nodeProperties) {
        return SimilarityComputer.ofProperty(idMap, propertyName, nodeProperties, SimilarityMetric.defaultMetricForType(nodeProperties.valueType()));
    }

    public static SimilarityComputer ofProperty(IdMap idMap, String name, NodeProperties properties, SimilarityMetric defaultSimilarityMetric) {
        switch (properties.valueType()) {
            case LONG: {
                return SimilarityComputer.ofLongProperty(properties);
            }
            case DOUBLE: {
                return SimilarityComputer.ofDoubleProperty(properties);
            }
            case DOUBLE_ARRAY: {
                return SimilarityComputer.ofDoubleArrayProperty(name, NullCheckingNodeProperties.create(properties, name, idMap), defaultSimilarityMetric);
            }
            case FLOAT_ARRAY: {
                return SimilarityComputer.ofFloatArrayProperty(name, NullCheckingNodeProperties.create(properties, name, idMap), defaultSimilarityMetric);
            }
            case LONG_ARRAY: {
                return SimilarityComputer.ofLongArrayProperty(name, (NodeProperties)new LongArrayPropertySimilarityComputer.SortedLongArrayProperties(NullCheckingNodeProperties.create(properties, name, idMap)), defaultSimilarityMetric);
            }
        }
        throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"The property [%s] has an unsupported type [%s].", (Object[])new Object[]{name, properties.valueType()}));
    }

    public static SimilarityComputer ofDoubleProperty(NodeProperties nodeProperties) {
        return new DoublePropertySimilarityComputer(nodeProperties);
    }

    public static SimilarityComputer ofLongProperty(NodeProperties nodeProperties) {
        return new LongPropertySimilarityComputer(nodeProperties);
    }

    public static SimilarityComputer ofFloatArrayProperty(String name, NodeProperties properties, SimilarityMetric metric) {
        switch (metric) {
            case COSINE: {
                return new FloatArrayPropertySimilarityComputer(properties, Cosine::floatMetric);
            }
            case EUCLIDEAN: {
                return new FloatArrayPropertySimilarityComputer(properties, Euclidean::floatMetric);
            }
            case PEARSON: {
                return new FloatArrayPropertySimilarityComputer(properties, Pearson::floatMetric);
            }
        }
        throw SimilarityComputer.unsupportedSimilarityMetric(name, properties.valueType(), metric);
    }

    public static SimilarityComputer ofDoubleArrayProperty(String propertyName, NodeProperties nodeProperties, SimilarityMetric similarityMetric) {
        switch (similarityMetric) {
            case COSINE: {
                return new DoubleArrayPropertySimilarityComputer(nodeProperties, Cosine::doubleMetric);
            }
            case EUCLIDEAN: {
                return new DoubleArrayPropertySimilarityComputer(nodeProperties, Euclidean::doubleMetric);
            }
            case PEARSON: {
                return new DoubleArrayPropertySimilarityComputer(nodeProperties, Pearson::doubleMetric);
            }
        }
        throw SimilarityComputer.unsupportedSimilarityMetric(propertyName, nodeProperties.valueType(), similarityMetric);
    }

    public static SimilarityComputer ofLongArrayProperty(String propertyName, NodeProperties nodeProperties, SimilarityMetric similarityMetric) {
        switch (similarityMetric) {
            case JACCARD: {
                return new LongArrayPropertySimilarityComputer(nodeProperties, Jaccard::metric);
            }
            case OVERLAP: {
                return new LongArrayPropertySimilarityComputer(nodeProperties, Overlap::metric);
            }
        }
        throw SimilarityComputer.unsupportedSimilarityMetric(propertyName, nodeProperties.valueType(), similarityMetric);
    }

    public static IllegalArgumentException unsupportedSimilarityMetric(String propertyName, ValueType valueType, SimilarityMetric similarityMetric) {
        return new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Similarity metric [%s] is not supported for property [%s] of type [%s].", (Object[])new Object[]{propertyName, similarityMetric, valueType}));
    }
}

