/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.nodesim;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.ConcurrencyConfig;
import org.neo4j.gds.config.MutatePropertyConfig;
import org.neo4j.gds.config.MutateRelationshipConfig;
import org.neo4j.gds.config.RelationshipWeightConfig;
import org.neo4j.gds.similarity.nodesim.NodeSimilarityBaseConfig;
import org.neo4j.gds.similarity.nodesim.NodeSimilarityMutateConfig;

@Generated(from="NodeSimilarityMutateConfig", generator="Immutables")
public final class ImmutableNodeSimilarityMutateConfig
implements NodeSimilarityMutateConfig {
    @Nullable
    private final String usernameOverride;
    private final boolean sudo;
    private final Collection<String> configKeys;
    private final transient Map<String, Object> toMap;
    private final int concurrency;
    private final int minBatchSize;
    private final List<String> relationshipTypes;
    private final List<String> nodeLabels;
    @Nullable
    private final String relationshipWeightProperty;
    private final transient boolean hasRelationshipWeightProperty;
    private final double similarityCutoff;
    private final String similarityMetric;
    private final int degreeCutoff;
    private final int topK;
    private final int topN;
    private final int bottomK;
    private final int bottomN;
    private final transient int normalizedK;
    private final transient int normalizedN;
    private final transient boolean isParallel;
    private final transient boolean hasTopK;
    private final transient boolean hasTopN;
    private final transient boolean computeToGraph;
    private final String mutateProperty;
    private final String mutateRelationshipType;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableNodeSimilarityMutateConfig(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, @Nullable String relationshipWeightProperty, double similarityCutoff, String similarityMetric, int degreeCutoff, int topK, int topN, int bottomK, int bottomN, String mutateProperty, String mutateRelationshipType) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(ImmutableNodeSimilarityMutateConfig.createUnmodifiableList(false, ImmutableNodeSimilarityMutateConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableNodeSimilarityMutateConfig.createUnmodifiableList(false, ImmutableNodeSimilarityMutateConfig.createSafeList(nodeLabels, true, false)));
        this.initShim.relationshipWeightProperty(relationshipWeightProperty);
        this.initShim.similarityCutoff(similarityCutoff);
        this.initShim.similarityMetric(Objects.requireNonNull(similarityMetric, "similarityMetric"));
        this.initShim.degreeCutoff(degreeCutoff);
        this.initShim.topK(topK);
        this.initShim.topN(topN);
        this.initShim.bottomK(bottomK);
        this.initShim.bottomN(bottomN);
        this.mutateProperty = Objects.requireNonNull(mutateProperty, "mutateProperty");
        this.mutateRelationshipType = Objects.requireNonNull(mutateRelationshipType, "mutateRelationshipType");
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.relationshipWeightProperty = this.initShim.relationshipWeightProperty();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.similarityCutoff = this.initShim.similarityCutoff();
        this.similarityMetric = this.initShim.similarityMetric();
        this.degreeCutoff = this.initShim.degreeCutoff();
        this.topK = this.initShim.topK();
        this.topN = this.initShim.topN();
        this.bottomK = this.initShim.bottomK();
        this.bottomN = this.initShim.bottomN();
        this.normalizedK = this.initShim.normalizedK();
        this.normalizedN = this.initShim.normalizedN();
        this.isParallel = this.initShim.isParallel();
        this.hasTopK = this.initShim.hasTopK();
        this.hasTopN = this.initShim.hasTopN();
        this.computeToGraph = this.initShim.computeToGraph();
        this.initShim = null;
    }

    private ImmutableNodeSimilarityMutateConfig(Builder builder) {
        this.mutateProperty = builder.mutateProperty;
        this.mutateRelationshipType = builder.mutateRelationshipType;
        if (builder.usernameOverrideIsSet()) {
            this.initShim.usernameOverride(builder.usernameOverride);
        }
        if (builder.sudoIsSet()) {
            this.initShim.sudo(builder.sudo);
        }
        if (builder.configKeys != null) {
            this.initShim.configKeys(builder.configKeys);
        }
        if (builder.concurrencyIsSet()) {
            this.initShim.concurrency(builder.concurrency);
        }
        if (builder.minBatchSizeIsSet()) {
            this.initShim.minBatchSize(builder.minBatchSize);
        }
        if (builder.relationshipTypesIsSet()) {
            this.initShim.relationshipTypes(builder.relationshipTypes == null ? Collections.emptyList() : ImmutableNodeSimilarityMutateConfig.createUnmodifiableList(true, builder.relationshipTypes));
        }
        if (builder.nodeLabelsIsSet()) {
            this.initShim.nodeLabels(builder.nodeLabels == null ? Collections.emptyList() : ImmutableNodeSimilarityMutateConfig.createUnmodifiableList(true, builder.nodeLabels));
        }
        if (builder.relationshipWeightPropertyIsSet()) {
            this.initShim.relationshipWeightProperty(builder.relationshipWeightProperty);
        }
        if (builder.similarityCutoffIsSet()) {
            this.initShim.similarityCutoff(builder.similarityCutoff);
        }
        if (builder.similarityMetric != null) {
            this.initShim.similarityMetric(builder.similarityMetric);
        }
        if (builder.degreeCutoffIsSet()) {
            this.initShim.degreeCutoff(builder.degreeCutoff);
        }
        if (builder.topKIsSet()) {
            this.initShim.topK(builder.topK);
        }
        if (builder.topNIsSet()) {
            this.initShim.topN(builder.topN);
        }
        if (builder.bottomKIsSet()) {
            this.initShim.bottomK(builder.bottomK);
        }
        if (builder.bottomNIsSet()) {
            this.initShim.bottomN(builder.bottomN);
        }
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.relationshipWeightProperty = this.initShim.relationshipWeightProperty();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.similarityCutoff = this.initShim.similarityCutoff();
        this.similarityMetric = this.initShim.similarityMetric();
        this.degreeCutoff = this.initShim.degreeCutoff();
        this.topK = this.initShim.topK();
        this.topN = this.initShim.topN();
        this.bottomK = this.initShim.bottomK();
        this.bottomN = this.initShim.bottomN();
        this.normalizedK = this.initShim.normalizedK();
        this.normalizedN = this.initShim.normalizedN();
        this.isParallel = this.initShim.isParallel();
        this.hasTopK = this.initShim.hasTopK();
        this.hasTopN = this.initShim.hasTopN();
        this.computeToGraph = this.initShim.computeToGraph();
        this.initShim = null;
    }

    private ImmutableNodeSimilarityMutateConfig(@Nullable String usernameOverride, boolean sudo, Collection<String> configKeys, int concurrency, int minBatchSize, List<String> relationshipTypes, List<String> nodeLabels, @Nullable String relationshipWeightProperty, double similarityCutoff, String similarityMetric, int degreeCutoff, int topK, int topN, int bottomK, int bottomN, String mutateProperty, String mutateRelationshipType) {
        this.initShim.usernameOverride(usernameOverride);
        this.initShim.sudo(sudo);
        this.initShim.configKeys(configKeys);
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(relationshipTypes);
        this.initShim.nodeLabels(nodeLabels);
        this.initShim.relationshipWeightProperty(relationshipWeightProperty);
        this.initShim.similarityCutoff(similarityCutoff);
        this.initShim.similarityMetric(similarityMetric);
        this.initShim.degreeCutoff(degreeCutoff);
        this.initShim.topK(topK);
        this.initShim.topN(topN);
        this.initShim.bottomK(bottomK);
        this.initShim.bottomN(bottomN);
        this.mutateProperty = mutateProperty;
        this.mutateRelationshipType = mutateRelationshipType;
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.relationshipWeightProperty = this.initShim.relationshipWeightProperty();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.similarityCutoff = this.initShim.similarityCutoff();
        this.similarityMetric = this.initShim.similarityMetric();
        this.degreeCutoff = this.initShim.degreeCutoff();
        this.topK = this.initShim.topK();
        this.topN = this.initShim.topN();
        this.bottomK = this.initShim.bottomK();
        this.bottomN = this.initShim.bottomN();
        this.normalizedK = this.initShim.normalizedK();
        this.normalizedN = this.initShim.normalizedN();
        this.isParallel = this.initShim.isParallel();
        this.hasTopK = this.initShim.hasTopK();
        this.hasTopN = this.initShim.hasTopN();
        this.computeToGraph = this.initShim.computeToGraph();
        this.initShim = null;
    }

    @Nullable
    private String usernameOverrideInitialize() {
        return NodeSimilarityMutateConfig.super.usernameOverride();
    }

    private boolean sudoInitialize() {
        return NodeSimilarityMutateConfig.super.sudo();
    }

    private Collection<String> configKeysInitialize() {
        return NodeSimilarityMutateConfig.super.configKeys();
    }

    private Map<String, Object> toMapInitialize() {
        return NodeSimilarityMutateConfig.super.toMap();
    }

    private int concurrencyInitialize() {
        return NodeSimilarityMutateConfig.super.concurrency();
    }

    private int minBatchSizeInitialize() {
        return NodeSimilarityMutateConfig.super.minBatchSize();
    }

    private List<String> relationshipTypesInitialize() {
        return NodeSimilarityMutateConfig.super.relationshipTypes();
    }

    private List<String> nodeLabelsInitialize() {
        return NodeSimilarityMutateConfig.super.nodeLabels();
    }

    @Nullable
    private String relationshipWeightPropertyInitialize() {
        return NodeSimilarityMutateConfig.super.relationshipWeightProperty();
    }

    private boolean hasRelationshipWeightPropertyInitialize() {
        return NodeSimilarityMutateConfig.super.hasRelationshipWeightProperty();
    }

    private double similarityCutoffInitialize() {
        return NodeSimilarityMutateConfig.super.similarityCutoff();
    }

    private String similarityMetricInitialize() {
        return NodeSimilarityMutateConfig.super.similarityMetric();
    }

    private int degreeCutoffInitialize() {
        return NodeSimilarityMutateConfig.super.degreeCutoff();
    }

    private int topKInitialize() {
        return NodeSimilarityMutateConfig.super.topK();
    }

    private int topNInitialize() {
        return NodeSimilarityMutateConfig.super.topN();
    }

    private int bottomKInitialize() {
        return NodeSimilarityMutateConfig.super.bottomK();
    }

    private int bottomNInitialize() {
        return NodeSimilarityMutateConfig.super.bottomN();
    }

    private int normalizedKInitialize() {
        return NodeSimilarityMutateConfig.super.normalizedK();
    }

    private int normalizedNInitialize() {
        return NodeSimilarityMutateConfig.super.normalizedN();
    }

    private boolean isParallelInitialize() {
        return NodeSimilarityMutateConfig.super.isParallel();
    }

    private boolean hasTopKInitialize() {
        return NodeSimilarityMutateConfig.super.hasTopK();
    }

    private boolean hasTopNInitialize() {
        return NodeSimilarityMutateConfig.super.hasTopN();
    }

    private boolean computeToGraphInitialize() {
        return NodeSimilarityMutateConfig.super.computeToGraph();
    }

    @Nullable
    public String usernameOverride() {
        InitShim shim = this.initShim;
        return shim != null ? shim.usernameOverride() : this.usernameOverride;
    }

    public boolean sudo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sudo() : this.sudo;
    }

    public Collection<String> configKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.configKeys() : this.configKeys;
    }

    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    public int concurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.concurrency() : this.concurrency;
    }

    public int minBatchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.minBatchSize() : this.minBatchSize;
    }

    public List<String> relationshipTypes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipTypes() : this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nodeLabels() : this.nodeLabels;
    }

    @Nullable
    public String relationshipWeightProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipWeightProperty() : this.relationshipWeightProperty;
    }

    public boolean hasRelationshipWeightProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasRelationshipWeightProperty() : this.hasRelationshipWeightProperty;
    }

    @Override
    public double similarityCutoff() {
        InitShim shim = this.initShim;
        return shim != null ? shim.similarityCutoff() : this.similarityCutoff;
    }

    @Override
    public String similarityMetric() {
        InitShim shim = this.initShim;
        return shim != null ? shim.similarityMetric() : this.similarityMetric;
    }

    @Override
    public int degreeCutoff() {
        InitShim shim = this.initShim;
        return shim != null ? shim.degreeCutoff() : this.degreeCutoff;
    }

    @Override
    public int topK() {
        InitShim shim = this.initShim;
        return shim != null ? shim.topK() : this.topK;
    }

    @Override
    public int topN() {
        InitShim shim = this.initShim;
        return shim != null ? shim.topN() : this.topN;
    }

    @Override
    public int bottomK() {
        InitShim shim = this.initShim;
        return shim != null ? shim.bottomK() : this.bottomK;
    }

    @Override
    public int bottomN() {
        InitShim shim = this.initShim;
        return shim != null ? shim.bottomN() : this.bottomN;
    }

    @Override
    public int normalizedK() {
        InitShim shim = this.initShim;
        return shim != null ? shim.normalizedK() : this.normalizedK;
    }

    @Override
    public int normalizedN() {
        InitShim shim = this.initShim;
        return shim != null ? shim.normalizedN() : this.normalizedN;
    }

    @Override
    public boolean isParallel() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isParallel() : this.isParallel;
    }

    @Override
    public boolean hasTopK() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasTopK() : this.hasTopK;
    }

    @Override
    public boolean hasTopN() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasTopN() : this.hasTopN;
    }

    @Override
    public boolean computeToGraph() {
        InitShim shim = this.initShim;
        return shim != null ? shim.computeToGraph() : this.computeToGraph;
    }

    public String mutateProperty() {
        return this.mutateProperty;
    }

    public String mutateRelationshipType() {
        return this.mutateRelationshipType;
    }

    public final ImmutableNodeSimilarityMutateConfig withUsernameOverride(@Nullable String value) {
        if (Objects.equals(this.usernameOverride, value)) {
            return this;
        }
        return ImmutableNodeSimilarityMutateConfig.validate(new ImmutableNodeSimilarityMutateConfig(value, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.similarityCutoff, this.similarityMetric, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.mutateProperty, this.mutateRelationshipType));
    }

    public final ImmutableNodeSimilarityMutateConfig withSudo(boolean value) {
        if (this.sudo == value) {
            return this;
        }
        return ImmutableNodeSimilarityMutateConfig.validate(new ImmutableNodeSimilarityMutateConfig(this.usernameOverride, value, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.similarityCutoff, this.similarityMetric, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.mutateProperty, this.mutateRelationshipType));
    }

    public final ImmutableNodeSimilarityMutateConfig withConfigKeys(Collection<String> value) {
        if (this.configKeys == value) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(value, "configKeys");
        return ImmutableNodeSimilarityMutateConfig.validate(new ImmutableNodeSimilarityMutateConfig(this.usernameOverride, this.sudo, newValue, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.similarityCutoff, this.similarityMetric, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.mutateProperty, this.mutateRelationshipType));
    }

    public final ImmutableNodeSimilarityMutateConfig withConcurrency(int value) {
        if (this.concurrency == value) {
            return this;
        }
        return ImmutableNodeSimilarityMutateConfig.validate(new ImmutableNodeSimilarityMutateConfig(this.usernameOverride, this.sudo, this.configKeys, value, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.similarityCutoff, this.similarityMetric, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.mutateProperty, this.mutateRelationshipType));
    }

    public final ImmutableNodeSimilarityMutateConfig withMinBatchSize(int value) {
        if (this.minBatchSize == value) {
            return this;
        }
        return ImmutableNodeSimilarityMutateConfig.validate(new ImmutableNodeSimilarityMutateConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, value, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.similarityCutoff, this.similarityMetric, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.mutateProperty, this.mutateRelationshipType));
    }

    public final ImmutableNodeSimilarityMutateConfig withRelationshipTypes(String ... elements) {
        List<String> newValue = ImmutableNodeSimilarityMutateConfig.createUnmodifiableList(false, ImmutableNodeSimilarityMutateConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableNodeSimilarityMutateConfig.validate(new ImmutableNodeSimilarityMutateConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, newValue, this.nodeLabels, this.relationshipWeightProperty, this.similarityCutoff, this.similarityMetric, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.mutateProperty, this.mutateRelationshipType));
    }

    public final ImmutableNodeSimilarityMutateConfig withRelationshipTypes(Iterable<String> elements) {
        if (this.relationshipTypes == elements) {
            return this;
        }
        List<String> newValue = ImmutableNodeSimilarityMutateConfig.createUnmodifiableList(false, ImmutableNodeSimilarityMutateConfig.createSafeList(elements, true, false));
        return ImmutableNodeSimilarityMutateConfig.validate(new ImmutableNodeSimilarityMutateConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, newValue, this.nodeLabels, this.relationshipWeightProperty, this.similarityCutoff, this.similarityMetric, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.mutateProperty, this.mutateRelationshipType));
    }

    public final ImmutableNodeSimilarityMutateConfig withNodeLabels(String ... elements) {
        List<String> newValue = ImmutableNodeSimilarityMutateConfig.createUnmodifiableList(false, ImmutableNodeSimilarityMutateConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableNodeSimilarityMutateConfig.validate(new ImmutableNodeSimilarityMutateConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, newValue, this.relationshipWeightProperty, this.similarityCutoff, this.similarityMetric, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.mutateProperty, this.mutateRelationshipType));
    }

    public final ImmutableNodeSimilarityMutateConfig withNodeLabels(Iterable<String> elements) {
        if (this.nodeLabels == elements) {
            return this;
        }
        List<String> newValue = ImmutableNodeSimilarityMutateConfig.createUnmodifiableList(false, ImmutableNodeSimilarityMutateConfig.createSafeList(elements, true, false));
        return ImmutableNodeSimilarityMutateConfig.validate(new ImmutableNodeSimilarityMutateConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, newValue, this.relationshipWeightProperty, this.similarityCutoff, this.similarityMetric, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.mutateProperty, this.mutateRelationshipType));
    }

    public final ImmutableNodeSimilarityMutateConfig withRelationshipWeightProperty(@Nullable String value) {
        if (Objects.equals(this.relationshipWeightProperty, value)) {
            return this;
        }
        return ImmutableNodeSimilarityMutateConfig.validate(new ImmutableNodeSimilarityMutateConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, value, this.similarityCutoff, this.similarityMetric, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.mutateProperty, this.mutateRelationshipType));
    }

    public final ImmutableNodeSimilarityMutateConfig withSimilarityCutoff(double value) {
        if (Double.doubleToLongBits(this.similarityCutoff) == Double.doubleToLongBits(value)) {
            return this;
        }
        return ImmutableNodeSimilarityMutateConfig.validate(new ImmutableNodeSimilarityMutateConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, value, this.similarityMetric, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.mutateProperty, this.mutateRelationshipType));
    }

    public final ImmutableNodeSimilarityMutateConfig withSimilarityMetric(String value) {
        String newValue = Objects.requireNonNull(value, "similarityMetric");
        if (this.similarityMetric.equals(newValue)) {
            return this;
        }
        return ImmutableNodeSimilarityMutateConfig.validate(new ImmutableNodeSimilarityMutateConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.similarityCutoff, newValue, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.mutateProperty, this.mutateRelationshipType));
    }

    public final ImmutableNodeSimilarityMutateConfig withDegreeCutoff(int value) {
        if (this.degreeCutoff == value) {
            return this;
        }
        return ImmutableNodeSimilarityMutateConfig.validate(new ImmutableNodeSimilarityMutateConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.similarityCutoff, this.similarityMetric, value, this.topK, this.topN, this.bottomK, this.bottomN, this.mutateProperty, this.mutateRelationshipType));
    }

    public final ImmutableNodeSimilarityMutateConfig withTopK(int value) {
        if (this.topK == value) {
            return this;
        }
        return ImmutableNodeSimilarityMutateConfig.validate(new ImmutableNodeSimilarityMutateConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.similarityCutoff, this.similarityMetric, this.degreeCutoff, value, this.topN, this.bottomK, this.bottomN, this.mutateProperty, this.mutateRelationshipType));
    }

    public final ImmutableNodeSimilarityMutateConfig withTopN(int value) {
        if (this.topN == value) {
            return this;
        }
        return ImmutableNodeSimilarityMutateConfig.validate(new ImmutableNodeSimilarityMutateConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.similarityCutoff, this.similarityMetric, this.degreeCutoff, this.topK, value, this.bottomK, this.bottomN, this.mutateProperty, this.mutateRelationshipType));
    }

    public final ImmutableNodeSimilarityMutateConfig withBottomK(int value) {
        if (this.bottomK == value) {
            return this;
        }
        return ImmutableNodeSimilarityMutateConfig.validate(new ImmutableNodeSimilarityMutateConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.similarityCutoff, this.similarityMetric, this.degreeCutoff, this.topK, this.topN, value, this.bottomN, this.mutateProperty, this.mutateRelationshipType));
    }

    public final ImmutableNodeSimilarityMutateConfig withBottomN(int value) {
        if (this.bottomN == value) {
            return this;
        }
        return ImmutableNodeSimilarityMutateConfig.validate(new ImmutableNodeSimilarityMutateConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.similarityCutoff, this.similarityMetric, this.degreeCutoff, this.topK, this.topN, this.bottomK, value, this.mutateProperty, this.mutateRelationshipType));
    }

    public final ImmutableNodeSimilarityMutateConfig withMutateProperty(String value) {
        String newValue = Objects.requireNonNull(value, "mutateProperty");
        if (this.mutateProperty.equals(newValue)) {
            return this;
        }
        return ImmutableNodeSimilarityMutateConfig.validate(new ImmutableNodeSimilarityMutateConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.similarityCutoff, this.similarityMetric, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, newValue, this.mutateRelationshipType));
    }

    public final ImmutableNodeSimilarityMutateConfig withMutateRelationshipType(String value) {
        String newValue = Objects.requireNonNull(value, "mutateRelationshipType");
        if (this.mutateRelationshipType.equals(newValue)) {
            return this;
        }
        return ImmutableNodeSimilarityMutateConfig.validate(new ImmutableNodeSimilarityMutateConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.similarityCutoff, this.similarityMetric, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.mutateProperty, newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNodeSimilarityMutateConfig && this.equalTo((ImmutableNodeSimilarityMutateConfig)another);
    }

    private boolean equalTo(ImmutableNodeSimilarityMutateConfig another) {
        return Objects.equals(this.usernameOverride, another.usernameOverride) && this.sudo == another.sudo && this.concurrency == another.concurrency && this.minBatchSize == another.minBatchSize && this.relationshipTypes.equals(another.relationshipTypes) && this.nodeLabels.equals(another.nodeLabels) && Objects.equals(this.relationshipWeightProperty, another.relationshipWeightProperty) && this.hasRelationshipWeightProperty == another.hasRelationshipWeightProperty && Double.doubleToLongBits(this.similarityCutoff) == Double.doubleToLongBits(another.similarityCutoff) && this.similarityMetric.equals(another.similarityMetric) && this.degreeCutoff == another.degreeCutoff && this.topK == another.topK && this.topN == another.topN && this.bottomK == another.bottomK && this.bottomN == another.bottomN && this.normalizedK == another.normalizedK && this.normalizedN == another.normalizedN && this.isParallel == another.isParallel && this.hasTopK == another.hasTopK && this.hasTopN == another.hasTopN && this.computeToGraph == another.computeToGraph && this.mutateProperty.equals(another.mutateProperty) && this.mutateRelationshipType.equals(another.mutateRelationshipType);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.usernameOverride);
        h += (h << 5) + Boolean.hashCode(this.sudo);
        h += (h << 5) + this.concurrency;
        h += (h << 5) + this.minBatchSize;
        h += (h << 5) + this.relationshipTypes.hashCode();
        h += (h << 5) + this.nodeLabels.hashCode();
        h += (h << 5) + Objects.hashCode(this.relationshipWeightProperty);
        h += (h << 5) + Boolean.hashCode(this.hasRelationshipWeightProperty);
        h += (h << 5) + Double.hashCode(this.similarityCutoff);
        h += (h << 5) + this.similarityMetric.hashCode();
        h += (h << 5) + this.degreeCutoff;
        h += (h << 5) + this.topK;
        h += (h << 5) + this.topN;
        h += (h << 5) + this.bottomK;
        h += (h << 5) + this.bottomN;
        h += (h << 5) + this.normalizedK;
        h += (h << 5) + this.normalizedN;
        h += (h << 5) + Boolean.hashCode(this.isParallel);
        h += (h << 5) + Boolean.hashCode(this.hasTopK);
        h += (h << 5) + Boolean.hashCode(this.hasTopN);
        h += (h << 5) + Boolean.hashCode(this.computeToGraph);
        h += (h << 5) + this.mutateProperty.hashCode();
        h += (h << 5) + this.mutateRelationshipType.hashCode();
        return h;
    }

    public String toString() {
        return "NodeSimilarityMutateConfig{usernameOverride=" + this.usernameOverride + ", sudo=" + this.sudo + ", concurrency=" + this.concurrency + ", minBatchSize=" + this.minBatchSize + ", relationshipTypes=" + this.relationshipTypes + ", nodeLabels=" + this.nodeLabels + ", relationshipWeightProperty=" + this.relationshipWeightProperty + ", hasRelationshipWeightProperty=" + this.hasRelationshipWeightProperty + ", similarityCutoff=" + this.similarityCutoff + ", similarityMetric=" + this.similarityMetric + ", degreeCutoff=" + this.degreeCutoff + ", topK=" + this.topK + ", topN=" + this.topN + ", bottomK=" + this.bottomK + ", bottomN=" + this.bottomN + ", normalizedK=" + this.normalizedK + ", normalizedN=" + this.normalizedN + ", isParallel=" + this.isParallel + ", hasTopK=" + this.hasTopK + ", hasTopN=" + this.hasTopN + ", computeToGraph=" + this.computeToGraph + ", mutateProperty=" + this.mutateProperty + ", mutateRelationshipType=" + this.mutateRelationshipType + "}";
    }

    public static NodeSimilarityMutateConfig of(int concurrency, int minBatchSize, List<String> relationshipTypes, List<String> nodeLabels, @Nullable String relationshipWeightProperty, double similarityCutoff, String similarityMetric, int degreeCutoff, int topK, int topN, int bottomK, int bottomN, String mutateProperty, String mutateRelationshipType) {
        return ImmutableNodeSimilarityMutateConfig.of(concurrency, minBatchSize, relationshipTypes, nodeLabels, relationshipWeightProperty, similarityCutoff, similarityMetric, degreeCutoff, topK, topN, bottomK, bottomN, mutateProperty, mutateRelationshipType);
    }

    public static NodeSimilarityMutateConfig of(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, @Nullable String relationshipWeightProperty, double similarityCutoff, String similarityMetric, int degreeCutoff, int topK, int topN, int bottomK, int bottomN, String mutateProperty, String mutateRelationshipType) {
        return ImmutableNodeSimilarityMutateConfig.validate(new ImmutableNodeSimilarityMutateConfig(concurrency, minBatchSize, relationshipTypes, nodeLabels, relationshipWeightProperty, similarityCutoff, similarityMetric, degreeCutoff, topK, topN, bottomK, bottomN, mutateProperty, mutateRelationshipType));
    }

    private static ImmutableNodeSimilarityMutateConfig validate(ImmutableNodeSimilarityMutateConfig instance) {
        instance.validate();
        instance.validateConcurrency();
        return instance;
    }

    public static NodeSimilarityMutateConfig copyOf(NodeSimilarityMutateConfig instance) {
        if (instance instanceof ImmutableNodeSimilarityMutateConfig) {
            return (ImmutableNodeSimilarityMutateConfig)instance;
        }
        return ImmutableNodeSimilarityMutateConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="NodeSimilarityMutateConfig", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_MUTATE_PROPERTY = 1L;
        private static final long INIT_BIT_MUTATE_RELATIONSHIP_TYPE = 2L;
        private static final long OPT_BIT_USERNAME_OVERRIDE = 1L;
        private static final long OPT_BIT_SUDO = 2L;
        private static final long OPT_BIT_CONCURRENCY = 4L;
        private static final long OPT_BIT_MIN_BATCH_SIZE = 8L;
        private static final long OPT_BIT_RELATIONSHIP_TYPES = 16L;
        private static final long OPT_BIT_NODE_LABELS = 32L;
        private static final long OPT_BIT_RELATIONSHIP_WEIGHT_PROPERTY = 64L;
        private static final long OPT_BIT_SIMILARITY_CUTOFF = 128L;
        private static final long OPT_BIT_DEGREE_CUTOFF = 256L;
        private static final long OPT_BIT_TOP_K = 512L;
        private static final long OPT_BIT_TOP_N = 1024L;
        private static final long OPT_BIT_BOTTOM_K = 2048L;
        private static final long OPT_BIT_BOTTOM_N = 4096L;
        private long initBits = 3L;
        private long optBits;
        private String usernameOverride;
        private boolean sudo;
        private Collection<String> configKeys;
        private int concurrency;
        private int minBatchSize;
        private List<String> relationshipTypes = null;
        private List<String> nodeLabels = null;
        private String relationshipWeightProperty;
        private double similarityCutoff;
        private String similarityMetric;
        private int degreeCutoff;
        private int topK;
        private int topN;
        private int bottomK;
        private int bottomN;
        private String mutateProperty;
        private String mutateRelationshipType;

        private Builder() {
        }

        public final Builder from(NodeSimilarityBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(RelationshipWeightConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ConcurrencyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MutatePropertyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AlgoBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MutateRelationshipConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(NodeSimilarityMutateConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            String relationshipWeightPropertyValue;
            NodeSimilarityBaseConfig instance;
            if (object instanceof NodeSimilarityBaseConfig) {
                instance = (NodeSimilarityBaseConfig)object;
                this.topK(instance.topK());
                this.similarityMetric(instance.similarityMetric());
                this.bottomK(instance.bottomK());
                this.degreeCutoff(instance.degreeCutoff());
                this.bottomN(instance.bottomN());
                this.similarityCutoff(instance.similarityCutoff());
                this.topN(instance.topN());
            }
            if (object instanceof RelationshipWeightConfig && (relationshipWeightPropertyValue = (instance = (RelationshipWeightConfig)object).relationshipWeightProperty()) != null) {
                this.relationshipWeightProperty(relationshipWeightPropertyValue);
            }
            if (object instanceof ConcurrencyConfig) {
                instance = (ConcurrencyConfig)object;
                this.minBatchSize(instance.minBatchSize());
                this.concurrency(instance.concurrency());
            }
            if (object instanceof MutatePropertyConfig) {
                instance = (MutatePropertyConfig)object;
                this.mutateProperty(instance.mutateProperty());
            }
            if (object instanceof BaseConfig) {
                instance = (BaseConfig)object;
                @Nullable String usernameOverrideValue = instance.usernameOverride();
                if (usernameOverrideValue != null) {
                    this.usernameOverride(usernameOverrideValue);
                }
                this.configKeys(instance.configKeys());
                this.sudo(instance.sudo());
            }
            if (object instanceof AlgoBaseConfig) {
                instance = (AlgoBaseConfig)object;
                this.addAllRelationshipTypes(instance.relationshipTypes());
                this.addAllNodeLabels(instance.nodeLabels());
            }
            if (object instanceof MutateRelationshipConfig) {
                instance = (MutateRelationshipConfig)object;
                this.mutateRelationshipType(instance.mutateRelationshipType());
            }
        }

        public final Builder usernameOverride(@Nullable String usernameOverride) {
            this.usernameOverride = usernameOverride;
            this.optBits |= 1L;
            return this;
        }

        public final Builder sudo(boolean sudo) {
            this.sudo = sudo;
            this.optBits |= 2L;
            return this;
        }

        public final Builder configKeys(Collection<String> configKeys) {
            this.configKeys = Objects.requireNonNull(configKeys, "configKeys");
            return this;
        }

        public final Builder concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.optBits |= 4L;
            return this;
        }

        public final Builder minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.optBits |= 8L;
            return this;
        }

        public final Builder addRelationshipType(String element) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addRelationshipTypes(String ... elements) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder relationshipTypes(Iterable<String> elements) {
            this.relationshipTypes = new ArrayList<String>();
            return this.addAllRelationshipTypes(elements);
        }

        public final Builder addAllRelationshipTypes(Iterable<String> elements) {
            Objects.requireNonNull(elements, "relationshipTypes element");
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addNodeLabel(String element) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder addNodeLabels(String ... elements) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder nodeLabels(Iterable<String> elements) {
            this.nodeLabels = new ArrayList<String>();
            return this.addAllNodeLabels(elements);
        }

        public final Builder addAllNodeLabels(Iterable<String> elements) {
            Objects.requireNonNull(elements, "nodeLabels element");
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder relationshipWeightProperty(@Nullable String relationshipWeightProperty) {
            this.relationshipWeightProperty = relationshipWeightProperty;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder similarityCutoff(double similarityCutoff) {
            this.similarityCutoff = similarityCutoff;
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder similarityMetric(String similarityMetric) {
            this.similarityMetric = Objects.requireNonNull(similarityMetric, "similarityMetric");
            return this;
        }

        public final Builder degreeCutoff(int degreeCutoff) {
            this.degreeCutoff = degreeCutoff;
            this.optBits |= 0x100L;
            return this;
        }

        public final Builder topK(int topK) {
            this.topK = topK;
            this.optBits |= 0x200L;
            return this;
        }

        public final Builder topN(int topN) {
            this.topN = topN;
            this.optBits |= 0x400L;
            return this;
        }

        public final Builder bottomK(int bottomK) {
            this.bottomK = bottomK;
            this.optBits |= 0x800L;
            return this;
        }

        public final Builder bottomN(int bottomN) {
            this.bottomN = bottomN;
            this.optBits |= 0x1000L;
            return this;
        }

        public final Builder mutateProperty(String mutateProperty) {
            this.mutateProperty = Objects.requireNonNull(mutateProperty, "mutateProperty");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder mutateRelationshipType(String mutateRelationshipType) {
            this.mutateRelationshipType = Objects.requireNonNull(mutateRelationshipType, "mutateRelationshipType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.optBits = 0L;
            this.usernameOverride = null;
            this.sudo = false;
            this.configKeys = null;
            this.concurrency = 0;
            this.minBatchSize = 0;
            if (this.relationshipTypes != null) {
                this.relationshipTypes.clear();
            }
            if (this.nodeLabels != null) {
                this.nodeLabels.clear();
            }
            this.relationshipWeightProperty = null;
            this.similarityCutoff = 0.0;
            this.similarityMetric = null;
            this.degreeCutoff = 0;
            this.topK = 0;
            this.topN = 0;
            this.bottomK = 0;
            this.bottomN = 0;
            this.mutateProperty = null;
            this.mutateRelationshipType = null;
            return this;
        }

        public NodeSimilarityMutateConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableNodeSimilarityMutateConfig.validate(new ImmutableNodeSimilarityMutateConfig(this));
        }

        private boolean usernameOverrideIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean sudoIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean concurrencyIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean minBatchSizeIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean relationshipTypesIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean nodeLabelsIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean relationshipWeightPropertyIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean similarityCutoffIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean degreeCutoffIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }

        private boolean topKIsSet() {
            return (this.optBits & 0x200L) != 0L;
        }

        private boolean topNIsSet() {
            return (this.optBits & 0x400L) != 0L;
        }

        private boolean bottomKIsSet() {
            return (this.optBits & 0x800L) != 0L;
        }

        private boolean bottomNIsSet() {
            return (this.optBits & 0x1000L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("mutateProperty");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("mutateRelationshipType");
            }
            return "Cannot build NodeSimilarityMutateConfig, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="NodeSimilarityMutateConfig", generator="Immutables")
    private final class InitShim {
        private byte usernameOverrideBuildStage = 0;
        private String usernameOverride;
        private byte sudoBuildStage = 0;
        private boolean sudo;
        private byte configKeysBuildStage = 0;
        private Collection<String> configKeys;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;
        private byte concurrencyBuildStage = 0;
        private int concurrency;
        private byte minBatchSizeBuildStage = 0;
        private int minBatchSize;
        private byte relationshipTypesBuildStage = 0;
        private List<String> relationshipTypes;
        private byte nodeLabelsBuildStage = 0;
        private List<String> nodeLabels;
        private byte relationshipWeightPropertyBuildStage = 0;
        private String relationshipWeightProperty;
        private byte hasRelationshipWeightPropertyBuildStage = 0;
        private boolean hasRelationshipWeightProperty;
        private byte similarityCutoffBuildStage = 0;
        private double similarityCutoff;
        private byte similarityMetricBuildStage = 0;
        private String similarityMetric;
        private byte degreeCutoffBuildStage = 0;
        private int degreeCutoff;
        private byte topKBuildStage = 0;
        private int topK;
        private byte topNBuildStage = 0;
        private int topN;
        private byte bottomKBuildStage = 0;
        private int bottomK;
        private byte bottomNBuildStage = 0;
        private int bottomN;
        private byte normalizedKBuildStage = 0;
        private int normalizedK;
        private byte normalizedNBuildStage = 0;
        private int normalizedN;
        private byte isParallelBuildStage = 0;
        private boolean isParallel;
        private byte hasTopKBuildStage = 0;
        private boolean hasTopK;
        private byte hasTopNBuildStage = 0;
        private boolean hasTopN;
        private byte computeToGraphBuildStage = 0;
        private boolean computeToGraph;

        private InitShim() {
        }

        String usernameOverride() {
            if (this.usernameOverrideBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.usernameOverrideBuildStage == 0) {
                this.usernameOverrideBuildStage = (byte)-1;
                this.usernameOverride = ImmutableNodeSimilarityMutateConfig.this.usernameOverrideInitialize();
                this.usernameOverrideBuildStage = 1;
            }
            return this.usernameOverride;
        }

        void usernameOverride(String usernameOverride) {
            this.usernameOverride = usernameOverride;
            this.usernameOverrideBuildStage = 1;
        }

        boolean sudo() {
            if (this.sudoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sudoBuildStage == 0) {
                this.sudoBuildStage = (byte)-1;
                this.sudo = ImmutableNodeSimilarityMutateConfig.this.sudoInitialize();
                this.sudoBuildStage = 1;
            }
            return this.sudo;
        }

        void sudo(boolean sudo) {
            this.sudo = sudo;
            this.sudoBuildStage = 1;
        }

        Collection<String> configKeys() {
            if (this.configKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.configKeysBuildStage == 0) {
                this.configKeysBuildStage = (byte)-1;
                this.configKeys = Objects.requireNonNull(ImmutableNodeSimilarityMutateConfig.this.configKeysInitialize(), "configKeys");
                this.configKeysBuildStage = 1;
            }
            return this.configKeys;
        }

        void configKeys(Collection<String> configKeys) {
            this.configKeys = configKeys;
            this.configKeysBuildStage = 1;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutableNodeSimilarityMutateConfig.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        int concurrency() {
            if (this.concurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.concurrencyBuildStage == 0) {
                this.concurrencyBuildStage = (byte)-1;
                this.concurrency = ImmutableNodeSimilarityMutateConfig.this.concurrencyInitialize();
                this.concurrencyBuildStage = 1;
            }
            return this.concurrency;
        }

        void concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.concurrencyBuildStage = 1;
        }

        int minBatchSize() {
            if (this.minBatchSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minBatchSizeBuildStage == 0) {
                this.minBatchSizeBuildStage = (byte)-1;
                this.minBatchSize = ImmutableNodeSimilarityMutateConfig.this.minBatchSizeInitialize();
                this.minBatchSizeBuildStage = 1;
            }
            return this.minBatchSize;
        }

        void minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.minBatchSizeBuildStage = 1;
        }

        List<String> relationshipTypes() {
            if (this.relationshipTypesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipTypesBuildStage == 0) {
                this.relationshipTypesBuildStage = (byte)-1;
                this.relationshipTypes = ImmutableNodeSimilarityMutateConfig.createUnmodifiableList(false, ImmutableNodeSimilarityMutateConfig.createSafeList(ImmutableNodeSimilarityMutateConfig.this.relationshipTypesInitialize(), true, false));
                this.relationshipTypesBuildStage = 1;
            }
            return this.relationshipTypes;
        }

        void relationshipTypes(List<String> relationshipTypes) {
            this.relationshipTypes = relationshipTypes;
            this.relationshipTypesBuildStage = 1;
        }

        List<String> nodeLabels() {
            if (this.nodeLabelsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nodeLabelsBuildStage == 0) {
                this.nodeLabelsBuildStage = (byte)-1;
                this.nodeLabels = ImmutableNodeSimilarityMutateConfig.createUnmodifiableList(false, ImmutableNodeSimilarityMutateConfig.createSafeList(ImmutableNodeSimilarityMutateConfig.this.nodeLabelsInitialize(), true, false));
                this.nodeLabelsBuildStage = 1;
            }
            return this.nodeLabels;
        }

        void nodeLabels(List<String> nodeLabels) {
            this.nodeLabels = nodeLabels;
            this.nodeLabelsBuildStage = 1;
        }

        String relationshipWeightProperty() {
            if (this.relationshipWeightPropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipWeightPropertyBuildStage == 0) {
                this.relationshipWeightPropertyBuildStage = (byte)-1;
                this.relationshipWeightProperty = ImmutableNodeSimilarityMutateConfig.this.relationshipWeightPropertyInitialize();
                this.relationshipWeightPropertyBuildStage = 1;
            }
            return this.relationshipWeightProperty;
        }

        void relationshipWeightProperty(String relationshipWeightProperty) {
            this.relationshipWeightProperty = relationshipWeightProperty;
            this.relationshipWeightPropertyBuildStage = 1;
        }

        boolean hasRelationshipWeightProperty() {
            if (this.hasRelationshipWeightPropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasRelationshipWeightPropertyBuildStage == 0) {
                this.hasRelationshipWeightPropertyBuildStage = (byte)-1;
                this.hasRelationshipWeightProperty = ImmutableNodeSimilarityMutateConfig.this.hasRelationshipWeightPropertyInitialize();
                this.hasRelationshipWeightPropertyBuildStage = 1;
            }
            return this.hasRelationshipWeightProperty;
        }

        double similarityCutoff() {
            if (this.similarityCutoffBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.similarityCutoffBuildStage == 0) {
                this.similarityCutoffBuildStage = (byte)-1;
                this.similarityCutoff = ImmutableNodeSimilarityMutateConfig.this.similarityCutoffInitialize();
                this.similarityCutoffBuildStage = 1;
            }
            return this.similarityCutoff;
        }

        void similarityCutoff(double similarityCutoff) {
            this.similarityCutoff = similarityCutoff;
            this.similarityCutoffBuildStage = 1;
        }

        String similarityMetric() {
            if (this.similarityMetricBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.similarityMetricBuildStage == 0) {
                this.similarityMetricBuildStage = (byte)-1;
                this.similarityMetric = Objects.requireNonNull(ImmutableNodeSimilarityMutateConfig.this.similarityMetricInitialize(), "similarityMetric");
                this.similarityMetricBuildStage = 1;
            }
            return this.similarityMetric;
        }

        void similarityMetric(String similarityMetric) {
            this.similarityMetric = similarityMetric;
            this.similarityMetricBuildStage = 1;
        }

        int degreeCutoff() {
            if (this.degreeCutoffBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.degreeCutoffBuildStage == 0) {
                this.degreeCutoffBuildStage = (byte)-1;
                this.degreeCutoff = ImmutableNodeSimilarityMutateConfig.this.degreeCutoffInitialize();
                this.degreeCutoffBuildStage = 1;
            }
            return this.degreeCutoff;
        }

        void degreeCutoff(int degreeCutoff) {
            this.degreeCutoff = degreeCutoff;
            this.degreeCutoffBuildStage = 1;
        }

        int topK() {
            if (this.topKBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.topKBuildStage == 0) {
                this.topKBuildStage = (byte)-1;
                this.topK = ImmutableNodeSimilarityMutateConfig.this.topKInitialize();
                this.topKBuildStage = 1;
            }
            return this.topK;
        }

        void topK(int topK) {
            this.topK = topK;
            this.topKBuildStage = 1;
        }

        int topN() {
            if (this.topNBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.topNBuildStage == 0) {
                this.topNBuildStage = (byte)-1;
                this.topN = ImmutableNodeSimilarityMutateConfig.this.topNInitialize();
                this.topNBuildStage = 1;
            }
            return this.topN;
        }

        void topN(int topN) {
            this.topN = topN;
            this.topNBuildStage = 1;
        }

        int bottomK() {
            if (this.bottomKBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.bottomKBuildStage == 0) {
                this.bottomKBuildStage = (byte)-1;
                this.bottomK = ImmutableNodeSimilarityMutateConfig.this.bottomKInitialize();
                this.bottomKBuildStage = 1;
            }
            return this.bottomK;
        }

        void bottomK(int bottomK) {
            this.bottomK = bottomK;
            this.bottomKBuildStage = 1;
        }

        int bottomN() {
            if (this.bottomNBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.bottomNBuildStage == 0) {
                this.bottomNBuildStage = (byte)-1;
                this.bottomN = ImmutableNodeSimilarityMutateConfig.this.bottomNInitialize();
                this.bottomNBuildStage = 1;
            }
            return this.bottomN;
        }

        void bottomN(int bottomN) {
            this.bottomN = bottomN;
            this.bottomNBuildStage = 1;
        }

        int normalizedK() {
            if (this.normalizedKBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.normalizedKBuildStage == 0) {
                this.normalizedKBuildStage = (byte)-1;
                this.normalizedK = ImmutableNodeSimilarityMutateConfig.this.normalizedKInitialize();
                this.normalizedKBuildStage = 1;
            }
            return this.normalizedK;
        }

        int normalizedN() {
            if (this.normalizedNBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.normalizedNBuildStage == 0) {
                this.normalizedNBuildStage = (byte)-1;
                this.normalizedN = ImmutableNodeSimilarityMutateConfig.this.normalizedNInitialize();
                this.normalizedNBuildStage = 1;
            }
            return this.normalizedN;
        }

        boolean isParallel() {
            if (this.isParallelBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isParallelBuildStage == 0) {
                this.isParallelBuildStage = (byte)-1;
                this.isParallel = ImmutableNodeSimilarityMutateConfig.this.isParallelInitialize();
                this.isParallelBuildStage = 1;
            }
            return this.isParallel;
        }

        boolean hasTopK() {
            if (this.hasTopKBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasTopKBuildStage == 0) {
                this.hasTopKBuildStage = (byte)-1;
                this.hasTopK = ImmutableNodeSimilarityMutateConfig.this.hasTopKInitialize();
                this.hasTopKBuildStage = 1;
            }
            return this.hasTopK;
        }

        boolean hasTopN() {
            if (this.hasTopNBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasTopNBuildStage == 0) {
                this.hasTopNBuildStage = (byte)-1;
                this.hasTopN = ImmutableNodeSimilarityMutateConfig.this.hasTopNInitialize();
                this.hasTopNBuildStage = 1;
            }
            return this.hasTopN;
        }

        boolean computeToGraph() {
            if (this.computeToGraphBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.computeToGraphBuildStage == 0) {
                this.computeToGraphBuildStage = (byte)-1;
                this.computeToGraph = ImmutableNodeSimilarityMutateConfig.this.computeToGraphInitialize();
                this.computeToGraphBuildStage = 1;
            }
            return this.computeToGraph;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.usernameOverrideBuildStage == -1) {
                attributes.add("usernameOverride");
            }
            if (this.sudoBuildStage == -1) {
                attributes.add("sudo");
            }
            if (this.configKeysBuildStage == -1) {
                attributes.add("configKeys");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            if (this.concurrencyBuildStage == -1) {
                attributes.add("concurrency");
            }
            if (this.minBatchSizeBuildStage == -1) {
                attributes.add("minBatchSize");
            }
            if (this.relationshipTypesBuildStage == -1) {
                attributes.add("relationshipTypes");
            }
            if (this.nodeLabelsBuildStage == -1) {
                attributes.add("nodeLabels");
            }
            if (this.relationshipWeightPropertyBuildStage == -1) {
                attributes.add("relationshipWeightProperty");
            }
            if (this.hasRelationshipWeightPropertyBuildStage == -1) {
                attributes.add("hasRelationshipWeightProperty");
            }
            if (this.similarityCutoffBuildStage == -1) {
                attributes.add("similarityCutoff");
            }
            if (this.similarityMetricBuildStage == -1) {
                attributes.add("similarityMetric");
            }
            if (this.degreeCutoffBuildStage == -1) {
                attributes.add("degreeCutoff");
            }
            if (this.topKBuildStage == -1) {
                attributes.add("topK");
            }
            if (this.topNBuildStage == -1) {
                attributes.add("topN");
            }
            if (this.bottomKBuildStage == -1) {
                attributes.add("bottomK");
            }
            if (this.bottomNBuildStage == -1) {
                attributes.add("bottomN");
            }
            if (this.normalizedKBuildStage == -1) {
                attributes.add("normalizedK");
            }
            if (this.normalizedNBuildStage == -1) {
                attributes.add("normalizedN");
            }
            if (this.isParallelBuildStage == -1) {
                attributes.add("isParallel");
            }
            if (this.hasTopKBuildStage == -1) {
                attributes.add("hasTopK");
            }
            if (this.hasTopNBuildStage == -1) {
                attributes.add("hasTopN");
            }
            if (this.computeToGraphBuildStage == -1) {
                attributes.add("computeToGraph");
            }
            return "Cannot build NodeSimilarityMutateConfig, attribute initializers form cycle " + attributes;
        }
    }
}

