/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.nodesim;

import org.neo4j.gds.core.utils.Intersections;
import org.neo4j.gds.similarity.nodesim.MetricSimilarityComputer;

public class JaccardSimilarityComputer
implements MetricSimilarityComputer {
    private final double similarityCutoff;

    public JaccardSimilarityComputer(double similarityCutoff) {
        this.similarityCutoff = similarityCutoff;
    }

    @Override
    public double computeSimilarity(long[] vector1, long[] vector2) {
        long intersection = Intersections.intersection3((long[])vector1, (long[])vector2);
        long union = (long)(vector1.length + vector2.length) - intersection;
        double similarity = union == 0L ? 0.0 : (double)intersection / (double)union;
        return similarity >= this.similarityCutoff ? similarity : Double.NaN;
    }

    @Override
    public double computeWeightedSimilarity(long[] vector1, long[] vector2, double[] weights1, double[] weights2) {
        assert (vector1.length == weights1.length);
        assert (vector2.length == weights2.length);
        int offset1 = 0;
        int offset2 = 0;
        int length1 = weights1.length;
        int length2 = weights2.length;
        double max = 0.0;
        double min = 0.0;
        while (offset1 < length1 && offset2 < length2) {
            long target1 = vector1[offset1];
            long target2 = vector2[offset2];
            if (target1 == target2) {
                double w1 = weights1[offset1];
                double w2 = weights2[offset2];
                if (w1 > w2) {
                    max += w1;
                    min += w2;
                } else {
                    min += w1;
                    max += w2;
                }
                ++offset1;
                ++offset2;
                continue;
            }
            if (target1 < target2) {
                max += weights1[offset1];
                ++offset1;
                continue;
            }
            max += weights2[offset2];
            ++offset2;
        }
        while (offset1 < length1) {
            max += weights1[offset1];
            ++offset1;
        }
        while (offset2 < length2) {
            max += weights2[offset2];
            ++offset2;
        }
        double similarity = min / max;
        return similarity >= this.similarityCutoff ? similarity : Double.NaN;
    }
}

