/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.nodesim;

import java.util.Locale;
import org.neo4j.gds.similarity.nodesim.JaccardSimilarityComputer;
import org.neo4j.gds.similarity.nodesim.NodeSimilarityMetric;
import org.neo4j.gds.similarity.nodesim.OverlapSimilarityComputer;

public interface MetricSimilarityComputer {
    public double computeSimilarity(long[] var1, long[] var2);

    public double computeWeightedSimilarity(long[] var1, long[] var2, double[] var3, double[] var4);

    public static NodeSimilarityMetric valueOf(String userInput) {
        String userInputInCaps = userInput.toUpperCase(Locale.ROOT);
        if (userInputInCaps.equals("JACCARD")) {
            return NodeSimilarityMetric.JACCARD;
        }
        if (userInputInCaps.equals("OVERLAP")) {
            return NodeSimilarityMetric.OVERLAP;
        }
        throw new IllegalArgumentException(userInput + " is not a valid metric. Available metrics include Jaccard and Overlap");
    }

    public static MetricSimilarityComputer create(NodeSimilarityMetric metric, double similarityCutoff) {
        if (metric == NodeSimilarityMetric.JACCARD) {
            return new JaccardSimilarityComputer(similarityCutoff);
        }
        return new OverlapSimilarityComputer(similarityCutoff);
    }
}

