/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.nodesim;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.RelationshipWeightConfig;
import org.neo4j.gds.config.WritePropertyConfig;
import org.neo4j.gds.config.WriteRelationshipConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.similarity.nodesim.NodeSimilarityWriteConfig;

public final class NodeSimilarityWriteConfigImpl
implements NodeSimilarityWriteConfig {
    private double similarityCutoff;
    private String similarityMetric;
    private int degreeCutoff;
    private int topK;
    private int topN;
    private int bottomK;
    private int bottomN;
    private List<String> relationshipTypes;
    private List<String> nodeLabels;
    @Nullable
    private String usernameOverride;
    private boolean sudo;
    private int concurrency;
    @Nullable
    private String relationshipWeightProperty;
    private String writeProperty;
    private int writeConcurrency;
    private String writeRelationshipType;

    public NodeSimilarityWriteConfigImpl(@NotNull CypherMapWrapper config) {
        ArrayList<IllegalArgumentException> errors = new ArrayList<IllegalArgumentException>();
        try {
            this.similarityCutoff = config.getDouble("similarityCutoff", NodeSimilarityWriteConfig.super.similarityCutoff());
            CypherMapWrapper.validateDoubleRange((String)"similarityCutoff", (double)this.similarityCutoff, (double)0.0, (double)1.0, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.similarityMetric = (String)CypherMapWrapper.failOnNull((String)"similarityMetric", (Object)config.getString("similarityMetric", NodeSimilarityWriteConfig.super.similarityMetric()));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.degreeCutoff = config.getInt("degreeCutoff", NodeSimilarityWriteConfig.super.degreeCutoff());
            CypherMapWrapper.validateIntegerRange((String)"degreeCutoff", (int)this.degreeCutoff, (int)1, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.topK = config.getInt("topK", NodeSimilarityWriteConfig.super.topK());
            CypherMapWrapper.validateIntegerRange((String)"topK", (int)this.topK, (int)1, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.topN = config.getInt("topN", NodeSimilarityWriteConfig.super.topN());
            CypherMapWrapper.validateIntegerRange((String)"topN", (int)this.topN, (int)0, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.bottomK = config.getInt("bottomK", NodeSimilarityWriteConfig.super.bottomK());
            CypherMapWrapper.validateIntegerRange((String)"bottomK", (int)this.bottomK, (int)1, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.bottomN = config.getInt("bottomN", NodeSimilarityWriteConfig.super.bottomN());
            CypherMapWrapper.validateIntegerRange((String)"bottomN", (int)this.bottomN, (int)0, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipTypes = (List)CypherMapWrapper.failOnNull((String)"relationshipTypes", (Object)((List)config.getChecked("relationshipTypes", (Object)NodeSimilarityWriteConfig.super.relationshipTypes(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.nodeLabels = (List)CypherMapWrapper.failOnNull((String)"nodeLabels", (Object)((List)config.getChecked("nodeLabels", (Object)NodeSimilarityWriteConfig.super.nodeLabels(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.usernameOverride = StringUtils.trimToNull((String)config.getString("username", NodeSimilarityWriteConfig.super.usernameOverride()));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sudo = config.getBool("sudo", NodeSimilarityWriteConfig.super.sudo());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.concurrency = config.getInt("concurrency", NodeSimilarityWriteConfig.super.concurrency());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipWeightProperty = RelationshipWeightConfig.validatePropertyName((String)config.getString("relationshipWeightProperty", NodeSimilarityWriteConfig.super.relationshipWeightProperty()));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.writeProperty = (String)CypherMapWrapper.failOnNull((String)"writeProperty", (Object)WritePropertyConfig.validatePropertyName((String)config.requireString("writeProperty")));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.writeConcurrency = config.getInt("writeConcurrency", NodeSimilarityWriteConfig.super.writeConcurrency());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.writeRelationshipType = (String)CypherMapWrapper.failOnNull((String)"writeRelationshipType", (Object)WriteRelationshipConfig.validatePropertyName((String)config.requireString("writeRelationshipType")));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.validate();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.validateConcurrency();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.validateWriteConcurrency();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                throw (IllegalArgumentException)errors.get(0);
            }
            String combinedErrorMsg = errors.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError = new IllegalArgumentException(combinedErrorMsg);
            errors.forEach(error -> combinedError.addSuppressed((Throwable)error));
            throw combinedError;
        }
    }

    @Override
    public double similarityCutoff() {
        return this.similarityCutoff;
    }

    @Override
    public String similarityMetric() {
        return this.similarityMetric;
    }

    @Override
    public int degreeCutoff() {
        return this.degreeCutoff;
    }

    @Override
    public int topK() {
        return this.topK;
    }

    @Override
    public int topN() {
        return this.topN;
    }

    @Override
    public int bottomK() {
        return this.bottomK;
    }

    @Override
    public int bottomN() {
        return this.bottomN;
    }

    public List<String> relationshipTypes() {
        return this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        return this.nodeLabels;
    }

    public void graphStoreValidation(GraphStore graphStore, Collection<NodeLabel> selectedLabels, Collection<RelationshipType> selectedRelationshipTypes) {
        this.relationshipWeightValidation(graphStore, selectedLabels, selectedRelationshipTypes);
    }

    @Nullable
    public String usernameOverride() {
        return this.usernameOverride;
    }

    public boolean sudo() {
        return this.sudo;
    }

    public Collection<String> configKeys() {
        return Arrays.asList("similarityCutoff", "similarityMetric", "degreeCutoff", "topK", "topN", "bottomK", "bottomN", "relationshipTypes", "nodeLabels", "username", "sudo", "concurrency", "relationshipWeightProperty", "writeProperty", "writeConcurrency", "writeRelationshipType");
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("similarityCutoff", this.similarityCutoff());
        map.put("similarityMetric", this.similarityMetric());
        map.put("degreeCutoff", this.degreeCutoff());
        map.put("topK", this.topK());
        map.put("topN", this.topN());
        map.put("bottomK", this.bottomK());
        map.put("bottomN", this.bottomN());
        map.put("relationshipTypes", this.relationshipTypes());
        map.put("nodeLabels", this.nodeLabels());
        map.put("username", this.usernameOverride());
        map.put("sudo", this.sudo());
        map.put("concurrency", this.concurrency());
        map.put("relationshipWeightProperty", this.relationshipWeightProperty());
        map.put("writeProperty", this.writeProperty());
        map.put("writeConcurrency", this.writeConcurrency());
        map.put("writeRelationshipType", this.writeRelationshipType());
        return map;
    }

    public int concurrency() {
        return this.concurrency;
    }

    @Nullable
    public String relationshipWeightProperty() {
        return this.relationshipWeightProperty;
    }

    public String writeProperty() {
        return this.writeProperty;
    }

    public int writeConcurrency() {
        return this.writeConcurrency;
    }

    public String writeRelationshipType() {
        return this.writeRelationshipType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Object> config = new HashMap<String, Object>();

        public Builder similarityCutoff(double similarityCutoff) {
            this.config.put("similarityCutoff", similarityCutoff);
            return this;
        }

        public Builder similarityMetric(String similarityMetric) {
            this.config.put("similarityMetric", similarityMetric);
            return this;
        }

        public Builder degreeCutoff(int degreeCutoff) {
            this.config.put("degreeCutoff", degreeCutoff);
            return this;
        }

        public Builder topK(int topK) {
            this.config.put("topK", topK);
            return this;
        }

        public Builder topN(int topN) {
            this.config.put("topN", topN);
            return this;
        }

        public Builder bottomK(int bottomK) {
            this.config.put("bottomK", bottomK);
            return this;
        }

        public Builder bottomN(int bottomN) {
            this.config.put("bottomN", bottomN);
            return this;
        }

        public Builder relationshipTypes(List<String> relationshipTypes) {
            this.config.put("relationshipTypes", relationshipTypes);
            return this;
        }

        public Builder nodeLabels(List<String> nodeLabels) {
            this.config.put("nodeLabels", nodeLabels);
            return this;
        }

        public Builder usernameOverride(String usernameOverride) {
            this.config.put("username", usernameOverride);
            return this;
        }

        public Builder sudo(boolean sudo) {
            this.config.put("sudo", sudo);
            return this;
        }

        public Builder concurrency(int concurrency) {
            this.config.put("concurrency", concurrency);
            return this;
        }

        public Builder relationshipWeightProperty(String relationshipWeightProperty) {
            this.config.put("relationshipWeightProperty", relationshipWeightProperty);
            return this;
        }

        public Builder writeProperty(String writeProperty) {
            this.config.put("writeProperty", writeProperty);
            return this;
        }

        public Builder writeConcurrency(int writeConcurrency) {
            this.config.put("writeConcurrency", writeConcurrency);
            return this;
        }

        public Builder writeRelationshipType(String writeRelationshipType) {
            this.config.put("writeRelationshipType", writeRelationshipType);
            return this;
        }

        public NodeSimilarityWriteConfig build() {
            CypherMapWrapper config = CypherMapWrapper.create(this.config);
            return new NodeSimilarityWriteConfigImpl(config);
        }
    }
}

