/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.nodesim;

import org.neo4j.gds.core.utils.Intersections;
import org.neo4j.gds.similarity.nodesim.MetricSimilarityComputer;

class OverlapSimilarityComputer
implements MetricSimilarityComputer {
    private final double similarityCutoff;

    public OverlapSimilarityComputer(double similarityCutoff) {
        this.similarityCutoff = similarityCutoff;
    }

    @Override
    public double computeSimilarity(long[] vector1, long[] vector2) {
        double minimumCardinality;
        long intersection = Intersections.intersection3((long[])vector1, (long[])vector2);
        double similarity = (double)intersection / (minimumCardinality = (double)Math.min(vector1.length, vector2.length));
        return similarity >= this.similarityCutoff ? similarity : Double.NaN;
    }

    @Override
    public double computeWeightedSimilarity(long[] vector1, long[] vector2, double[] weights1, double[] weights2) {
        assert (vector1.length == weights1.length);
        assert (vector2.length == weights2.length);
        int offset1 = 0;
        int offset2 = 0;
        int length1 = weights1.length;
        int length2 = weights2.length;
        double top = 0.0;
        double bottom1 = 0.0;
        double bottom2 = 0.0;
        while (offset1 < length1 && offset2 < length2) {
            long target1 = vector1[offset1];
            long target2 = vector2[offset2];
            if (target1 == target2) {
                double w1 = weights1[offset1];
                double w2 = weights2[offset2];
                bottom1 += w1;
                bottom2 += w2;
                top += Math.min(w1, w2);
                ++offset1;
                ++offset2;
                continue;
            }
            if (target1 < target2) {
                bottom1 += weights1[offset1];
                ++offset1;
                continue;
            }
            bottom2 += weights2[offset2];
            ++offset2;
        }
        while (offset1 < length1) {
            bottom1 += weights1[offset1];
            ++offset1;
        }
        while (offset2 < length2) {
            bottom2 += weights2[offset2];
            ++offset2;
        }
        double similarity = top / Math.min(bottom1, bottom2);
        return similarity >= this.similarityCutoff ? similarity : Double.NaN;
    }
}

