/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.nodesim;

import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.GraphAdapter;
import org.neo4j.gds.api.RelationshipConsumer;
import org.neo4j.gds.api.RelationshipWithPropertyConsumer;
import org.neo4j.gds.similarity.nodesim.TopKMap;

public class TopKGraph
extends GraphAdapter {
    private final TopKMap topKMap;

    TopKGraph(Graph graph, TopKMap topKMap) {
        super(graph);
        this.topKMap = topKMap;
    }

    public int degree(long nodeId) {
        TopKMap.TopKList topKList = this.topKMap.get(nodeId);
        return topKList != null ? topKList.size() : 0;
    }

    public long relationshipCount() {
        return this.topKMap.similarityPairCount();
    }

    public void forEachRelationship(long node1, RelationshipConsumer consumer) {
        TopKMap.TopKList topKList = this.topKMap.get(node1);
        if (topKList != null) {
            topKList.forEach((node2, similarity) -> consumer.accept(node1, node2));
        }
    }

    public void forEachRelationship(long node1, double fallbackValue, RelationshipWithPropertyConsumer consumer) {
        TopKMap.TopKList topKList = this.topKMap.get(node1);
        if (topKList != null) {
            topKList.forEach((node2, similarity) -> consumer.accept(node1, node2, similarity));
        }
    }

    public Graph concurrentCopy() {
        return this;
    }
}

