/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.nodesim;

import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.BitSet;
import java.util.Comparator;
import java.util.PrimitiveIterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.gds.core.utils.SetBitsIterable;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;
import org.neo4j.gds.core.utils.queue.BoundedLongLongPriorityQueue;
import org.neo4j.gds.core.utils.queue.BoundedLongPriorityQueue;
import org.neo4j.gds.similarity.SimilarityResult;

public class TopKMap {
    private final BitSet nodeFilter;
    private final HugeObjectArray<TopKList> topKLists;

    static MemoryEstimation memoryEstimation(long nodes, int topK) {
        return MemoryEstimations.builder(TopKMap.class).add("topK lists", MemoryEstimations.builder((String)"topK lists", TopKList.class).add("queues", BoundedLongPriorityQueue.memoryEstimation((int)topK)).build().times(nodes)).build();
    }

    TopKMap(long items, BitSet nodeFilter, int topK, Comparator<SimilarityResult> comparator) {
        this.nodeFilter = nodeFilter;
        int boundedTopK = (int)Math.min((long)topK, items);
        this.topKLists = HugeObjectArray.newArray(TopKList.class, (long)items);
        this.topKLists.setAll(node1 -> nodeFilter.get(node1) ? new TopKList(comparator.equals(SimilarityResult.ASCENDING) ? BoundedLongPriorityQueue.min((int)boundedTopK) : BoundedLongPriorityQueue.max((int)boundedTopK)) : null);
    }

    public void put(long node1, long node2, double similarity) {
        ((TopKList)this.topKLists.get(node1)).accept(node2, similarity);
    }

    public TopKList get(long node1) {
        return (TopKList)this.topKLists.get(node1);
    }

    long similarityPairCount() {
        SetBitsIterable longs = new SetBitsIterable(this.nodeFilter);
        PrimitiveIterator.OfLong iterator = longs.iterator();
        long size = 0L;
        while (iterator.hasNext()) {
            size += (long)((TopKList)this.topKLists.get(iterator.next().longValue())).size();
        }
        return size;
    }

    public void forEach(BoundedLongLongPriorityQueue.Consumer consumer) {
        SetBitsIterable items = new SetBitsIterable(this.nodeFilter);
        items.stream().forEach((long element1) -> {
            BoundedLongPriorityQueue queue = ((TopKList)this.topKLists.get((long)element1)).queue;
            PrimitiveIterator.OfLong node2Iterator = queue.elements().iterator();
            PrimitiveIterator.OfDouble priorityIterator = queue.priorities().iterator();
            while (node2Iterator.hasNext()) {
                consumer.accept(element1, node2Iterator.nextLong(), priorityIterator.nextDouble());
            }
        });
    }

    public Stream<SimilarityResult> stream() {
        return new SetBitsIterable(this.nodeFilter).stream().boxed().flatMap(node1 -> ((TopKList)this.topKLists.get(node1.longValue())).stream((long)node1));
    }

    public static final class TopKList {
        private final BoundedLongPriorityQueue queue;

        TopKList(BoundedLongPriorityQueue queue) {
            this.queue = queue;
        }

        int size() {
            return this.queue.size();
        }

        void accept(long node2, double similarity) {
            this.queue.offer(node2, similarity);
        }

        void forEach(BoundedLongPriorityQueue.Consumer consumer) {
            this.queue.forEach(consumer);
        }

        Stream<SimilarityResult> stream(final long node1) {
            Iterable iterable = () -> new AbstractIterator<SimilarityResult>(){
                final PrimitiveIterator.OfLong elementsIter;
                final PrimitiveIterator.OfDouble prioritiesIter;
                {
                    this.elementsIter = queue.elements().iterator();
                    this.prioritiesIter = queue.priorities().iterator();
                }

                protected SimilarityResult fetch() {
                    if (!this.elementsIter.hasNext() || !this.prioritiesIter.hasNext()) {
                        return (SimilarityResult)this.done();
                    }
                    return new SimilarityResult(node1, this.elementsIter.nextLong(), this.prioritiesIter.nextDouble());
                }
            };
            return StreamSupport.stream(iterable.spliterator(), false);
        }
    }
}

