/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.nodesim;

import com.carrotsearch.hppc.AbstractIterator;
import java.util.PrimitiveIterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.queue.BoundedLongLongPriorityQueue;
import org.neo4j.gds.similarity.SimilarityResult;

public class TopNList {
    private final BoundedLongLongPriorityQueue queue;

    static MemoryEstimation memoryEstimation(int topN) {
        return MemoryEstimations.builder(TopNList.class).add("queue", BoundedLongLongPriorityQueue.memoryEstimation((int)topN)).build();
    }

    public TopNList(int top) {
        int absTop = Math.abs(top);
        this.queue = top > 0 ? BoundedLongLongPriorityQueue.max((int)absTop) : BoundedLongLongPriorityQueue.min((int)absTop);
    }

    public void add(long node1, long node2, double similarity) {
        this.queue.offer(node1, node2, similarity);
    }

    public Stream<SimilarityResult> stream() {
        Iterable iterable = () -> new AbstractIterator<SimilarityResult>(){
            final PrimitiveIterator.OfLong elements1Iter;
            final PrimitiveIterator.OfLong elements2Iter;
            final PrimitiveIterator.OfDouble prioritiesIter;
            {
                this.elements1Iter = TopNList.this.queue.elements1().iterator();
                this.elements2Iter = TopNList.this.queue.elements2().iterator();
                this.prioritiesIter = TopNList.this.queue.priorities().iterator();
            }

            protected SimilarityResult fetch() {
                if (!(this.elements1Iter.hasNext() && this.elements2Iter.hasNext() && this.prioritiesIter.hasNext())) {
                    return (SimilarityResult)this.done();
                }
                return new SimilarityResult(this.elements1Iter.nextLong(), this.elements2Iter.nextLong(), this.prioritiesIter.nextDouble());
            }
        };
        return StreamSupport.stream(iterable.spliterator(), true);
    }
}

