/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.traversal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.ConcurrencyConfig;
import org.neo4j.gds.config.RandomSeedConfig;
import org.neo4j.gds.config.RelationshipWeightConfig;
import org.neo4j.gds.config.SourceNodesConfig;
import org.neo4j.gds.traversal.RandomWalkBaseConfig;
import org.neo4j.gds.traversal.RandomWalkStreamConfig;

@Generated(from="RandomWalkStreamConfig", generator="Immutables")
public final class ImmutableRandomWalkStreamConfig
implements RandomWalkStreamConfig {
    @Nullable
    private final String usernameOverride;
    private final boolean sudo;
    private final Collection<String> configKeys;
    private final transient Map<String, Object> toMap;
    private final int concurrency;
    private final int minBatchSize;
    private final List<String> relationshipTypes;
    private final List<String> nodeLabels;
    @Nullable
    private final String relationshipWeightProperty;
    private final transient boolean hasRelationshipWeightProperty;
    private final Long randomSeed;
    private final List<Long> sourceNodes;
    private final int walkLength;
    private final int walksPerNode;
    private final int walkBufferSize;
    private final double inOutFactor;
    private final double returnFactor;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableRandomWalkStreamConfig(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, @Nullable String relationshipWeightProperty, Optional<Long> randomSeed, Iterable<Long> sourceNodes, int walkLength, int walksPerNode, int walkBufferSize, double inOutFactor, double returnFactor) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(ImmutableRandomWalkStreamConfig.createUnmodifiableList(false, ImmutableRandomWalkStreamConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableRandomWalkStreamConfig.createUnmodifiableList(false, ImmutableRandomWalkStreamConfig.createSafeList(nodeLabels, true, false)));
        this.initShim.relationshipWeightProperty(relationshipWeightProperty);
        this.randomSeed = randomSeed.orElse(null);
        this.initShim.sourceNodes(ImmutableRandomWalkStreamConfig.createUnmodifiableList(false, ImmutableRandomWalkStreamConfig.createSafeList(sourceNodes, true, false)));
        this.initShim.walkLength(walkLength);
        this.initShim.walksPerNode(walksPerNode);
        this.initShim.walkBufferSize(walkBufferSize);
        this.initShim.inOutFactor(inOutFactor);
        this.initShim.returnFactor(returnFactor);
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.relationshipWeightProperty = this.initShim.relationshipWeightProperty();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.sourceNodes = this.initShim.sourceNodes();
        this.walkLength = this.initShim.walkLength();
        this.walksPerNode = this.initShim.walksPerNode();
        this.walkBufferSize = this.initShim.walkBufferSize();
        this.inOutFactor = this.initShim.inOutFactor();
        this.returnFactor = this.initShim.returnFactor();
        this.initShim = null;
    }

    private ImmutableRandomWalkStreamConfig(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, @Nullable String relationshipWeightProperty, Long randomSeed, Iterable<Long> sourceNodes, int walkLength, int walksPerNode, int walkBufferSize, double inOutFactor, double returnFactor) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(ImmutableRandomWalkStreamConfig.createUnmodifiableList(false, ImmutableRandomWalkStreamConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableRandomWalkStreamConfig.createUnmodifiableList(false, ImmutableRandomWalkStreamConfig.createSafeList(nodeLabels, true, false)));
        this.initShim.relationshipWeightProperty(relationshipWeightProperty);
        this.randomSeed = randomSeed;
        this.initShim.sourceNodes(ImmutableRandomWalkStreamConfig.createUnmodifiableList(false, ImmutableRandomWalkStreamConfig.createSafeList(sourceNodes, true, false)));
        this.initShim.walkLength(walkLength);
        this.initShim.walksPerNode(walksPerNode);
        this.initShim.walkBufferSize(walkBufferSize);
        this.initShim.inOutFactor(inOutFactor);
        this.initShim.returnFactor(returnFactor);
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.relationshipWeightProperty = this.initShim.relationshipWeightProperty();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.sourceNodes = this.initShim.sourceNodes();
        this.walkLength = this.initShim.walkLength();
        this.walksPerNode = this.initShim.walksPerNode();
        this.walkBufferSize = this.initShim.walkBufferSize();
        this.inOutFactor = this.initShim.inOutFactor();
        this.returnFactor = this.initShim.returnFactor();
        this.initShim = null;
    }

    private ImmutableRandomWalkStreamConfig(Builder builder) {
        this.randomSeed = builder.randomSeed;
        if (builder.usernameOverrideIsSet()) {
            this.initShim.usernameOverride(builder.usernameOverride);
        }
        if (builder.sudoIsSet()) {
            this.initShim.sudo(builder.sudo);
        }
        if (builder.configKeys != null) {
            this.initShim.configKeys(builder.configKeys);
        }
        if (builder.concurrencyIsSet()) {
            this.initShim.concurrency(builder.concurrency);
        }
        if (builder.minBatchSizeIsSet()) {
            this.initShim.minBatchSize(builder.minBatchSize);
        }
        if (builder.relationshipTypesIsSet()) {
            this.initShim.relationshipTypes(builder.relationshipTypes == null ? Collections.emptyList() : ImmutableRandomWalkStreamConfig.createUnmodifiableList(true, builder.relationshipTypes));
        }
        if (builder.nodeLabelsIsSet()) {
            this.initShim.nodeLabels(builder.nodeLabels == null ? Collections.emptyList() : ImmutableRandomWalkStreamConfig.createUnmodifiableList(true, builder.nodeLabels));
        }
        if (builder.relationshipWeightPropertyIsSet()) {
            this.initShim.relationshipWeightProperty(builder.relationshipWeightProperty);
        }
        if (builder.sourceNodesIsSet()) {
            this.initShim.sourceNodes(builder.sourceNodes == null ? Collections.emptyList() : ImmutableRandomWalkStreamConfig.createUnmodifiableList(true, builder.sourceNodes));
        }
        if (builder.walkLengthIsSet()) {
            this.initShim.walkLength(builder.walkLength);
        }
        if (builder.walksPerNodeIsSet()) {
            this.initShim.walksPerNode(builder.walksPerNode);
        }
        if (builder.walkBufferSizeIsSet()) {
            this.initShim.walkBufferSize(builder.walkBufferSize);
        }
        if (builder.inOutFactorIsSet()) {
            this.initShim.inOutFactor(builder.inOutFactor);
        }
        if (builder.returnFactorIsSet()) {
            this.initShim.returnFactor(builder.returnFactor);
        }
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.relationshipWeightProperty = this.initShim.relationshipWeightProperty();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.sourceNodes = this.initShim.sourceNodes();
        this.walkLength = this.initShim.walkLength();
        this.walksPerNode = this.initShim.walksPerNode();
        this.walkBufferSize = this.initShim.walkBufferSize();
        this.inOutFactor = this.initShim.inOutFactor();
        this.returnFactor = this.initShim.returnFactor();
        this.initShim = null;
    }

    private ImmutableRandomWalkStreamConfig(@Nullable String usernameOverride, boolean sudo, Collection<String> configKeys, int concurrency, int minBatchSize, List<String> relationshipTypes, List<String> nodeLabels, @Nullable String relationshipWeightProperty, Long randomSeed, List<Long> sourceNodes, int walkLength, int walksPerNode, int walkBufferSize, double inOutFactor, double returnFactor) {
        this.initShim.usernameOverride(usernameOverride);
        this.initShim.sudo(sudo);
        this.initShim.configKeys(configKeys);
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(relationshipTypes);
        this.initShim.nodeLabels(nodeLabels);
        this.initShim.relationshipWeightProperty(relationshipWeightProperty);
        this.randomSeed = randomSeed;
        this.initShim.sourceNodes(sourceNodes);
        this.initShim.walkLength(walkLength);
        this.initShim.walksPerNode(walksPerNode);
        this.initShim.walkBufferSize(walkBufferSize);
        this.initShim.inOutFactor(inOutFactor);
        this.initShim.returnFactor(returnFactor);
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.relationshipWeightProperty = this.initShim.relationshipWeightProperty();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.sourceNodes = this.initShim.sourceNodes();
        this.walkLength = this.initShim.walkLength();
        this.walksPerNode = this.initShim.walksPerNode();
        this.walkBufferSize = this.initShim.walkBufferSize();
        this.inOutFactor = this.initShim.inOutFactor();
        this.returnFactor = this.initShim.returnFactor();
        this.initShim = null;
    }

    @Nullable
    private String usernameOverrideInitialize() {
        return RandomWalkStreamConfig.super.usernameOverride();
    }

    private boolean sudoInitialize() {
        return RandomWalkStreamConfig.super.sudo();
    }

    private Collection<String> configKeysInitialize() {
        return RandomWalkStreamConfig.super.configKeys();
    }

    private Map<String, Object> toMapInitialize() {
        return RandomWalkStreamConfig.super.toMap();
    }

    private int concurrencyInitialize() {
        return RandomWalkStreamConfig.super.concurrency();
    }

    private int minBatchSizeInitialize() {
        return RandomWalkStreamConfig.super.minBatchSize();
    }

    private List<String> relationshipTypesInitialize() {
        return RandomWalkStreamConfig.super.relationshipTypes();
    }

    private List<String> nodeLabelsInitialize() {
        return RandomWalkStreamConfig.super.nodeLabels();
    }

    @Nullable
    private String relationshipWeightPropertyInitialize() {
        return RandomWalkStreamConfig.super.relationshipWeightProperty();
    }

    private boolean hasRelationshipWeightPropertyInitialize() {
        return RandomWalkStreamConfig.super.hasRelationshipWeightProperty();
    }

    private List<Long> sourceNodesInitialize() {
        return RandomWalkStreamConfig.super.sourceNodes();
    }

    private int walkLengthInitialize() {
        return RandomWalkStreamConfig.super.walkLength();
    }

    private int walksPerNodeInitialize() {
        return RandomWalkStreamConfig.super.walksPerNode();
    }

    private int walkBufferSizeInitialize() {
        return RandomWalkStreamConfig.super.walkBufferSize();
    }

    private double inOutFactorInitialize() {
        return RandomWalkStreamConfig.super.inOutFactor();
    }

    private double returnFactorInitialize() {
        return RandomWalkStreamConfig.super.returnFactor();
    }

    @Nullable
    public String usernameOverride() {
        InitShim shim = this.initShim;
        return shim != null ? shim.usernameOverride() : this.usernameOverride;
    }

    public boolean sudo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sudo() : this.sudo;
    }

    public Collection<String> configKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.configKeys() : this.configKeys;
    }

    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    public int concurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.concurrency() : this.concurrency;
    }

    public int minBatchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.minBatchSize() : this.minBatchSize;
    }

    public List<String> relationshipTypes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipTypes() : this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nodeLabels() : this.nodeLabels;
    }

    @Nullable
    public String relationshipWeightProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipWeightProperty() : this.relationshipWeightProperty;
    }

    public boolean hasRelationshipWeightProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasRelationshipWeightProperty() : this.hasRelationshipWeightProperty;
    }

    public Optional<Long> randomSeed() {
        return Optional.ofNullable(this.randomSeed);
    }

    public List<Long> sourceNodes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sourceNodes() : this.sourceNodes;
    }

    @Override
    public int walkLength() {
        InitShim shim = this.initShim;
        return shim != null ? shim.walkLength() : this.walkLength;
    }

    @Override
    public int walksPerNode() {
        InitShim shim = this.initShim;
        return shim != null ? shim.walksPerNode() : this.walksPerNode;
    }

    @Override
    public int walkBufferSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.walkBufferSize() : this.walkBufferSize;
    }

    @Override
    public double inOutFactor() {
        InitShim shim = this.initShim;
        return shim != null ? shim.inOutFactor() : this.inOutFactor;
    }

    @Override
    public double returnFactor() {
        InitShim shim = this.initShim;
        return shim != null ? shim.returnFactor() : this.returnFactor;
    }

    public final ImmutableRandomWalkStreamConfig withUsernameOverride(@Nullable String value) {
        if (Objects.equals(this.usernameOverride, value)) {
            return this;
        }
        return ImmutableRandomWalkStreamConfig.validate(new ImmutableRandomWalkStreamConfig(value, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.sourceNodes, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor));
    }

    public final ImmutableRandomWalkStreamConfig withSudo(boolean value) {
        if (this.sudo == value) {
            return this;
        }
        return ImmutableRandomWalkStreamConfig.validate(new ImmutableRandomWalkStreamConfig(this.usernameOverride, value, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.sourceNodes, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor));
    }

    public final ImmutableRandomWalkStreamConfig withConfigKeys(Collection<String> value) {
        if (this.configKeys == value) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(value, "configKeys");
        return ImmutableRandomWalkStreamConfig.validate(new ImmutableRandomWalkStreamConfig(this.usernameOverride, this.sudo, newValue, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.sourceNodes, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor));
    }

    public final ImmutableRandomWalkStreamConfig withConcurrency(int value) {
        if (this.concurrency == value) {
            return this;
        }
        return ImmutableRandomWalkStreamConfig.validate(new ImmutableRandomWalkStreamConfig(this.usernameOverride, this.sudo, this.configKeys, value, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.sourceNodes, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor));
    }

    public final ImmutableRandomWalkStreamConfig withMinBatchSize(int value) {
        if (this.minBatchSize == value) {
            return this;
        }
        return ImmutableRandomWalkStreamConfig.validate(new ImmutableRandomWalkStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, value, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.sourceNodes, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor));
    }

    public final ImmutableRandomWalkStreamConfig withRelationshipTypes(String ... elements) {
        List<String> newValue = ImmutableRandomWalkStreamConfig.createUnmodifiableList(false, ImmutableRandomWalkStreamConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableRandomWalkStreamConfig.validate(new ImmutableRandomWalkStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, newValue, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.sourceNodes, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor));
    }

    public final ImmutableRandomWalkStreamConfig withRelationshipTypes(Iterable<String> elements) {
        if (this.relationshipTypes == elements) {
            return this;
        }
        List<String> newValue = ImmutableRandomWalkStreamConfig.createUnmodifiableList(false, ImmutableRandomWalkStreamConfig.createSafeList(elements, true, false));
        return ImmutableRandomWalkStreamConfig.validate(new ImmutableRandomWalkStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, newValue, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.sourceNodes, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor));
    }

    public final ImmutableRandomWalkStreamConfig withNodeLabels(String ... elements) {
        List<String> newValue = ImmutableRandomWalkStreamConfig.createUnmodifiableList(false, ImmutableRandomWalkStreamConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableRandomWalkStreamConfig.validate(new ImmutableRandomWalkStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, newValue, this.relationshipWeightProperty, this.randomSeed, this.sourceNodes, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor));
    }

    public final ImmutableRandomWalkStreamConfig withNodeLabels(Iterable<String> elements) {
        if (this.nodeLabels == elements) {
            return this;
        }
        List<String> newValue = ImmutableRandomWalkStreamConfig.createUnmodifiableList(false, ImmutableRandomWalkStreamConfig.createSafeList(elements, true, false));
        return ImmutableRandomWalkStreamConfig.validate(new ImmutableRandomWalkStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, newValue, this.relationshipWeightProperty, this.randomSeed, this.sourceNodes, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor));
    }

    public final ImmutableRandomWalkStreamConfig withRelationshipWeightProperty(@Nullable String value) {
        if (Objects.equals(this.relationshipWeightProperty, value)) {
            return this;
        }
        return ImmutableRandomWalkStreamConfig.validate(new ImmutableRandomWalkStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, value, this.randomSeed, this.sourceNodes, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor));
    }

    public final ImmutableRandomWalkStreamConfig withRandomSeed(Long value) {
        Long newValue = value;
        if (Objects.equals(this.randomSeed, newValue)) {
            return this;
        }
        return ImmutableRandomWalkStreamConfig.validate(new ImmutableRandomWalkStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, newValue, this.sourceNodes, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor));
    }

    public final ImmutableRandomWalkStreamConfig withRandomSeed(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.randomSeed, value)) {
            return this;
        }
        return ImmutableRandomWalkStreamConfig.validate(new ImmutableRandomWalkStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, value, this.sourceNodes, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor));
    }

    public final ImmutableRandomWalkStreamConfig withSourceNodes(long ... elements) {
        ArrayList<Long> wrappedList = new ArrayList<Long>(elements.length);
        for (long element : elements) {
            wrappedList.add(element);
        }
        List<Long> newValue = ImmutableRandomWalkStreamConfig.createUnmodifiableList(false, wrappedList);
        return ImmutableRandomWalkStreamConfig.validate(new ImmutableRandomWalkStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, newValue, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor));
    }

    public final ImmutableRandomWalkStreamConfig withSourceNodes(Iterable<Long> elements) {
        if (this.sourceNodes == elements) {
            return this;
        }
        List<Long> newValue = ImmutableRandomWalkStreamConfig.createUnmodifiableList(false, ImmutableRandomWalkStreamConfig.createSafeList(elements, true, false));
        return ImmutableRandomWalkStreamConfig.validate(new ImmutableRandomWalkStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, newValue, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor));
    }

    public final ImmutableRandomWalkStreamConfig withWalkLength(int value) {
        if (this.walkLength == value) {
            return this;
        }
        return ImmutableRandomWalkStreamConfig.validate(new ImmutableRandomWalkStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.sourceNodes, value, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor));
    }

    public final ImmutableRandomWalkStreamConfig withWalksPerNode(int value) {
        if (this.walksPerNode == value) {
            return this;
        }
        return ImmutableRandomWalkStreamConfig.validate(new ImmutableRandomWalkStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.sourceNodes, this.walkLength, value, this.walkBufferSize, this.inOutFactor, this.returnFactor));
    }

    public final ImmutableRandomWalkStreamConfig withWalkBufferSize(int value) {
        if (this.walkBufferSize == value) {
            return this;
        }
        return ImmutableRandomWalkStreamConfig.validate(new ImmutableRandomWalkStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.sourceNodes, this.walkLength, this.walksPerNode, value, this.inOutFactor, this.returnFactor));
    }

    public final ImmutableRandomWalkStreamConfig withInOutFactor(double value) {
        if (Double.doubleToLongBits(this.inOutFactor) == Double.doubleToLongBits(value)) {
            return this;
        }
        return ImmutableRandomWalkStreamConfig.validate(new ImmutableRandomWalkStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.sourceNodes, this.walkLength, this.walksPerNode, this.walkBufferSize, value, this.returnFactor));
    }

    public final ImmutableRandomWalkStreamConfig withReturnFactor(double value) {
        if (Double.doubleToLongBits(this.returnFactor) == Double.doubleToLongBits(value)) {
            return this;
        }
        return ImmutableRandomWalkStreamConfig.validate(new ImmutableRandomWalkStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.sourceNodes, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRandomWalkStreamConfig && this.equalTo((ImmutableRandomWalkStreamConfig)another);
    }

    private boolean equalTo(ImmutableRandomWalkStreamConfig another) {
        return Objects.equals(this.usernameOverride, another.usernameOverride) && this.sudo == another.sudo && this.concurrency == another.concurrency && this.minBatchSize == another.minBatchSize && this.relationshipTypes.equals(another.relationshipTypes) && this.nodeLabels.equals(another.nodeLabels) && Objects.equals(this.relationshipWeightProperty, another.relationshipWeightProperty) && this.hasRelationshipWeightProperty == another.hasRelationshipWeightProperty && Objects.equals(this.randomSeed, another.randomSeed) && this.sourceNodes.equals(another.sourceNodes) && this.walkLength == another.walkLength && this.walksPerNode == another.walksPerNode && this.walkBufferSize == another.walkBufferSize && Double.doubleToLongBits(this.inOutFactor) == Double.doubleToLongBits(another.inOutFactor) && Double.doubleToLongBits(this.returnFactor) == Double.doubleToLongBits(another.returnFactor);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.usernameOverride);
        h += (h << 5) + Boolean.hashCode(this.sudo);
        h += (h << 5) + this.concurrency;
        h += (h << 5) + this.minBatchSize;
        h += (h << 5) + this.relationshipTypes.hashCode();
        h += (h << 5) + this.nodeLabels.hashCode();
        h += (h << 5) + Objects.hashCode(this.relationshipWeightProperty);
        h += (h << 5) + Boolean.hashCode(this.hasRelationshipWeightProperty);
        h += (h << 5) + Objects.hashCode(this.randomSeed);
        h += (h << 5) + this.sourceNodes.hashCode();
        h += (h << 5) + this.walkLength;
        h += (h << 5) + this.walksPerNode;
        h += (h << 5) + this.walkBufferSize;
        h += (h << 5) + Double.hashCode(this.inOutFactor);
        h += (h << 5) + Double.hashCode(this.returnFactor);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("RandomWalkStreamConfig{");
        if (this.usernameOverride != null) {
            builder.append("usernameOverride=").append(this.usernameOverride);
        }
        if (builder.length() > 23) {
            builder.append(", ");
        }
        builder.append("sudo=").append(this.sudo);
        builder.append(", ");
        builder.append("concurrency=").append(this.concurrency);
        builder.append(", ");
        builder.append("minBatchSize=").append(this.minBatchSize);
        builder.append(", ");
        builder.append("relationshipTypes=").append(this.relationshipTypes);
        builder.append(", ");
        builder.append("nodeLabels=").append(this.nodeLabels);
        if (this.relationshipWeightProperty != null) {
            builder.append(", ");
            builder.append("relationshipWeightProperty=").append(this.relationshipWeightProperty);
        }
        builder.append(", ");
        builder.append("hasRelationshipWeightProperty=").append(this.hasRelationshipWeightProperty);
        if (this.randomSeed != null) {
            builder.append(", ");
            builder.append("randomSeed=").append(this.randomSeed);
        }
        builder.append(", ");
        builder.append("sourceNodes=").append(this.sourceNodes);
        builder.append(", ");
        builder.append("walkLength=").append(this.walkLength);
        builder.append(", ");
        builder.append("walksPerNode=").append(this.walksPerNode);
        builder.append(", ");
        builder.append("walkBufferSize=").append(this.walkBufferSize);
        builder.append(", ");
        builder.append("inOutFactor=").append(this.inOutFactor);
        builder.append(", ");
        builder.append("returnFactor=").append(this.returnFactor);
        return builder.append("}").toString();
    }

    public static RandomWalkStreamConfig of(int concurrency, int minBatchSize, List<String> relationshipTypes, List<String> nodeLabels, @Nullable String relationshipWeightProperty, Optional<Long> randomSeed, List<Long> sourceNodes, int walkLength, int walksPerNode, int walkBufferSize, double inOutFactor, double returnFactor) {
        return ImmutableRandomWalkStreamConfig.of(concurrency, minBatchSize, relationshipTypes, nodeLabels, relationshipWeightProperty, randomSeed, sourceNodes, walkLength, walksPerNode, walkBufferSize, inOutFactor, returnFactor);
    }

    public static RandomWalkStreamConfig of(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, @Nullable String relationshipWeightProperty, Optional<Long> randomSeed, Iterable<Long> sourceNodes, int walkLength, int walksPerNode, int walkBufferSize, double inOutFactor, double returnFactor) {
        return ImmutableRandomWalkStreamConfig.validate(new ImmutableRandomWalkStreamConfig(concurrency, minBatchSize, relationshipTypes, nodeLabels, relationshipWeightProperty, randomSeed, sourceNodes, walkLength, walksPerNode, walkBufferSize, inOutFactor, returnFactor));
    }

    public static RandomWalkStreamConfig of(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, @Nullable String relationshipWeightProperty, Long randomSeed, Iterable<Long> sourceNodes, int walkLength, int walksPerNode, int walkBufferSize, double inOutFactor, double returnFactor) {
        return ImmutableRandomWalkStreamConfig.validate(new ImmutableRandomWalkStreamConfig(concurrency, minBatchSize, relationshipTypes, nodeLabels, relationshipWeightProperty, randomSeed, sourceNodes, walkLength, walksPerNode, walkBufferSize, inOutFactor, returnFactor));
    }

    private static ImmutableRandomWalkStreamConfig validate(ImmutableRandomWalkStreamConfig instance) {
        instance.validateConcurrency();
        return instance;
    }

    public static RandomWalkStreamConfig copyOf(RandomWalkStreamConfig instance) {
        if (instance instanceof ImmutableRandomWalkStreamConfig) {
            return (ImmutableRandomWalkStreamConfig)instance;
        }
        return ImmutableRandomWalkStreamConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="RandomWalkStreamConfig", generator="Immutables")
    public static final class Builder {
        private static final long OPT_BIT_USERNAME_OVERRIDE = 1L;
        private static final long OPT_BIT_SUDO = 2L;
        private static final long OPT_BIT_CONCURRENCY = 4L;
        private static final long OPT_BIT_MIN_BATCH_SIZE = 8L;
        private static final long OPT_BIT_RELATIONSHIP_TYPES = 16L;
        private static final long OPT_BIT_NODE_LABELS = 32L;
        private static final long OPT_BIT_RELATIONSHIP_WEIGHT_PROPERTY = 64L;
        private static final long OPT_BIT_SOURCE_NODES = 128L;
        private static final long OPT_BIT_WALK_LENGTH = 256L;
        private static final long OPT_BIT_WALKS_PER_NODE = 512L;
        private static final long OPT_BIT_WALK_BUFFER_SIZE = 1024L;
        private static final long OPT_BIT_IN_OUT_FACTOR = 2048L;
        private static final long OPT_BIT_RETURN_FACTOR = 4096L;
        private long optBits;
        private String usernameOverride;
        private boolean sudo;
        private Collection<String> configKeys;
        private int concurrency;
        private int minBatchSize;
        private List<String> relationshipTypes = null;
        private List<String> nodeLabels = null;
        private String relationshipWeightProperty;
        private Long randomSeed;
        private List<Long> sourceNodes = null;
        private int walkLength;
        private int walksPerNode;
        private int walkBufferSize;
        private double inOutFactor;
        private double returnFactor;

        private Builder() {
        }

        public final Builder from(RelationshipWeightConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ConcurrencyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(RandomSeedConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(RandomWalkBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SourceNodesConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AlgoBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(RandomWalkStreamConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Optional randomSeedOptional;
            RelationshipWeightConfig instance;
            String relationshipWeightPropertyValue;
            if (object instanceof RelationshipWeightConfig && (relationshipWeightPropertyValue = (instance = (RelationshipWeightConfig)object).relationshipWeightProperty()) != null) {
                this.relationshipWeightProperty(relationshipWeightPropertyValue);
            }
            if (object instanceof ConcurrencyConfig) {
                instance = (ConcurrencyConfig)object;
                this.minBatchSize(instance.minBatchSize());
                this.concurrency(instance.concurrency());
            }
            if (object instanceof RandomSeedConfig && (randomSeedOptional = (instance = (RandomSeedConfig)object).randomSeed()).isPresent()) {
                this.randomSeed(randomSeedOptional);
            }
            if (object instanceof RandomWalkBaseConfig) {
                instance = (RandomWalkBaseConfig)object;
                this.walkLength(instance.walkLength());
                this.walksPerNode(instance.walksPerNode());
                this.walkBufferSize(instance.walkBufferSize());
                this.returnFactor(instance.returnFactor());
                this.inOutFactor(instance.inOutFactor());
            }
            if (object instanceof SourceNodesConfig) {
                instance = (SourceNodesConfig)object;
                this.addAllSourceNodes(instance.sourceNodes());
            }
            if (object instanceof BaseConfig) {
                instance = (BaseConfig)object;
                @Nullable String usernameOverrideValue = instance.usernameOverride();
                if (usernameOverrideValue != null) {
                    this.usernameOverride(usernameOverrideValue);
                }
                this.configKeys(instance.configKeys());
                this.sudo(instance.sudo());
            }
            if (object instanceof AlgoBaseConfig) {
                instance = (AlgoBaseConfig)object;
                this.addAllRelationshipTypes(instance.relationshipTypes());
                this.addAllNodeLabels(instance.nodeLabels());
            }
        }

        public final Builder usernameOverride(@Nullable String usernameOverride) {
            this.usernameOverride = usernameOverride;
            this.optBits |= 1L;
            return this;
        }

        public final Builder sudo(boolean sudo) {
            this.sudo = sudo;
            this.optBits |= 2L;
            return this;
        }

        public final Builder configKeys(Collection<String> configKeys) {
            this.configKeys = Objects.requireNonNull(configKeys, "configKeys");
            return this;
        }

        public final Builder concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.optBits |= 4L;
            return this;
        }

        public final Builder minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.optBits |= 8L;
            return this;
        }

        public final Builder addRelationshipType(String element) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addRelationshipTypes(String ... elements) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder relationshipTypes(Iterable<String> elements) {
            this.relationshipTypes = new ArrayList<String>();
            return this.addAllRelationshipTypes(elements);
        }

        public final Builder addAllRelationshipTypes(Iterable<String> elements) {
            Objects.requireNonNull(elements, "relationshipTypes element");
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addNodeLabel(String element) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder addNodeLabels(String ... elements) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder nodeLabels(Iterable<String> elements) {
            this.nodeLabels = new ArrayList<String>();
            return this.addAllNodeLabels(elements);
        }

        public final Builder addAllNodeLabels(Iterable<String> elements) {
            Objects.requireNonNull(elements, "nodeLabels element");
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder relationshipWeightProperty(@Nullable String relationshipWeightProperty) {
            this.relationshipWeightProperty = relationshipWeightProperty;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder randomSeed(Long randomSeed) {
            this.randomSeed = randomSeed;
            return this;
        }

        public final Builder randomSeed(Optional<Long> randomSeed) {
            this.randomSeed = randomSeed.orElse(null);
            return this;
        }

        public final Builder addSourceNode(long element) {
            if (this.sourceNodes == null) {
                this.sourceNodes = new ArrayList<Long>();
            }
            this.sourceNodes.add(element);
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder addSourceNodes(long ... elements) {
            if (this.sourceNodes == null) {
                this.sourceNodes = new ArrayList<Long>();
            }
            for (long element : elements) {
                this.sourceNodes.add(element);
            }
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder sourceNodes(Iterable<Long> elements) {
            this.sourceNodes = new ArrayList<Long>();
            return this.addAllSourceNodes(elements);
        }

        public final Builder addAllSourceNodes(Iterable<Long> elements) {
            Objects.requireNonNull(elements, "sourceNodes element");
            if (this.sourceNodes == null) {
                this.sourceNodes = new ArrayList<Long>();
            }
            for (long element : elements) {
                this.sourceNodes.add(Objects.requireNonNull(Long.valueOf(element), "sourceNodes element"));
            }
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder walkLength(int walkLength) {
            this.walkLength = walkLength;
            this.optBits |= 0x100L;
            return this;
        }

        public final Builder walksPerNode(int walksPerNode) {
            this.walksPerNode = walksPerNode;
            this.optBits |= 0x200L;
            return this;
        }

        public final Builder walkBufferSize(int walkBufferSize) {
            this.walkBufferSize = walkBufferSize;
            this.optBits |= 0x400L;
            return this;
        }

        public final Builder inOutFactor(double inOutFactor) {
            this.inOutFactor = inOutFactor;
            this.optBits |= 0x800L;
            return this;
        }

        public final Builder returnFactor(double returnFactor) {
            this.returnFactor = returnFactor;
            this.optBits |= 0x1000L;
            return this;
        }

        public Builder clear() {
            this.optBits = 0L;
            this.usernameOverride = null;
            this.sudo = false;
            this.configKeys = null;
            this.concurrency = 0;
            this.minBatchSize = 0;
            if (this.relationshipTypes != null) {
                this.relationshipTypes.clear();
            }
            if (this.nodeLabels != null) {
                this.nodeLabels.clear();
            }
            this.relationshipWeightProperty = null;
            this.randomSeed = null;
            if (this.sourceNodes != null) {
                this.sourceNodes.clear();
            }
            this.walkLength = 0;
            this.walksPerNode = 0;
            this.walkBufferSize = 0;
            this.inOutFactor = 0.0;
            this.returnFactor = 0.0;
            return this;
        }

        public RandomWalkStreamConfig build() {
            return ImmutableRandomWalkStreamConfig.validate(new ImmutableRandomWalkStreamConfig(this));
        }

        private boolean usernameOverrideIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean sudoIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean concurrencyIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean minBatchSizeIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean relationshipTypesIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean nodeLabelsIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean relationshipWeightPropertyIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean sourceNodesIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean walkLengthIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }

        private boolean walksPerNodeIsSet() {
            return (this.optBits & 0x200L) != 0L;
        }

        private boolean walkBufferSizeIsSet() {
            return (this.optBits & 0x400L) != 0L;
        }

        private boolean inOutFactorIsSet() {
            return (this.optBits & 0x800L) != 0L;
        }

        private boolean returnFactorIsSet() {
            return (this.optBits & 0x1000L) != 0L;
        }
    }

    @Generated(from="RandomWalkStreamConfig", generator="Immutables")
    private final class InitShim {
        private byte usernameOverrideBuildStage = 0;
        private String usernameOverride;
        private byte sudoBuildStage = 0;
        private boolean sudo;
        private byte configKeysBuildStage = 0;
        private Collection<String> configKeys;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;
        private byte concurrencyBuildStage = 0;
        private int concurrency;
        private byte minBatchSizeBuildStage = 0;
        private int minBatchSize;
        private byte relationshipTypesBuildStage = 0;
        private List<String> relationshipTypes;
        private byte nodeLabelsBuildStage = 0;
        private List<String> nodeLabels;
        private byte relationshipWeightPropertyBuildStage = 0;
        private String relationshipWeightProperty;
        private byte hasRelationshipWeightPropertyBuildStage = 0;
        private boolean hasRelationshipWeightProperty;
        private byte sourceNodesBuildStage = 0;
        private List<Long> sourceNodes;
        private byte walkLengthBuildStage = 0;
        private int walkLength;
        private byte walksPerNodeBuildStage = 0;
        private int walksPerNode;
        private byte walkBufferSizeBuildStage = 0;
        private int walkBufferSize;
        private byte inOutFactorBuildStage = 0;
        private double inOutFactor;
        private byte returnFactorBuildStage = 0;
        private double returnFactor;

        private InitShim() {
        }

        String usernameOverride() {
            if (this.usernameOverrideBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.usernameOverrideBuildStage == 0) {
                this.usernameOverrideBuildStage = (byte)-1;
                this.usernameOverride = ImmutableRandomWalkStreamConfig.this.usernameOverrideInitialize();
                this.usernameOverrideBuildStage = 1;
            }
            return this.usernameOverride;
        }

        void usernameOverride(String usernameOverride) {
            this.usernameOverride = usernameOverride;
            this.usernameOverrideBuildStage = 1;
        }

        boolean sudo() {
            if (this.sudoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sudoBuildStage == 0) {
                this.sudoBuildStage = (byte)-1;
                this.sudo = ImmutableRandomWalkStreamConfig.this.sudoInitialize();
                this.sudoBuildStage = 1;
            }
            return this.sudo;
        }

        void sudo(boolean sudo) {
            this.sudo = sudo;
            this.sudoBuildStage = 1;
        }

        Collection<String> configKeys() {
            if (this.configKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.configKeysBuildStage == 0) {
                this.configKeysBuildStage = (byte)-1;
                this.configKeys = Objects.requireNonNull(ImmutableRandomWalkStreamConfig.this.configKeysInitialize(), "configKeys");
                this.configKeysBuildStage = 1;
            }
            return this.configKeys;
        }

        void configKeys(Collection<String> configKeys) {
            this.configKeys = configKeys;
            this.configKeysBuildStage = 1;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutableRandomWalkStreamConfig.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        int concurrency() {
            if (this.concurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.concurrencyBuildStage == 0) {
                this.concurrencyBuildStage = (byte)-1;
                this.concurrency = ImmutableRandomWalkStreamConfig.this.concurrencyInitialize();
                this.concurrencyBuildStage = 1;
            }
            return this.concurrency;
        }

        void concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.concurrencyBuildStage = 1;
        }

        int minBatchSize() {
            if (this.minBatchSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minBatchSizeBuildStage == 0) {
                this.minBatchSizeBuildStage = (byte)-1;
                this.minBatchSize = ImmutableRandomWalkStreamConfig.this.minBatchSizeInitialize();
                this.minBatchSizeBuildStage = 1;
            }
            return this.minBatchSize;
        }

        void minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.minBatchSizeBuildStage = 1;
        }

        List<String> relationshipTypes() {
            if (this.relationshipTypesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipTypesBuildStage == 0) {
                this.relationshipTypesBuildStage = (byte)-1;
                this.relationshipTypes = ImmutableRandomWalkStreamConfig.createUnmodifiableList(false, ImmutableRandomWalkStreamConfig.createSafeList(ImmutableRandomWalkStreamConfig.this.relationshipTypesInitialize(), true, false));
                this.relationshipTypesBuildStage = 1;
            }
            return this.relationshipTypes;
        }

        void relationshipTypes(List<String> relationshipTypes) {
            this.relationshipTypes = relationshipTypes;
            this.relationshipTypesBuildStage = 1;
        }

        List<String> nodeLabels() {
            if (this.nodeLabelsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nodeLabelsBuildStage == 0) {
                this.nodeLabelsBuildStage = (byte)-1;
                this.nodeLabels = ImmutableRandomWalkStreamConfig.createUnmodifiableList(false, ImmutableRandomWalkStreamConfig.createSafeList(ImmutableRandomWalkStreamConfig.this.nodeLabelsInitialize(), true, false));
                this.nodeLabelsBuildStage = 1;
            }
            return this.nodeLabels;
        }

        void nodeLabels(List<String> nodeLabels) {
            this.nodeLabels = nodeLabels;
            this.nodeLabelsBuildStage = 1;
        }

        String relationshipWeightProperty() {
            if (this.relationshipWeightPropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipWeightPropertyBuildStage == 0) {
                this.relationshipWeightPropertyBuildStage = (byte)-1;
                this.relationshipWeightProperty = ImmutableRandomWalkStreamConfig.this.relationshipWeightPropertyInitialize();
                this.relationshipWeightPropertyBuildStage = 1;
            }
            return this.relationshipWeightProperty;
        }

        void relationshipWeightProperty(String relationshipWeightProperty) {
            this.relationshipWeightProperty = relationshipWeightProperty;
            this.relationshipWeightPropertyBuildStage = 1;
        }

        boolean hasRelationshipWeightProperty() {
            if (this.hasRelationshipWeightPropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasRelationshipWeightPropertyBuildStage == 0) {
                this.hasRelationshipWeightPropertyBuildStage = (byte)-1;
                this.hasRelationshipWeightProperty = ImmutableRandomWalkStreamConfig.this.hasRelationshipWeightPropertyInitialize();
                this.hasRelationshipWeightPropertyBuildStage = 1;
            }
            return this.hasRelationshipWeightProperty;
        }

        List<Long> sourceNodes() {
            if (this.sourceNodesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sourceNodesBuildStage == 0) {
                this.sourceNodesBuildStage = (byte)-1;
                this.sourceNodes = ImmutableRandomWalkStreamConfig.createUnmodifiableList(false, ImmutableRandomWalkStreamConfig.createSafeList(ImmutableRandomWalkStreamConfig.this.sourceNodesInitialize(), true, false));
                this.sourceNodesBuildStage = 1;
            }
            return this.sourceNodes;
        }

        void sourceNodes(List<Long> sourceNodes) {
            this.sourceNodes = sourceNodes;
            this.sourceNodesBuildStage = 1;
        }

        int walkLength() {
            if (this.walkLengthBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.walkLengthBuildStage == 0) {
                this.walkLengthBuildStage = (byte)-1;
                this.walkLength = ImmutableRandomWalkStreamConfig.this.walkLengthInitialize();
                this.walkLengthBuildStage = 1;
            }
            return this.walkLength;
        }

        void walkLength(int walkLength) {
            this.walkLength = walkLength;
            this.walkLengthBuildStage = 1;
        }

        int walksPerNode() {
            if (this.walksPerNodeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.walksPerNodeBuildStage == 0) {
                this.walksPerNodeBuildStage = (byte)-1;
                this.walksPerNode = ImmutableRandomWalkStreamConfig.this.walksPerNodeInitialize();
                this.walksPerNodeBuildStage = 1;
            }
            return this.walksPerNode;
        }

        void walksPerNode(int walksPerNode) {
            this.walksPerNode = walksPerNode;
            this.walksPerNodeBuildStage = 1;
        }

        int walkBufferSize() {
            if (this.walkBufferSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.walkBufferSizeBuildStage == 0) {
                this.walkBufferSizeBuildStage = (byte)-1;
                this.walkBufferSize = ImmutableRandomWalkStreamConfig.this.walkBufferSizeInitialize();
                this.walkBufferSizeBuildStage = 1;
            }
            return this.walkBufferSize;
        }

        void walkBufferSize(int walkBufferSize) {
            this.walkBufferSize = walkBufferSize;
            this.walkBufferSizeBuildStage = 1;
        }

        double inOutFactor() {
            if (this.inOutFactorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.inOutFactorBuildStage == 0) {
                this.inOutFactorBuildStage = (byte)-1;
                this.inOutFactor = ImmutableRandomWalkStreamConfig.this.inOutFactorInitialize();
                this.inOutFactorBuildStage = 1;
            }
            return this.inOutFactor;
        }

        void inOutFactor(double inOutFactor) {
            this.inOutFactor = inOutFactor;
            this.inOutFactorBuildStage = 1;
        }

        double returnFactor() {
            if (this.returnFactorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.returnFactorBuildStage == 0) {
                this.returnFactorBuildStage = (byte)-1;
                this.returnFactor = ImmutableRandomWalkStreamConfig.this.returnFactorInitialize();
                this.returnFactorBuildStage = 1;
            }
            return this.returnFactor;
        }

        void returnFactor(double returnFactor) {
            this.returnFactor = returnFactor;
            this.returnFactorBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.usernameOverrideBuildStage == -1) {
                attributes.add("usernameOverride");
            }
            if (this.sudoBuildStage == -1) {
                attributes.add("sudo");
            }
            if (this.configKeysBuildStage == -1) {
                attributes.add("configKeys");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            if (this.concurrencyBuildStage == -1) {
                attributes.add("concurrency");
            }
            if (this.minBatchSizeBuildStage == -1) {
                attributes.add("minBatchSize");
            }
            if (this.relationshipTypesBuildStage == -1) {
                attributes.add("relationshipTypes");
            }
            if (this.nodeLabelsBuildStage == -1) {
                attributes.add("nodeLabels");
            }
            if (this.relationshipWeightPropertyBuildStage == -1) {
                attributes.add("relationshipWeightProperty");
            }
            if (this.hasRelationshipWeightPropertyBuildStage == -1) {
                attributes.add("hasRelationshipWeightProperty");
            }
            if (this.sourceNodesBuildStage == -1) {
                attributes.add("sourceNodes");
            }
            if (this.walkLengthBuildStage == -1) {
                attributes.add("walkLength");
            }
            if (this.walksPerNodeBuildStage == -1) {
                attributes.add("walksPerNode");
            }
            if (this.walkBufferSizeBuildStage == -1) {
                attributes.add("walkBufferSize");
            }
            if (this.inOutFactorBuildStage == -1) {
                attributes.add("inOutFactor");
            }
            if (this.returnFactorBuildStage == -1) {
                attributes.add("returnFactor");
            }
            return "Cannot build RandomWalkStreamConfig, attribute initializers form cycle " + attributes;
        }
    }
}

