/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.traversal;

import java.util.List;
import java.util.Random;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.mutable.MutableInt;
import org.neo4j.gds.Algorithm;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.config.SourceNodesConfig;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.utils.TerminationFlag;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.queue.QueueBasedSpliterator;
import org.neo4j.gds.degree.DegreeCentrality;
import org.neo4j.gds.degree.DegreeCentralityConfig;
import org.neo4j.gds.degree.ImmutableDegreeCentralityConfig;
import org.neo4j.gds.ml.core.EmbeddingUtils;
import org.neo4j.gds.ml.core.samplers.RandomWalkSampler;
import org.neo4j.gds.traversal.RandomWalkBaseConfig;

public final class RandomWalk
extends Algorithm<Stream<long[]>> {
    private final Graph graph;
    private final RandomWalkBaseConfig config;

    private RandomWalk(Graph graph, RandomWalkBaseConfig config, ProgressTracker progressTracker) {
        super(progressTracker);
        this.graph = graph;
        this.config = config;
    }

    public static RandomWalk create(Graph graph, RandomWalkBaseConfig config, ProgressTracker progressTracker) {
        if (graph.hasRelationshipProperty()) {
            EmbeddingUtils.validateRelationshipWeightPropertyValue((Graph)graph, (int)config.concurrency(), weight -> weight >= 0.0, (String)"Node2Vec only supports non-negative weights.", (ExecutorService)Pools.DEFAULT);
        }
        return new RandomWalk(graph, config, progressTracker);
    }

    public Stream<long[]> compute() {
        this.progressTracker.beginSubTask("RandomWalk");
        int timeout = 100;
        ArrayBlockingQueue walks = new ArrayBlockingQueue(this.config.walkBufferSize());
        long[] TOMB = new long[]{};
        RandomWalkSampler.CumulativeWeightSupplier cumulativeWeightSupplier = this.graph.hasRelationshipProperty() ? this.cumulativeWeights()::get : arg_0 -> ((Graph)this.graph).degree(arg_0);
        Long randomSeed = this.config.randomSeed().orElseGet(() -> new Random().nextLong());
        NextNodeSupplier.GraphNodeSupplier nextNodeSupplier = this.config.sourceNodes() == null || this.config.sourceNodes().isEmpty() ? new NextNodeSupplier.GraphNodeSupplier(this.graph.nodeCount()) : NextNodeSupplier.ListNodeSupplier.of(this.config, this.graph);
        List tasks = IntStream.range(0, this.config.concurrency()).mapToObj(i -> RandomWalkTask.of(nextNodeSupplier, cumulativeWeightSupplier, this.graph.concurrentCopy(), this.config, walks, randomSeed, this.progressTracker)).collect(Collectors.toList());
        this.progressTracker.beginSubTask("create walks");
        new Thread(() -> {
            ParallelUtil.runWithConcurrency((int)this.config.concurrency(), (Iterable)tasks, (TerminationFlag)this.terminationFlag, (ExecutorService)Pools.DEFAULT);
            try {
                this.progressTracker.endSubTask("create walks");
                this.progressTracker.endSubTask("RandomWalk");
                walks.put(TOMB);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }).start();
        return StreamSupport.stream(new QueueBasedSpliterator(walks, (Object)TOMB, this.terminationFlag, timeout), false);
    }

    private DegreeCentrality.DegreeFunction cumulativeWeights() {
        DegreeCentralityConfig degreeCentralityConfig = ImmutableDegreeCentralityConfig.builder().concurrency(this.config.concurrency()).relationshipWeightProperty("DUMMY").build();
        return new DegreeCentrality(this.graph, Pools.DEFAULT, degreeCentralityConfig, this.progressTracker).compute();
    }

    public void release() {
    }

    @FunctionalInterface
    static interface NextNodeSupplier {
        public static final long NO_MORE_NODES = -1L;

        public long nextNode();

        public static final class ListNodeSupplier
        implements NextNodeSupplier {
            private final List<Long> nodes;
            private final AtomicInteger nextIndex;

            static ListNodeSupplier of(SourceNodesConfig config, Graph graph) {
                List<Long> mappedIds = config.sourceNodes().stream().map(arg_0 -> ((Graph)graph).toMappedNodeId(arg_0)).collect(Collectors.toList());
                return new ListNodeSupplier(mappedIds);
            }

            private ListNodeSupplier(List<Long> nodes) {
                this.nodes = nodes;
                this.nextIndex = new AtomicInteger(0);
            }

            @Override
            public long nextNode() {
                int index = this.nextIndex.getAndIncrement();
                return index < this.nodes.size() ? this.nodes.get(index) : -1L;
            }
        }

        public static class GraphNodeSupplier
        implements NextNodeSupplier {
            private final long numberOfNodes;
            private final AtomicLong nextNodeId;

            GraphNodeSupplier(long numberOfNodes) {
                this.numberOfNodes = numberOfNodes;
                this.nextNodeId = new AtomicLong(0L);
            }

            @Override
            public long nextNode() {
                long nextNode = this.nextNodeId.getAndIncrement();
                return nextNode < this.numberOfNodes ? nextNode : -1L;
            }
        }
    }

    private static final class RandomWalkTask
    implements Runnable {
        private final Graph graph;
        private final Random random = new Random();
        private final BlockingQueue<long[]> walks;
        private final NextNodeSupplier nextNodeSupplier;
        private final long[][] buffer;
        private final MutableInt bufferPosition;
        private final long randomSeed;
        private final ProgressTracker progressTracker;
        private final RandomWalkBaseConfig config;
        private final RandomWalkSampler sampler;

        static RandomWalkTask of(NextNodeSupplier nextNodeSupplier, RandomWalkSampler.CumulativeWeightSupplier cumulativeWeightSupplier, Graph graph, RandomWalkBaseConfig config, BlockingQueue<long[]> walks, long randomSeed, ProgressTracker progressTracker) {
            double maxProbability = Math.max(Math.max(1.0 / config.returnFactor(), 1.0), 1.0 / config.inOutFactor());
            double normalizedReturnProbability = 1.0 / config.returnFactor() / maxProbability;
            double normalizedSameDistanceProbability = 1.0 / maxProbability;
            double normalizedInOutProbability = 1.0 / config.inOutFactor() / maxProbability;
            return new RandomWalkTask(nextNodeSupplier, cumulativeWeightSupplier, config, walks, normalizedReturnProbability, normalizedSameDistanceProbability, normalizedInOutProbability, graph, randomSeed, progressTracker);
        }

        private RandomWalkTask(NextNodeSupplier nextNodeSupplier, RandomWalkSampler.CumulativeWeightSupplier cumulativeWeightSupplier, RandomWalkBaseConfig config, BlockingQueue<long[]> walks, double normalizedReturnProbability, double normalizedSameDistanceProbability, double normalizedInOutProbability, Graph graph, long randomSeed, ProgressTracker progressTracker) {
            this.nextNodeSupplier = nextNodeSupplier;
            this.graph = graph;
            this.config = config;
            this.walks = walks;
            this.randomSeed = randomSeed;
            this.progressTracker = progressTracker;
            this.sampler = new RandomWalkSampler(cumulativeWeightSupplier, config.walkLength(), normalizedReturnProbability, normalizedSameDistanceProbability, normalizedInOutProbability, graph, this.random);
            this.buffer = new long[1000][];
            this.bufferPosition = new MutableInt(0);
        }

        @Override
        public void run() {
            long nodeId;
            while ((nodeId = this.nextNodeSupplier.nextNode()) != -1L) {
                if (this.graph.degree(nodeId) == 0) {
                    this.progressTracker.logProgress();
                    continue;
                }
                this.random.setSeed(this.randomSeed + nodeId);
                int walksPerNode = this.config.walksPerNode();
                for (int walkIndex = 0; walkIndex < walksPerNode; ++walkIndex) {
                    this.buffer[this.bufferPosition.getAndIncrement()] = this.sampler.walk(nodeId);
                    if (this.bufferPosition.getValue() != this.buffer.length) continue;
                    this.flushBuffer();
                }
                this.progressTracker.logProgress();
            }
            this.flushBuffer();
        }

        private void flushBuffer() {
            for (int i = 0; i < this.bufferPosition.getValue(); ++i) {
                try {
                    this.walks.put(this.buffer[i]);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.bufferPosition.setValue(0);
        }
    }
}

