/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.traversal;

import java.util.ArrayList;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.mem.MemoryRange;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.progress.tasks.Tasks;
import org.neo4j.gds.degree.DegreeCentralityFactory;
import org.neo4j.gds.mem.MemoryUsage;
import org.neo4j.gds.traversal.RandomWalk;
import org.neo4j.gds.traversal.RandomWalkBaseConfig;

public class RandomWalkAlgorithmFactory<CONFIG extends RandomWalkBaseConfig>
extends GraphAlgorithmFactory<RandomWalk, CONFIG> {
    public String taskName() {
        return "RandomWalk";
    }

    public RandomWalk build(Graph graph, RandomWalkBaseConfig configuration, ProgressTracker progressTracker) {
        return RandomWalk.create(graph, configuration, progressTracker);
    }

    public Task progressTask(Graph graph, CONFIG config) {
        ArrayList<Object> tasks = new ArrayList<Object>();
        if (graph.hasRelationshipProperty()) {
            tasks.add(DegreeCentralityFactory.degreeCentralityProgressTask(graph));
        }
        tasks.add(Tasks.leaf((String)"create walks", (long)graph.nodeCount()));
        return Tasks.task((String)this.taskName(), tasks);
    }

    public MemoryEstimation memoryEstimation(CONFIG config) {
        long memoryUsagePerWalk = MemoryUsage.sizeOfLongArray((long)config.walkLength());
        long sizeOfBuffer = MemoryUsage.sizeOfObjectArray((long)config.walkBufferSize());
        long maxMemoryUsage = sizeOfBuffer + MemoryUsage.sizeOfArray((long)config.walkBufferSize(), (long)memoryUsagePerWalk);
        return MemoryEstimations.builder(RandomWalk.class).fixed("random walk buffer", MemoryRange.of((long)sizeOfBuffer, (long)maxMemoryUsage)).build();
    }
}

