/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.traversal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.NodeIdsParser;
import org.neo4j.gds.config.RelationshipWeightConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.traversal.RandomWalkStreamConfig;

public final class RandomWalkStreamConfigImpl
implements RandomWalkStreamConfig {
    private int walkLength;
    private int walksPerNode;
    private int walkBufferSize;
    private double inOutFactor;
    private double returnFactor;
    private List<String> relationshipTypes;
    private List<String> nodeLabels;
    @Nullable
    private String usernameOverride;
    private boolean sudo;
    private int concurrency;
    @Nullable
    private String relationshipWeightProperty;
    private Optional<Long> randomSeed;
    private List<Long> sourceNodes;

    public RandomWalkStreamConfigImpl(@NotNull CypherMapWrapper config) {
        ArrayList<IllegalArgumentException> errors = new ArrayList<IllegalArgumentException>();
        try {
            this.walkLength = config.getInt("walkLength", RandomWalkStreamConfig.super.walkLength());
            CypherMapWrapper.validateIntegerRange((String)"walkLength", (int)this.walkLength, (int)2, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.walksPerNode = config.getInt("walksPerNode", RandomWalkStreamConfig.super.walksPerNode());
            CypherMapWrapper.validateIntegerRange((String)"walksPerNode", (int)this.walksPerNode, (int)1, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.walkBufferSize = config.getInt("walkBufferSize", RandomWalkStreamConfig.super.walkBufferSize());
            CypherMapWrapper.validateIntegerRange((String)"walkBufferSize", (int)this.walkBufferSize, (int)1, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.inOutFactor = config.getDouble("inOutFactor", RandomWalkStreamConfig.super.inOutFactor());
            CypherMapWrapper.validateDoubleRange((String)"inOutFactor", (double)this.inOutFactor, (double)0.0, (double)Double.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.returnFactor = config.getDouble("returnFactor", RandomWalkStreamConfig.super.returnFactor());
            CypherMapWrapper.validateDoubleRange((String)"returnFactor", (double)this.returnFactor, (double)0.0, (double)Double.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipTypes = (List)CypherMapWrapper.failOnNull((String)"relationshipTypes", (Object)((List)config.getChecked("relationshipTypes", (Object)RandomWalkStreamConfig.super.relationshipTypes(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.nodeLabels = (List)CypherMapWrapper.failOnNull((String)"nodeLabels", (Object)((List)config.getChecked("nodeLabels", (Object)RandomWalkStreamConfig.super.nodeLabels(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.usernameOverride = StringUtils.trimToNull((String)config.getString("username", RandomWalkStreamConfig.super.usernameOverride()));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sudo = config.getBool("sudo", RandomWalkStreamConfig.super.sudo());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.concurrency = config.getInt("concurrency", RandomWalkStreamConfig.super.concurrency());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipWeightProperty = RelationshipWeightConfig.validatePropertyName((String)config.getString("relationshipWeightProperty", RandomWalkStreamConfig.super.relationshipWeightProperty()));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.randomSeed = (Optional)CypherMapWrapper.failOnNull((String)"randomSeed", (Object)config.getOptional("randomSeed", Long.class));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sourceNodes = (List)CypherMapWrapper.failOnNull((String)"sourceNodes", (Object)NodeIdsParser.parseNodeIds((Object)config.getChecked("sourceNodes", (Object)RandomWalkStreamConfig.super.sourceNodes(), Object.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.validateConcurrency();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                throw (IllegalArgumentException)errors.get(0);
            }
            String combinedErrorMsg = errors.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError = new IllegalArgumentException(combinedErrorMsg);
            errors.forEach(error -> combinedError.addSuppressed((Throwable)error));
            throw combinedError;
        }
    }

    @Override
    public int walkLength() {
        return this.walkLength;
    }

    @Override
    public int walksPerNode() {
        return this.walksPerNode;
    }

    @Override
    public int walkBufferSize() {
        return this.walkBufferSize;
    }

    @Override
    public double inOutFactor() {
        return this.inOutFactor;
    }

    @Override
    public double returnFactor() {
        return this.returnFactor;
    }

    public List<String> relationshipTypes() {
        return this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        return this.nodeLabels;
    }

    public void graphStoreValidation(GraphStore graphStore, Collection<NodeLabel> selectedLabels, Collection<RelationshipType> selectedRelationshipTypes) {
        this.relationshipWeightValidation(graphStore, selectedLabels, selectedRelationshipTypes);
    }

    @Nullable
    public String usernameOverride() {
        return this.usernameOverride;
    }

    public boolean sudo() {
        return this.sudo;
    }

    public Collection<String> configKeys() {
        return Arrays.asList("walkLength", "walksPerNode", "walkBufferSize", "inOutFactor", "returnFactor", "relationshipTypes", "nodeLabels", "username", "sudo", "concurrency", "relationshipWeightProperty", "randomSeed", "sourceNodes");
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("walkLength", this.walkLength());
        map.put("walksPerNode", this.walksPerNode());
        map.put("walkBufferSize", this.walkBufferSize());
        map.put("inOutFactor", this.inOutFactor());
        map.put("returnFactor", this.returnFactor());
        map.put("relationshipTypes", this.relationshipTypes());
        map.put("nodeLabels", this.nodeLabels());
        map.put("username", this.usernameOverride());
        map.put("sudo", this.sudo());
        map.put("concurrency", this.concurrency());
        map.put("relationshipWeightProperty", this.relationshipWeightProperty());
        this.randomSeed().ifPresent(randomSeed -> map.put("randomSeed", randomSeed));
        map.put("sourceNodes", this.sourceNodes());
        return map;
    }

    public int concurrency() {
        return this.concurrency;
    }

    @Nullable
    public String relationshipWeightProperty() {
        return this.relationshipWeightProperty;
    }

    public Optional<Long> randomSeed() {
        return this.randomSeed;
    }

    public List<Long> sourceNodes() {
        return this.sourceNodes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Object> config = new HashMap<String, Object>();

        public Builder walkLength(int walkLength) {
            this.config.put("walkLength", walkLength);
            return this;
        }

        public Builder walksPerNode(int walksPerNode) {
            this.config.put("walksPerNode", walksPerNode);
            return this;
        }

        public Builder walkBufferSize(int walkBufferSize) {
            this.config.put("walkBufferSize", walkBufferSize);
            return this;
        }

        public Builder inOutFactor(double inOutFactor) {
            this.config.put("inOutFactor", inOutFactor);
            return this;
        }

        public Builder returnFactor(double returnFactor) {
            this.config.put("returnFactor", returnFactor);
            return this;
        }

        public Builder relationshipTypes(List<String> relationshipTypes) {
            this.config.put("relationshipTypes", relationshipTypes);
            return this;
        }

        public Builder nodeLabels(List<String> nodeLabels) {
            this.config.put("nodeLabels", nodeLabels);
            return this;
        }

        public Builder usernameOverride(String usernameOverride) {
            this.config.put("username", usernameOverride);
            return this;
        }

        public Builder sudo(boolean sudo) {
            this.config.put("sudo", sudo);
            return this;
        }

        public Builder concurrency(int concurrency) {
            this.config.put("concurrency", concurrency);
            return this;
        }

        public Builder relationshipWeightProperty(String relationshipWeightProperty) {
            this.config.put("relationshipWeightProperty", relationshipWeightProperty);
            return this;
        }

        public Builder randomSeed(Long randomSeed) {
            this.config.put("randomSeed", randomSeed);
            return this;
        }

        public Builder randomSeed(Optional<Long> randomSeed) {
            randomSeed.ifPresent(actualrandomSeed -> this.config.put("randomSeed", actualrandomSeed));
            return this;
        }

        public Builder sourceNodes(Object sourceNodes) {
            this.config.put("sourceNodes", sourceNodes);
            return this;
        }

        public RandomWalkStreamConfig build() {
            CypherMapWrapper config = CypherMapWrapper.create(this.config);
            return new RandomWalkStreamConfigImpl(config);
        }
    }
}

