/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.triangle;

import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.core.utils.paged.HugeDoubleArray;
import org.neo4j.gds.triangle.LocalClusteringCoefficient;

@Generated(from="LocalClusteringCoefficient.Result", generator="Immutables")
public final class ImmutableResult
implements LocalClusteringCoefficient.Result {
    private final HugeDoubleArray localClusteringCoefficients;
    private final double averageClusteringCoefficient;

    private ImmutableResult(HugeDoubleArray localClusteringCoefficients, double averageClusteringCoefficient) {
        this.localClusteringCoefficients = Objects.requireNonNull(localClusteringCoefficients, "localClusteringCoefficients");
        this.averageClusteringCoefficient = averageClusteringCoefficient;
    }

    private ImmutableResult(ImmutableResult original, HugeDoubleArray localClusteringCoefficients, double averageClusteringCoefficient) {
        this.localClusteringCoefficients = localClusteringCoefficients;
        this.averageClusteringCoefficient = averageClusteringCoefficient;
    }

    @Override
    public HugeDoubleArray localClusteringCoefficients() {
        return this.localClusteringCoefficients;
    }

    @Override
    public double averageClusteringCoefficient() {
        return this.averageClusteringCoefficient;
    }

    public final ImmutableResult withLocalClusteringCoefficients(HugeDoubleArray value) {
        if (this.localClusteringCoefficients == value) {
            return this;
        }
        HugeDoubleArray newValue = Objects.requireNonNull(value, "localClusteringCoefficients");
        return new ImmutableResult(this, newValue, this.averageClusteringCoefficient);
    }

    public final ImmutableResult withAverageClusteringCoefficient(double value) {
        if (Double.doubleToLongBits(this.averageClusteringCoefficient) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableResult(this, this.localClusteringCoefficients, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableResult && this.equalTo((ImmutableResult)another);
    }

    private boolean equalTo(ImmutableResult another) {
        return this.localClusteringCoefficients.equals(another.localClusteringCoefficients) && Double.doubleToLongBits(this.averageClusteringCoefficient) == Double.doubleToLongBits(another.averageClusteringCoefficient);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.localClusteringCoefficients.hashCode();
        h += (h << 5) + Double.hashCode(this.averageClusteringCoefficient);
        return h;
    }

    public String toString() {
        return "Result{localClusteringCoefficients=" + this.localClusteringCoefficients + ", averageClusteringCoefficient=" + this.averageClusteringCoefficient + "}";
    }

    public static LocalClusteringCoefficient.Result of(HugeDoubleArray localClusteringCoefficients, double averageClusteringCoefficient) {
        return new ImmutableResult(localClusteringCoefficients, averageClusteringCoefficient);
    }

    static LocalClusteringCoefficient.Result copyOf(LocalClusteringCoefficient.Result instance) {
        if (instance instanceof ImmutableResult) {
            return (ImmutableResult)instance;
        }
        return ImmutableResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="LocalClusteringCoefficient.Result", generator="Immutables")
    static final class Builder {
        private static final long INIT_BIT_LOCAL_CLUSTERING_COEFFICIENTS = 1L;
        private static final long INIT_BIT_AVERAGE_CLUSTERING_COEFFICIENT = 2L;
        private long initBits = 3L;
        private HugeDoubleArray localClusteringCoefficients;
        private double averageClusteringCoefficient;

        private Builder() {
        }

        public final Builder from(ImmutableResult instance) {
            return this.from((LocalClusteringCoefficient.Result)instance);
        }

        final Builder from(LocalClusteringCoefficient.Result instance) {
            Objects.requireNonNull(instance, "instance");
            this.localClusteringCoefficients(instance.localClusteringCoefficients());
            this.averageClusteringCoefficient(instance.averageClusteringCoefficient());
            return this;
        }

        public final Builder localClusteringCoefficients(HugeDoubleArray localClusteringCoefficients) {
            this.localClusteringCoefficients = Objects.requireNonNull(localClusteringCoefficients, "localClusteringCoefficients");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder averageClusteringCoefficient(double averageClusteringCoefficient) {
            this.averageClusteringCoefficient = averageClusteringCoefficient;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.localClusteringCoefficients = null;
            this.averageClusteringCoefficient = 0.0;
            return this;
        }

        public LocalClusteringCoefficient.Result build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableResult(null, this.localClusteringCoefficients, this.averageClusteringCoefficient);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("localClusteringCoefficients");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("averageClusteringCoefficient");
            }
            return "Cannot build Result, some of required attributes are not set " + attributes;
        }
    }
}

