/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.triangle;

import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.core.utils.paged.HugeAtomicLongArray;
import org.neo4j.gds.triangle.IntersectingTriangleCount;

@Generated(from="IntersectingTriangleCount.TriangleCountResult", generator="Immutables")
public final class ImmutableTriangleCountResult
implements IntersectingTriangleCount.TriangleCountResult {
    private final HugeAtomicLongArray localTriangles;
    private final long globalTriangles;

    private ImmutableTriangleCountResult(HugeAtomicLongArray localTriangles, long globalTriangles) {
        this.localTriangles = Objects.requireNonNull(localTriangles, "localTriangles");
        this.globalTriangles = globalTriangles;
    }

    private ImmutableTriangleCountResult(ImmutableTriangleCountResult original, HugeAtomicLongArray localTriangles, long globalTriangles) {
        this.localTriangles = localTriangles;
        this.globalTriangles = globalTriangles;
    }

    @Override
    public HugeAtomicLongArray localTriangles() {
        return this.localTriangles;
    }

    @Override
    public long globalTriangles() {
        return this.globalTriangles;
    }

    public final ImmutableTriangleCountResult withLocalTriangles(HugeAtomicLongArray value) {
        if (this.localTriangles == value) {
            return this;
        }
        HugeAtomicLongArray newValue = Objects.requireNonNull(value, "localTriangles");
        return new ImmutableTriangleCountResult(this, newValue, this.globalTriangles);
    }

    public final ImmutableTriangleCountResult withGlobalTriangles(long value) {
        if (this.globalTriangles == value) {
            return this;
        }
        return new ImmutableTriangleCountResult(this, this.localTriangles, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTriangleCountResult && this.equalTo((ImmutableTriangleCountResult)another);
    }

    private boolean equalTo(ImmutableTriangleCountResult another) {
        return this.localTriangles.equals(another.localTriangles) && this.globalTriangles == another.globalTriangles;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.localTriangles.hashCode();
        h += (h << 5) + Long.hashCode(this.globalTriangles);
        return h;
    }

    public String toString() {
        return "TriangleCountResult{localTriangles=" + this.localTriangles + ", globalTriangles=" + this.globalTriangles + "}";
    }

    public static IntersectingTriangleCount.TriangleCountResult of(HugeAtomicLongArray localTriangles, long globalTriangles) {
        return new ImmutableTriangleCountResult(localTriangles, globalTriangles);
    }

    public static IntersectingTriangleCount.TriangleCountResult copyOf(IntersectingTriangleCount.TriangleCountResult instance) {
        if (instance instanceof ImmutableTriangleCountResult) {
            return (ImmutableTriangleCountResult)instance;
        }
        return ImmutableTriangleCountResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="IntersectingTriangleCount.TriangleCountResult", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_LOCAL_TRIANGLES = 1L;
        private static final long INIT_BIT_GLOBAL_TRIANGLES = 2L;
        private long initBits = 3L;
        private HugeAtomicLongArray localTriangles;
        private long globalTriangles;

        private Builder() {
        }

        public final Builder from(IntersectingTriangleCount.TriangleCountResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.localTriangles(instance.localTriangles());
            this.globalTriangles(instance.globalTriangles());
            return this;
        }

        public final Builder localTriangles(HugeAtomicLongArray localTriangles) {
            this.localTriangles = Objects.requireNonNull(localTriangles, "localTriangles");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder globalTriangles(long globalTriangles) {
            this.globalTriangles = globalTriangles;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.localTriangles = null;
            this.globalTriangles = 0L;
            return this;
        }

        public IntersectingTriangleCount.TriangleCountResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTriangleCountResult(null, this.localTriangles, this.globalTriangles);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("localTriangles");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("globalTriangles");
            }
            return "Cannot build TriangleCountResult, some of required attributes are not set " + attributes;
        }
    }
}

