/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.triangle;

import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.neo4j.gds.Algorithm;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.IntersectionConsumer;
import org.neo4j.gds.api.RelationshipIntersect;
import org.neo4j.gds.api.nodeproperties.LongNodeProperties;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.utils.paged.HugeAtomicLongArray;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.triangle.ImmutableTriangleCountResult;
import org.neo4j.gds.triangle.TriangleCountBaseConfig;
import org.neo4j.gds.triangle.intersect.ImmutableRelationshipIntersectConfig;
import org.neo4j.gds.triangle.intersect.RelationshipIntersectConfig;
import org.neo4j.gds.triangle.intersect.RelationshipIntersectFactory;
import org.neo4j.gds.triangle.intersect.RelationshipIntersectFactoryLocator;

public final class IntersectingTriangleCount
extends Algorithm<TriangleCountResult> {
    static final int EXCLUDED_NODE_TRIANGLE_COUNT = -1;
    private Graph graph;
    private final RelationshipIntersectFactory intersectFactory;
    private final RelationshipIntersectConfig intersectConfig;
    private final TriangleCountBaseConfig config;
    private ExecutorService executorService;
    private final AtomicLong queue;
    private final HugeAtomicLongArray triangleCounts;
    private long globalTriangleCount;
    private LongAdder globalTriangleCounter;

    public static IntersectingTriangleCount create(Graph graph, TriangleCountBaseConfig config, ExecutorService executorService, ProgressTracker progressTracker) {
        RelationshipIntersectFactory factory = RelationshipIntersectFactoryLocator.lookup(graph).orElseThrow(() -> new IllegalArgumentException("No relationship intersect factory registered for graph: " + graph.getClass()));
        return new IntersectingTriangleCount(graph, factory, config, executorService, progressTracker);
    }

    public static IntersectingTriangleCount create(Graph graph, TriangleCountBaseConfig config, ExecutorService executorService) {
        return IntersectingTriangleCount.create(graph, config, executorService, ProgressTracker.NULL_TRACKER);
    }

    private IntersectingTriangleCount(Graph graph, RelationshipIntersectFactory intersectFactory, TriangleCountBaseConfig config, ExecutorService executorService, ProgressTracker progressTracker) {
        super(progressTracker);
        this.graph = graph;
        this.intersectFactory = intersectFactory;
        this.intersectConfig = ImmutableRelationshipIntersectConfig.of(config.maxDegree());
        this.config = config;
        this.executorService = executorService;
        this.triangleCounts = HugeAtomicLongArray.newArray((long)graph.nodeCount());
        this.globalTriangleCounter = new LongAdder();
        this.queue = new AtomicLong();
    }

    public void release() {
        this.executorService = null;
        this.graph = null;
        this.globalTriangleCounter = null;
    }

    public TriangleCountResult compute() {
        this.progressTracker.beginSubTask();
        this.queue.set(0L);
        this.globalTriangleCounter.reset();
        Collection tasks = ParallelUtil.tasks((int)this.config.concurrency(), () -> new IntersectTask(this.intersectFactory.load(this.graph, this.intersectConfig)));
        ParallelUtil.run((Collection)tasks, (ExecutorService)this.executorService);
        this.globalTriangleCount = this.globalTriangleCounter.longValue();
        this.progressTracker.endSubTask();
        return TriangleCountResult.of(this.triangleCounts, this.globalTriangleCount);
    }

    @ValueClass
    public static interface TriangleCountResult {
        public HugeAtomicLongArray localTriangles();

        public long globalTriangles();

        public static TriangleCountResult of(HugeAtomicLongArray triangles, long globalTriangles) {
            return ImmutableTriangleCountResult.builder().localTriangles(triangles).globalTriangles(globalTriangles).build();
        }

        default public LongNodeProperties asNodeProperties() {
            return this.localTriangles().asNodeProperties();
        }
    }

    private class IntersectTask
    implements Runnable,
    IntersectionConsumer {
        private final RelationshipIntersect intersect;

        IntersectTask(RelationshipIntersect relationshipIntersect) {
            this.intersect = relationshipIntersect;
        }

        @Override
        public void run() {
            long node;
            while ((node = IntersectingTriangleCount.this.queue.getAndIncrement()) < IntersectingTriangleCount.this.graph.nodeCount() && IntersectingTriangleCount.this.running()) {
                if ((long)IntersectingTriangleCount.this.graph.degree(node) <= IntersectingTriangleCount.this.config.maxDegree()) {
                    this.intersect.intersectAll(node, (IntersectionConsumer)this);
                } else {
                    IntersectingTriangleCount.this.triangleCounts.set(node, -1L);
                }
                IntersectingTriangleCount.this.progressTracker.logProgress();
            }
        }

        public void accept(long nodeA, long nodeB, long nodeC) {
            if (nodeA < nodeB) {
                IntersectingTriangleCount.this.triangleCounts.update(nodeA, previous -> previous + 1L);
                IntersectingTriangleCount.this.triangleCounts.update(nodeB, previous -> previous + 1L);
                IntersectingTriangleCount.this.triangleCounts.update(nodeC, previous -> previous + 1L);
                IntersectingTriangleCount.this.globalTriangleCounter.increment();
            }
        }
    }
}

