/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.triangle;

import org.immutables.value.Value;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.triangle.TriangleCountBaseConfigImpl;

@ValueClass
@Configuration
public interface TriangleCountBaseConfig
extends AlgoBaseConfig {
    @Value.Default
    default public long maxDegree() {
        return Long.MAX_VALUE;
    }

    @Value.Check
    default public void validateMaxDegree() {
        if (this.maxDegree() < 2L) {
            throw new IllegalArgumentException("The 'maxDegree' parameter must be set to a value greater than 1.");
        }
    }

    public static TriangleCountBaseConfig of(CypherMapWrapper userInput) {
        return new TriangleCountBaseConfigImpl(userInput);
    }
}

