/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.triangle.intersect;

import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.IntersectionConsumer;
import org.neo4j.gds.api.RelationshipIntersect;
import org.neo4j.gds.core.huge.NodeFilteredGraph;
import org.neo4j.gds.triangle.intersect.RelationshipIntersectConfig;
import org.neo4j.gds.triangle.intersect.RelationshipIntersectFactory;
import org.neo4j.gds.triangle.intersect.RelationshipIntersectFactoryLocator;

public final class NodeFilteredGraphIntersect
implements RelationshipIntersect {
    private final NodeFilteredGraph filteredGraph;
    private final RelationshipIntersect wrappedRelationshipIntersect;

    private NodeFilteredGraphIntersect(NodeFilteredGraph filteredGraph, RelationshipIntersect wrappedRelationshipIntersect) {
        this.filteredGraph = filteredGraph;
        this.wrappedRelationshipIntersect = wrappedRelationshipIntersect;
    }

    public void intersectAll(long nodeIdA, IntersectionConsumer consumer) {
        this.wrappedRelationshipIntersect.intersectAll(this.filteredGraph.toRootNodeId(nodeIdA), (a, b, c) -> {
            if (this.filteredGraph.contains(a) && this.filteredGraph.contains(b) && this.filteredGraph.contains(c)) {
                consumer.accept(this.filteredGraph.getFilteredMappedNodeId(a), this.filteredGraph.getFilteredMappedNodeId(b), this.filteredGraph.getFilteredMappedNodeId(c));
            }
        });
    }

    public static final class NodeFilteredGraphIntersectFactory
    implements RelationshipIntersectFactory {
        @Override
        public boolean canLoad(Graph graph) {
            return graph instanceof NodeFilteredGraph;
        }

        @Override
        public RelationshipIntersect load(Graph graph, RelationshipIntersectConfig config) {
            assert (graph instanceof NodeFilteredGraph);
            NodeFilteredGraph nodeFilteredGraph = (NodeFilteredGraph)graph;
            Graph innerGraph = nodeFilteredGraph.graph();
            RelationshipIntersect relationshipIntersect = RelationshipIntersectFactoryLocator.lookup(innerGraph).orElseThrow(() -> new IllegalArgumentException("No intersect factory found for graph type " + innerGraph.getClass())).load(innerGraph, config);
            return new NodeFilteredGraphIntersect(nodeFilteredGraph, relationshipIntersect);
        }
    }
}

