/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.triangle.intersect;

import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.triangle.intersect.RelationshipIntersectFactory;

public final class RelationshipIntersectFactoryLocator {
    private static final List<RelationshipIntersectFactory> FACTORIES = ServiceLoader.load(RelationshipIntersectFactory.class).stream().map(ServiceLoader.Provider::get).collect(Collectors.toList());

    public static Optional<RelationshipIntersectFactory> lookup(Graph graph) {
        return FACTORIES.stream().filter(f -> f.canLoad(graph)).findFirst();
    }

    private RelationshipIntersectFactoryLocator() {
    }
}

