/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.triangle.intersect;

import java.io.Serializable;
import java.util.function.LongToIntFunction;
import org.eclipse.collections.api.block.function.primitive.LongToLongFunction;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.api.AdjacencyCursor;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.huge.CompositeAdjacencyCursor;
import org.neo4j.gds.core.huge.CompositeAdjacencyList;
import org.neo4j.gds.core.huge.UnionGraph;
import org.neo4j.gds.triangle.intersect.GraphIntersect;
import org.neo4j.gds.triangle.intersect.RelationshipIntersectConfig;
import org.neo4j.gds.triangle.intersect.RelationshipIntersectFactory;

public final class UnionGraphIntersect
extends GraphIntersect<CompositeAdjacencyCursor> {
    private final LongToIntFunction degreeFunction;
    private final LongToLongFunction fromFilteredIdFunction;
    private final CompositeAdjacencyList compositeAdjacencyList;

    private UnionGraphIntersect(LongToIntFunction degreeFunction, LongToLongFunction fromFilteredIdFunction, CompositeAdjacencyList compositeAdjacencyList, long maxDegree) {
        super(maxDegree);
        this.degreeFunction = degreeFunction;
        this.fromFilteredIdFunction = fromFilteredIdFunction;
        this.compositeAdjacencyList = compositeAdjacencyList;
    }

    @Override
    protected int degree(long nodeId) {
        return this.degreeFunction.applyAsInt(nodeId);
    }

    @Override
    protected CompositeAdjacencyCursor checkCursorInstance(AdjacencyCursor cursor) {
        return (CompositeAdjacencyCursor)cursor;
    }

    @Override
    protected CompositeAdjacencyCursor cursorForNode(@Nullable CompositeAdjacencyCursor reuse, long node, int degree) {
        return this.compositeAdjacencyList.adjacencyCursor((AdjacencyCursor)reuse, this.fromFilteredIdFunction.applyAsLong(node));
    }

    public static final class NodeFilteredUnionGraphIntersectFactory
    implements RelationshipIntersectFactory {
        @Override
        public boolean canLoad(Graph graph) {
            if (graph instanceof UnionGraph) {
                return ((UnionGraph)graph).isNodeFilteredGraph();
            }
            return false;
        }

        @Override
        public UnionGraphIntersect load(Graph graph, RelationshipIntersectConfig config) {
            assert (graph instanceof UnionGraph);
            CompositeAdjacencyList topology = ((UnionGraph)graph).relationshipTopology();
            return new UnionGraphIntersect(arg_0 -> ((Graph)graph).degree(arg_0), arg_0 -> ((Graph)graph).toRootNodeId(arg_0), topology, config.maxDegree());
        }
    }

    public static final class UnionGraphIntersectFactory
    implements RelationshipIntersectFactory {
        @Override
        public boolean canLoad(Graph graph) {
            if (graph instanceof UnionGraph) {
                return !((UnionGraph)graph).isNodeFilteredGraph();
            }
            return false;
        }

        @Override
        public UnionGraphIntersect load(Graph graph, RelationshipIntersectConfig config) {
            assert (graph instanceof UnionGraph);
            CompositeAdjacencyList topology = ((UnionGraph)graph).relationshipTopology();
            return new UnionGraphIntersect(arg_0 -> ((Graph)graph).degree(arg_0), (LongToLongFunction & Serializable)i -> i, topology, config.maxDegree());
        }
    }
}

