/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.wcc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.ConcurrencyConfig;
import org.neo4j.gds.config.ConsecutiveIdsConfig;
import org.neo4j.gds.config.RelationshipWeightConfig;
import org.neo4j.gds.config.SeedConfig;
import org.neo4j.gds.wcc.WccBaseConfig;
import org.neo4j.gds.wcc.WccStatsConfig;

@Generated(from="WccStatsConfig", generator="Immutables")
public final class ImmutableWccStatsConfig
implements WccStatsConfig {
    @Nullable
    private final String usernameOverride;
    private final boolean sudo;
    private final Collection<String> configKeys;
    private final transient Map<String, Object> toMap;
    private final int concurrency;
    private final int minBatchSize;
    private final List<String> relationshipTypes;
    private final List<String> nodeLabels;
    @Nullable
    private final String seedProperty;
    private final boolean consecutiveIds;
    @Nullable
    private final String relationshipWeightProperty;
    private final transient boolean hasRelationshipWeightProperty;
    private final double threshold;
    private final boolean hasThreshold;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableWccStatsConfig(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, @Nullable String seedProperty, boolean consecutiveIds, @Nullable String relationshipWeightProperty, double threshold, boolean hasThreshold) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(ImmutableWccStatsConfig.createUnmodifiableList(false, ImmutableWccStatsConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableWccStatsConfig.createUnmodifiableList(false, ImmutableWccStatsConfig.createSafeList(nodeLabels, true, false)));
        this.initShim.seedProperty(seedProperty);
        this.initShim.consecutiveIds(consecutiveIds);
        this.initShim.relationshipWeightProperty(relationshipWeightProperty);
        this.initShim.threshold(threshold);
        this.initShim.hasThreshold(hasThreshold);
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.seedProperty = this.initShim.seedProperty();
        this.consecutiveIds = this.initShim.consecutiveIds();
        this.relationshipWeightProperty = this.initShim.relationshipWeightProperty();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.threshold = this.initShim.threshold();
        this.hasThreshold = this.initShim.hasThreshold();
        this.initShim = null;
    }

    private ImmutableWccStatsConfig(Builder builder) {
        if (builder.usernameOverrideIsSet()) {
            this.initShim.usernameOverride(builder.usernameOverride);
        }
        if (builder.sudoIsSet()) {
            this.initShim.sudo(builder.sudo);
        }
        if (builder.configKeys != null) {
            this.initShim.configKeys(builder.configKeys);
        }
        if (builder.concurrencyIsSet()) {
            this.initShim.concurrency(builder.concurrency);
        }
        if (builder.minBatchSizeIsSet()) {
            this.initShim.minBatchSize(builder.minBatchSize);
        }
        if (builder.relationshipTypesIsSet()) {
            this.initShim.relationshipTypes(builder.relationshipTypes == null ? Collections.emptyList() : ImmutableWccStatsConfig.createUnmodifiableList(true, builder.relationshipTypes));
        }
        if (builder.nodeLabelsIsSet()) {
            this.initShim.nodeLabels(builder.nodeLabels == null ? Collections.emptyList() : ImmutableWccStatsConfig.createUnmodifiableList(true, builder.nodeLabels));
        }
        if (builder.seedPropertyIsSet()) {
            this.initShim.seedProperty(builder.seedProperty);
        }
        if (builder.consecutiveIdsIsSet()) {
            this.initShim.consecutiveIds(builder.consecutiveIds);
        }
        if (builder.relationshipWeightPropertyIsSet()) {
            this.initShim.relationshipWeightProperty(builder.relationshipWeightProperty);
        }
        if (builder.thresholdIsSet()) {
            this.initShim.threshold(builder.threshold);
        }
        if (builder.hasThresholdIsSet()) {
            this.initShim.hasThreshold(builder.hasThreshold);
        }
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.seedProperty = this.initShim.seedProperty();
        this.consecutiveIds = this.initShim.consecutiveIds();
        this.relationshipWeightProperty = this.initShim.relationshipWeightProperty();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.threshold = this.initShim.threshold();
        this.hasThreshold = this.initShim.hasThreshold();
        this.initShim = null;
    }

    private ImmutableWccStatsConfig(@Nullable String usernameOverride, boolean sudo, Collection<String> configKeys, int concurrency, int minBatchSize, List<String> relationshipTypes, List<String> nodeLabels, @Nullable String seedProperty, boolean consecutiveIds, @Nullable String relationshipWeightProperty, double threshold, boolean hasThreshold) {
        this.initShim.usernameOverride(usernameOverride);
        this.initShim.sudo(sudo);
        this.initShim.configKeys(configKeys);
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(relationshipTypes);
        this.initShim.nodeLabels(nodeLabels);
        this.initShim.seedProperty(seedProperty);
        this.initShim.consecutiveIds(consecutiveIds);
        this.initShim.relationshipWeightProperty(relationshipWeightProperty);
        this.initShim.threshold(threshold);
        this.initShim.hasThreshold(hasThreshold);
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.seedProperty = this.initShim.seedProperty();
        this.consecutiveIds = this.initShim.consecutiveIds();
        this.relationshipWeightProperty = this.initShim.relationshipWeightProperty();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.threshold = this.initShim.threshold();
        this.hasThreshold = this.initShim.hasThreshold();
        this.initShim = null;
    }

    @Nullable
    private String usernameOverrideInitialize() {
        return WccStatsConfig.super.usernameOverride();
    }

    private boolean sudoInitialize() {
        return WccStatsConfig.super.sudo();
    }

    private Collection<String> configKeysInitialize() {
        return WccStatsConfig.super.configKeys();
    }

    private Map<String, Object> toMapInitialize() {
        return WccStatsConfig.super.toMap();
    }

    private int concurrencyInitialize() {
        return WccStatsConfig.super.concurrency();
    }

    private int minBatchSizeInitialize() {
        return WccStatsConfig.super.minBatchSize();
    }

    private List<String> relationshipTypesInitialize() {
        return WccStatsConfig.super.relationshipTypes();
    }

    private List<String> nodeLabelsInitialize() {
        return WccStatsConfig.super.nodeLabels();
    }

    @Nullable
    private String seedPropertyInitialize() {
        return WccStatsConfig.super.seedProperty();
    }

    private boolean consecutiveIdsInitialize() {
        return WccStatsConfig.super.consecutiveIds();
    }

    @Nullable
    private String relationshipWeightPropertyInitialize() {
        return WccStatsConfig.super.relationshipWeightProperty();
    }

    private boolean hasRelationshipWeightPropertyInitialize() {
        return WccStatsConfig.super.hasRelationshipWeightProperty();
    }

    private double thresholdInitialize() {
        return WccStatsConfig.super.threshold();
    }

    private boolean hasThresholdInitialize() {
        return WccStatsConfig.super.hasThreshold();
    }

    @Nullable
    public String usernameOverride() {
        InitShim shim = this.initShim;
        return shim != null ? shim.usernameOverride() : this.usernameOverride;
    }

    public boolean sudo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sudo() : this.sudo;
    }

    public Collection<String> configKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.configKeys() : this.configKeys;
    }

    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    public int concurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.concurrency() : this.concurrency;
    }

    public int minBatchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.minBatchSize() : this.minBatchSize;
    }

    public List<String> relationshipTypes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipTypes() : this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nodeLabels() : this.nodeLabels;
    }

    @Nullable
    public String seedProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.seedProperty() : this.seedProperty;
    }

    public boolean consecutiveIds() {
        InitShim shim = this.initShim;
        return shim != null ? shim.consecutiveIds() : this.consecutiveIds;
    }

    @Nullable
    public String relationshipWeightProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipWeightProperty() : this.relationshipWeightProperty;
    }

    public boolean hasRelationshipWeightProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasRelationshipWeightProperty() : this.hasRelationshipWeightProperty;
    }

    @Override
    public double threshold() {
        InitShim shim = this.initShim;
        return shim != null ? shim.threshold() : this.threshold;
    }

    @Override
    public boolean hasThreshold() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasThreshold() : this.hasThreshold;
    }

    public final ImmutableWccStatsConfig withUsernameOverride(@Nullable String value) {
        if (Objects.equals(this.usernameOverride, value)) {
            return this;
        }
        return ImmutableWccStatsConfig.validate(new ImmutableWccStatsConfig(value, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.seedProperty, this.consecutiveIds, this.relationshipWeightProperty, this.threshold, this.hasThreshold));
    }

    public final ImmutableWccStatsConfig withSudo(boolean value) {
        if (this.sudo == value) {
            return this;
        }
        return ImmutableWccStatsConfig.validate(new ImmutableWccStatsConfig(this.usernameOverride, value, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.seedProperty, this.consecutiveIds, this.relationshipWeightProperty, this.threshold, this.hasThreshold));
    }

    public final ImmutableWccStatsConfig withConfigKeys(Collection<String> value) {
        if (this.configKeys == value) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(value, "configKeys");
        return ImmutableWccStatsConfig.validate(new ImmutableWccStatsConfig(this.usernameOverride, this.sudo, newValue, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.seedProperty, this.consecutiveIds, this.relationshipWeightProperty, this.threshold, this.hasThreshold));
    }

    public final ImmutableWccStatsConfig withConcurrency(int value) {
        if (this.concurrency == value) {
            return this;
        }
        return ImmutableWccStatsConfig.validate(new ImmutableWccStatsConfig(this.usernameOverride, this.sudo, this.configKeys, value, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.seedProperty, this.consecutiveIds, this.relationshipWeightProperty, this.threshold, this.hasThreshold));
    }

    public final ImmutableWccStatsConfig withMinBatchSize(int value) {
        if (this.minBatchSize == value) {
            return this;
        }
        return ImmutableWccStatsConfig.validate(new ImmutableWccStatsConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, value, this.relationshipTypes, this.nodeLabels, this.seedProperty, this.consecutiveIds, this.relationshipWeightProperty, this.threshold, this.hasThreshold));
    }

    public final ImmutableWccStatsConfig withRelationshipTypes(String ... elements) {
        List<String> newValue = ImmutableWccStatsConfig.createUnmodifiableList(false, ImmutableWccStatsConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableWccStatsConfig.validate(new ImmutableWccStatsConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, newValue, this.nodeLabels, this.seedProperty, this.consecutiveIds, this.relationshipWeightProperty, this.threshold, this.hasThreshold));
    }

    public final ImmutableWccStatsConfig withRelationshipTypes(Iterable<String> elements) {
        if (this.relationshipTypes == elements) {
            return this;
        }
        List<String> newValue = ImmutableWccStatsConfig.createUnmodifiableList(false, ImmutableWccStatsConfig.createSafeList(elements, true, false));
        return ImmutableWccStatsConfig.validate(new ImmutableWccStatsConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, newValue, this.nodeLabels, this.seedProperty, this.consecutiveIds, this.relationshipWeightProperty, this.threshold, this.hasThreshold));
    }

    public final ImmutableWccStatsConfig withNodeLabels(String ... elements) {
        List<String> newValue = ImmutableWccStatsConfig.createUnmodifiableList(false, ImmutableWccStatsConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableWccStatsConfig.validate(new ImmutableWccStatsConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, newValue, this.seedProperty, this.consecutiveIds, this.relationshipWeightProperty, this.threshold, this.hasThreshold));
    }

    public final ImmutableWccStatsConfig withNodeLabels(Iterable<String> elements) {
        if (this.nodeLabels == elements) {
            return this;
        }
        List<String> newValue = ImmutableWccStatsConfig.createUnmodifiableList(false, ImmutableWccStatsConfig.createSafeList(elements, true, false));
        return ImmutableWccStatsConfig.validate(new ImmutableWccStatsConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, newValue, this.seedProperty, this.consecutiveIds, this.relationshipWeightProperty, this.threshold, this.hasThreshold));
    }

    public final ImmutableWccStatsConfig withSeedProperty(@Nullable String value) {
        if (Objects.equals(this.seedProperty, value)) {
            return this;
        }
        return ImmutableWccStatsConfig.validate(new ImmutableWccStatsConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, value, this.consecutiveIds, this.relationshipWeightProperty, this.threshold, this.hasThreshold));
    }

    public final ImmutableWccStatsConfig withConsecutiveIds(boolean value) {
        if (this.consecutiveIds == value) {
            return this;
        }
        return ImmutableWccStatsConfig.validate(new ImmutableWccStatsConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.seedProperty, value, this.relationshipWeightProperty, this.threshold, this.hasThreshold));
    }

    public final ImmutableWccStatsConfig withRelationshipWeightProperty(@Nullable String value) {
        if (Objects.equals(this.relationshipWeightProperty, value)) {
            return this;
        }
        return ImmutableWccStatsConfig.validate(new ImmutableWccStatsConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.seedProperty, this.consecutiveIds, value, this.threshold, this.hasThreshold));
    }

    public final ImmutableWccStatsConfig withThreshold(double value) {
        if (Double.doubleToLongBits(this.threshold) == Double.doubleToLongBits(value)) {
            return this;
        }
        return ImmutableWccStatsConfig.validate(new ImmutableWccStatsConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.seedProperty, this.consecutiveIds, this.relationshipWeightProperty, value, this.hasThreshold));
    }

    public final ImmutableWccStatsConfig withHasThreshold(boolean value) {
        if (this.hasThreshold == value) {
            return this;
        }
        return ImmutableWccStatsConfig.validate(new ImmutableWccStatsConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.seedProperty, this.consecutiveIds, this.relationshipWeightProperty, this.threshold, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableWccStatsConfig && this.equalTo((ImmutableWccStatsConfig)another);
    }

    private boolean equalTo(ImmutableWccStatsConfig another) {
        return Objects.equals(this.usernameOverride, another.usernameOverride) && this.sudo == another.sudo && this.concurrency == another.concurrency && this.minBatchSize == another.minBatchSize && this.relationshipTypes.equals(another.relationshipTypes) && this.nodeLabels.equals(another.nodeLabels) && Objects.equals(this.seedProperty, another.seedProperty) && this.consecutiveIds == another.consecutiveIds && Objects.equals(this.relationshipWeightProperty, another.relationshipWeightProperty) && this.hasRelationshipWeightProperty == another.hasRelationshipWeightProperty && Double.doubleToLongBits(this.threshold) == Double.doubleToLongBits(another.threshold) && this.hasThreshold == another.hasThreshold;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.usernameOverride);
        h += (h << 5) + Boolean.hashCode(this.sudo);
        h += (h << 5) + this.concurrency;
        h += (h << 5) + this.minBatchSize;
        h += (h << 5) + this.relationshipTypes.hashCode();
        h += (h << 5) + this.nodeLabels.hashCode();
        h += (h << 5) + Objects.hashCode(this.seedProperty);
        h += (h << 5) + Boolean.hashCode(this.consecutiveIds);
        h += (h << 5) + Objects.hashCode(this.relationshipWeightProperty);
        h += (h << 5) + Boolean.hashCode(this.hasRelationshipWeightProperty);
        h += (h << 5) + Double.hashCode(this.threshold);
        h += (h << 5) + Boolean.hashCode(this.hasThreshold);
        return h;
    }

    public String toString() {
        return "WccStatsConfig{usernameOverride=" + this.usernameOverride + ", sudo=" + this.sudo + ", concurrency=" + this.concurrency + ", minBatchSize=" + this.minBatchSize + ", relationshipTypes=" + this.relationshipTypes + ", nodeLabels=" + this.nodeLabels + ", seedProperty=" + this.seedProperty + ", consecutiveIds=" + this.consecutiveIds + ", relationshipWeightProperty=" + this.relationshipWeightProperty + ", hasRelationshipWeightProperty=" + this.hasRelationshipWeightProperty + ", threshold=" + this.threshold + ", hasThreshold=" + this.hasThreshold + "}";
    }

    public static WccStatsConfig of(int concurrency, int minBatchSize, List<String> relationshipTypes, List<String> nodeLabels, @Nullable String seedProperty, boolean consecutiveIds, @Nullable String relationshipWeightProperty, double threshold, boolean hasThreshold) {
        return ImmutableWccStatsConfig.of(concurrency, minBatchSize, relationshipTypes, nodeLabels, seedProperty, consecutiveIds, relationshipWeightProperty, threshold, hasThreshold);
    }

    public static WccStatsConfig of(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, @Nullable String seedProperty, boolean consecutiveIds, @Nullable String relationshipWeightProperty, double threshold, boolean hasThreshold) {
        return ImmutableWccStatsConfig.validate(new ImmutableWccStatsConfig(concurrency, minBatchSize, relationshipTypes, nodeLabels, seedProperty, consecutiveIds, relationshipWeightProperty, threshold, hasThreshold));
    }

    private static ImmutableWccStatsConfig validate(ImmutableWccStatsConfig instance) {
        instance.validate();
        instance.forbidSeedingAndConsecutiveIds();
        instance.validateConcurrency();
        return instance;
    }

    public static WccStatsConfig copyOf(WccStatsConfig instance) {
        if (instance instanceof ImmutableWccStatsConfig) {
            return (ImmutableWccStatsConfig)instance;
        }
        return ImmutableWccStatsConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="WccStatsConfig", generator="Immutables")
    public static final class Builder {
        private static final long OPT_BIT_USERNAME_OVERRIDE = 1L;
        private static final long OPT_BIT_SUDO = 2L;
        private static final long OPT_BIT_CONCURRENCY = 4L;
        private static final long OPT_BIT_MIN_BATCH_SIZE = 8L;
        private static final long OPT_BIT_RELATIONSHIP_TYPES = 16L;
        private static final long OPT_BIT_NODE_LABELS = 32L;
        private static final long OPT_BIT_SEED_PROPERTY = 64L;
        private static final long OPT_BIT_CONSECUTIVE_IDS = 128L;
        private static final long OPT_BIT_RELATIONSHIP_WEIGHT_PROPERTY = 256L;
        private static final long OPT_BIT_THRESHOLD = 512L;
        private static final long OPT_BIT_HAS_THRESHOLD = 1024L;
        private long optBits;
        private String usernameOverride;
        private boolean sudo;
        private Collection<String> configKeys;
        private int concurrency;
        private int minBatchSize;
        private List<String> relationshipTypes = null;
        private List<String> nodeLabels = null;
        private String seedProperty;
        private boolean consecutiveIds;
        private String relationshipWeightProperty;
        private double threshold;
        private boolean hasThreshold;

        private Builder() {
        }

        public final Builder from(RelationshipWeightConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ConcurrencyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ConsecutiveIdsConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AlgoBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(WccBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SeedConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(WccStatsConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            String seedPropertyValue;
            RelationshipWeightConfig instance;
            String relationshipWeightPropertyValue;
            if (object instanceof RelationshipWeightConfig && (relationshipWeightPropertyValue = (instance = (RelationshipWeightConfig)object).relationshipWeightProperty()) != null) {
                this.relationshipWeightProperty(relationshipWeightPropertyValue);
            }
            if (object instanceof ConcurrencyConfig) {
                instance = (ConcurrencyConfig)object;
                this.minBatchSize(instance.minBatchSize());
                this.concurrency(instance.concurrency());
            }
            if (object instanceof ConsecutiveIdsConfig) {
                instance = (ConsecutiveIdsConfig)object;
                this.consecutiveIds(instance.consecutiveIds());
            }
            if (object instanceof BaseConfig) {
                instance = (BaseConfig)object;
                @Nullable String usernameOverrideValue = instance.usernameOverride();
                if (usernameOverrideValue != null) {
                    this.usernameOverride(usernameOverrideValue);
                }
                this.configKeys(instance.configKeys());
                this.sudo(instance.sudo());
            }
            if (object instanceof AlgoBaseConfig) {
                instance = (AlgoBaseConfig)object;
                this.addAllRelationshipTypes(instance.relationshipTypes());
                this.addAllNodeLabels(instance.nodeLabels());
            }
            if (object instanceof WccBaseConfig) {
                instance = (WccBaseConfig)object;
                this.hasThreshold(instance.hasThreshold());
                this.threshold(instance.threshold());
            }
            if (object instanceof SeedConfig && (seedPropertyValue = (instance = (SeedConfig)object).seedProperty()) != null) {
                this.seedProperty(seedPropertyValue);
            }
        }

        public final Builder usernameOverride(@Nullable String usernameOverride) {
            this.usernameOverride = usernameOverride;
            this.optBits |= 1L;
            return this;
        }

        public final Builder sudo(boolean sudo) {
            this.sudo = sudo;
            this.optBits |= 2L;
            return this;
        }

        public final Builder configKeys(Collection<String> configKeys) {
            this.configKeys = Objects.requireNonNull(configKeys, "configKeys");
            return this;
        }

        public final Builder concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.optBits |= 4L;
            return this;
        }

        public final Builder minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.optBits |= 8L;
            return this;
        }

        public final Builder addRelationshipType(String element) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addRelationshipTypes(String ... elements) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder relationshipTypes(Iterable<String> elements) {
            this.relationshipTypes = new ArrayList<String>();
            return this.addAllRelationshipTypes(elements);
        }

        public final Builder addAllRelationshipTypes(Iterable<String> elements) {
            Objects.requireNonNull(elements, "relationshipTypes element");
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addNodeLabel(String element) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder addNodeLabels(String ... elements) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder nodeLabels(Iterable<String> elements) {
            this.nodeLabels = new ArrayList<String>();
            return this.addAllNodeLabels(elements);
        }

        public final Builder addAllNodeLabels(Iterable<String> elements) {
            Objects.requireNonNull(elements, "nodeLabels element");
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder seedProperty(@Nullable String seedProperty) {
            this.seedProperty = seedProperty;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder consecutiveIds(boolean consecutiveIds) {
            this.consecutiveIds = consecutiveIds;
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder relationshipWeightProperty(@Nullable String relationshipWeightProperty) {
            this.relationshipWeightProperty = relationshipWeightProperty;
            this.optBits |= 0x100L;
            return this;
        }

        public final Builder threshold(double threshold) {
            this.threshold = threshold;
            this.optBits |= 0x200L;
            return this;
        }

        public final Builder hasThreshold(boolean hasThreshold) {
            this.hasThreshold = hasThreshold;
            this.optBits |= 0x400L;
            return this;
        }

        public Builder clear() {
            this.optBits = 0L;
            this.usernameOverride = null;
            this.sudo = false;
            this.configKeys = null;
            this.concurrency = 0;
            this.minBatchSize = 0;
            if (this.relationshipTypes != null) {
                this.relationshipTypes.clear();
            }
            if (this.nodeLabels != null) {
                this.nodeLabels.clear();
            }
            this.seedProperty = null;
            this.consecutiveIds = false;
            this.relationshipWeightProperty = null;
            this.threshold = 0.0;
            this.hasThreshold = false;
            return this;
        }

        public WccStatsConfig build() {
            return ImmutableWccStatsConfig.validate(new ImmutableWccStatsConfig(this));
        }

        private boolean usernameOverrideIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean sudoIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean concurrencyIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean minBatchSizeIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean relationshipTypesIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean nodeLabelsIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean seedPropertyIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean consecutiveIdsIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean relationshipWeightPropertyIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }

        private boolean thresholdIsSet() {
            return (this.optBits & 0x200L) != 0L;
        }

        private boolean hasThresholdIsSet() {
            return (this.optBits & 0x400L) != 0L;
        }
    }

    @Generated(from="WccStatsConfig", generator="Immutables")
    private final class InitShim {
        private byte usernameOverrideBuildStage = 0;
        private String usernameOverride;
        private byte sudoBuildStage = 0;
        private boolean sudo;
        private byte configKeysBuildStage = 0;
        private Collection<String> configKeys;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;
        private byte concurrencyBuildStage = 0;
        private int concurrency;
        private byte minBatchSizeBuildStage = 0;
        private int minBatchSize;
        private byte relationshipTypesBuildStage = 0;
        private List<String> relationshipTypes;
        private byte nodeLabelsBuildStage = 0;
        private List<String> nodeLabels;
        private byte seedPropertyBuildStage = 0;
        private String seedProperty;
        private byte consecutiveIdsBuildStage = 0;
        private boolean consecutiveIds;
        private byte relationshipWeightPropertyBuildStage = 0;
        private String relationshipWeightProperty;
        private byte hasRelationshipWeightPropertyBuildStage = 0;
        private boolean hasRelationshipWeightProperty;
        private byte thresholdBuildStage = 0;
        private double threshold;
        private byte hasThresholdBuildStage = 0;
        private boolean hasThreshold;

        private InitShim() {
        }

        String usernameOverride() {
            if (this.usernameOverrideBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.usernameOverrideBuildStage == 0) {
                this.usernameOverrideBuildStage = (byte)-1;
                this.usernameOverride = ImmutableWccStatsConfig.this.usernameOverrideInitialize();
                this.usernameOverrideBuildStage = 1;
            }
            return this.usernameOverride;
        }

        void usernameOverride(String usernameOverride) {
            this.usernameOverride = usernameOverride;
            this.usernameOverrideBuildStage = 1;
        }

        boolean sudo() {
            if (this.sudoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sudoBuildStage == 0) {
                this.sudoBuildStage = (byte)-1;
                this.sudo = ImmutableWccStatsConfig.this.sudoInitialize();
                this.sudoBuildStage = 1;
            }
            return this.sudo;
        }

        void sudo(boolean sudo) {
            this.sudo = sudo;
            this.sudoBuildStage = 1;
        }

        Collection<String> configKeys() {
            if (this.configKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.configKeysBuildStage == 0) {
                this.configKeysBuildStage = (byte)-1;
                this.configKeys = Objects.requireNonNull(ImmutableWccStatsConfig.this.configKeysInitialize(), "configKeys");
                this.configKeysBuildStage = 1;
            }
            return this.configKeys;
        }

        void configKeys(Collection<String> configKeys) {
            this.configKeys = configKeys;
            this.configKeysBuildStage = 1;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutableWccStatsConfig.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        int concurrency() {
            if (this.concurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.concurrencyBuildStage == 0) {
                this.concurrencyBuildStage = (byte)-1;
                this.concurrency = ImmutableWccStatsConfig.this.concurrencyInitialize();
                this.concurrencyBuildStage = 1;
            }
            return this.concurrency;
        }

        void concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.concurrencyBuildStage = 1;
        }

        int minBatchSize() {
            if (this.minBatchSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minBatchSizeBuildStage == 0) {
                this.minBatchSizeBuildStage = (byte)-1;
                this.minBatchSize = ImmutableWccStatsConfig.this.minBatchSizeInitialize();
                this.minBatchSizeBuildStage = 1;
            }
            return this.minBatchSize;
        }

        void minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.minBatchSizeBuildStage = 1;
        }

        List<String> relationshipTypes() {
            if (this.relationshipTypesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipTypesBuildStage == 0) {
                this.relationshipTypesBuildStage = (byte)-1;
                this.relationshipTypes = ImmutableWccStatsConfig.createUnmodifiableList(false, ImmutableWccStatsConfig.createSafeList(ImmutableWccStatsConfig.this.relationshipTypesInitialize(), true, false));
                this.relationshipTypesBuildStage = 1;
            }
            return this.relationshipTypes;
        }

        void relationshipTypes(List<String> relationshipTypes) {
            this.relationshipTypes = relationshipTypes;
            this.relationshipTypesBuildStage = 1;
        }

        List<String> nodeLabels() {
            if (this.nodeLabelsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nodeLabelsBuildStage == 0) {
                this.nodeLabelsBuildStage = (byte)-1;
                this.nodeLabels = ImmutableWccStatsConfig.createUnmodifiableList(false, ImmutableWccStatsConfig.createSafeList(ImmutableWccStatsConfig.this.nodeLabelsInitialize(), true, false));
                this.nodeLabelsBuildStage = 1;
            }
            return this.nodeLabels;
        }

        void nodeLabels(List<String> nodeLabels) {
            this.nodeLabels = nodeLabels;
            this.nodeLabelsBuildStage = 1;
        }

        String seedProperty() {
            if (this.seedPropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.seedPropertyBuildStage == 0) {
                this.seedPropertyBuildStage = (byte)-1;
                this.seedProperty = ImmutableWccStatsConfig.this.seedPropertyInitialize();
                this.seedPropertyBuildStage = 1;
            }
            return this.seedProperty;
        }

        void seedProperty(String seedProperty) {
            this.seedProperty = seedProperty;
            this.seedPropertyBuildStage = 1;
        }

        boolean consecutiveIds() {
            if (this.consecutiveIdsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.consecutiveIdsBuildStage == 0) {
                this.consecutiveIdsBuildStage = (byte)-1;
                this.consecutiveIds = ImmutableWccStatsConfig.this.consecutiveIdsInitialize();
                this.consecutiveIdsBuildStage = 1;
            }
            return this.consecutiveIds;
        }

        void consecutiveIds(boolean consecutiveIds) {
            this.consecutiveIds = consecutiveIds;
            this.consecutiveIdsBuildStage = 1;
        }

        String relationshipWeightProperty() {
            if (this.relationshipWeightPropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipWeightPropertyBuildStage == 0) {
                this.relationshipWeightPropertyBuildStage = (byte)-1;
                this.relationshipWeightProperty = ImmutableWccStatsConfig.this.relationshipWeightPropertyInitialize();
                this.relationshipWeightPropertyBuildStage = 1;
            }
            return this.relationshipWeightProperty;
        }

        void relationshipWeightProperty(String relationshipWeightProperty) {
            this.relationshipWeightProperty = relationshipWeightProperty;
            this.relationshipWeightPropertyBuildStage = 1;
        }

        boolean hasRelationshipWeightProperty() {
            if (this.hasRelationshipWeightPropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasRelationshipWeightPropertyBuildStage == 0) {
                this.hasRelationshipWeightPropertyBuildStage = (byte)-1;
                this.hasRelationshipWeightProperty = ImmutableWccStatsConfig.this.hasRelationshipWeightPropertyInitialize();
                this.hasRelationshipWeightPropertyBuildStage = 1;
            }
            return this.hasRelationshipWeightProperty;
        }

        double threshold() {
            if (this.thresholdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.thresholdBuildStage == 0) {
                this.thresholdBuildStage = (byte)-1;
                this.threshold = ImmutableWccStatsConfig.this.thresholdInitialize();
                this.thresholdBuildStage = 1;
            }
            return this.threshold;
        }

        void threshold(double threshold) {
            this.threshold = threshold;
            this.thresholdBuildStage = 1;
        }

        boolean hasThreshold() {
            if (this.hasThresholdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasThresholdBuildStage == 0) {
                this.hasThresholdBuildStage = (byte)-1;
                this.hasThreshold = ImmutableWccStatsConfig.this.hasThresholdInitialize();
                this.hasThresholdBuildStage = 1;
            }
            return this.hasThreshold;
        }

        void hasThreshold(boolean hasThreshold) {
            this.hasThreshold = hasThreshold;
            this.hasThresholdBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.usernameOverrideBuildStage == -1) {
                attributes.add("usernameOverride");
            }
            if (this.sudoBuildStage == -1) {
                attributes.add("sudo");
            }
            if (this.configKeysBuildStage == -1) {
                attributes.add("configKeys");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            if (this.concurrencyBuildStage == -1) {
                attributes.add("concurrency");
            }
            if (this.minBatchSizeBuildStage == -1) {
                attributes.add("minBatchSize");
            }
            if (this.relationshipTypesBuildStage == -1) {
                attributes.add("relationshipTypes");
            }
            if (this.nodeLabelsBuildStage == -1) {
                attributes.add("nodeLabels");
            }
            if (this.seedPropertyBuildStage == -1) {
                attributes.add("seedProperty");
            }
            if (this.consecutiveIdsBuildStage == -1) {
                attributes.add("consecutiveIds");
            }
            if (this.relationshipWeightPropertyBuildStage == -1) {
                attributes.add("relationshipWeightProperty");
            }
            if (this.hasRelationshipWeightPropertyBuildStage == -1) {
                attributes.add("hasRelationshipWeightProperty");
            }
            if (this.thresholdBuildStage == -1) {
                attributes.add("threshold");
            }
            if (this.hasThresholdBuildStage == -1) {
                attributes.add("hasThreshold");
            }
            return "Cannot build WccStatsConfig, attribute initializers form cycle " + attributes;
        }
    }
}

