/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.wcc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.ComponentSizeConfig;
import org.neo4j.gds.config.ConcurrencyConfig;
import org.neo4j.gds.config.ConsecutiveIdsConfig;
import org.neo4j.gds.config.RelationshipWeightConfig;
import org.neo4j.gds.config.SeedConfig;
import org.neo4j.gds.config.WriteConfig;
import org.neo4j.gds.config.WritePropertyConfig;
import org.neo4j.gds.wcc.WccBaseConfig;
import org.neo4j.gds.wcc.WccWriteConfig;

@Generated(from="WccWriteConfig", generator="Immutables")
public final class ImmutableWccWriteConfig
implements WccWriteConfig {
    @Nullable
    private final String usernameOverride;
    private final boolean sudo;
    private final Collection<String> configKeys;
    private final transient Map<String, Object> toMap;
    private final int concurrency;
    private final int minBatchSize;
    private final List<String> relationshipTypes;
    private final List<String> nodeLabels;
    @Nullable
    private final String seedProperty;
    private final boolean consecutiveIds;
    @Nullable
    private final String relationshipWeightProperty;
    private final transient boolean hasRelationshipWeightProperty;
    private final double threshold;
    private final boolean hasThreshold;
    private final int writeConcurrency;
    private final String writeProperty;
    private final Long minComponentSize;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableWccWriteConfig(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, @Nullable String seedProperty, boolean consecutiveIds, @Nullable String relationshipWeightProperty, double threshold, boolean hasThreshold, int writeConcurrency, String writeProperty, Optional<Long> minComponentSize) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(ImmutableWccWriteConfig.createUnmodifiableList(false, ImmutableWccWriteConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableWccWriteConfig.createUnmodifiableList(false, ImmutableWccWriteConfig.createSafeList(nodeLabels, true, false)));
        this.initShim.seedProperty(seedProperty);
        this.initShim.consecutiveIds(consecutiveIds);
        this.initShim.relationshipWeightProperty(relationshipWeightProperty);
        this.initShim.threshold(threshold);
        this.initShim.hasThreshold(hasThreshold);
        this.initShim.writeConcurrency(writeConcurrency);
        this.writeProperty = Objects.requireNonNull(writeProperty, "writeProperty");
        this.minComponentSize = minComponentSize.orElse(null);
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.seedProperty = this.initShim.seedProperty();
        this.consecutiveIds = this.initShim.consecutiveIds();
        this.relationshipWeightProperty = this.initShim.relationshipWeightProperty();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.threshold = this.initShim.threshold();
        this.hasThreshold = this.initShim.hasThreshold();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.initShim = null;
    }

    private ImmutableWccWriteConfig(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, @Nullable String seedProperty, boolean consecutiveIds, @Nullable String relationshipWeightProperty, double threshold, boolean hasThreshold, int writeConcurrency, String writeProperty, Long minComponentSize) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(ImmutableWccWriteConfig.createUnmodifiableList(false, ImmutableWccWriteConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableWccWriteConfig.createUnmodifiableList(false, ImmutableWccWriteConfig.createSafeList(nodeLabels, true, false)));
        this.initShim.seedProperty(seedProperty);
        this.initShim.consecutiveIds(consecutiveIds);
        this.initShim.relationshipWeightProperty(relationshipWeightProperty);
        this.initShim.threshold(threshold);
        this.initShim.hasThreshold(hasThreshold);
        this.initShim.writeConcurrency(writeConcurrency);
        this.writeProperty = Objects.requireNonNull(writeProperty, "writeProperty");
        this.minComponentSize = minComponentSize;
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.seedProperty = this.initShim.seedProperty();
        this.consecutiveIds = this.initShim.consecutiveIds();
        this.relationshipWeightProperty = this.initShim.relationshipWeightProperty();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.threshold = this.initShim.threshold();
        this.hasThreshold = this.initShim.hasThreshold();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.initShim = null;
    }

    private ImmutableWccWriteConfig(Builder builder) {
        this.writeProperty = builder.writeProperty;
        this.minComponentSize = builder.minComponentSize;
        if (builder.usernameOverrideIsSet()) {
            this.initShim.usernameOverride(builder.usernameOverride);
        }
        if (builder.sudoIsSet()) {
            this.initShim.sudo(builder.sudo);
        }
        if (builder.configKeys != null) {
            this.initShim.configKeys(builder.configKeys);
        }
        if (builder.concurrencyIsSet()) {
            this.initShim.concurrency(builder.concurrency);
        }
        if (builder.minBatchSizeIsSet()) {
            this.initShim.minBatchSize(builder.minBatchSize);
        }
        if (builder.relationshipTypesIsSet()) {
            this.initShim.relationshipTypes(builder.relationshipTypes == null ? Collections.emptyList() : ImmutableWccWriteConfig.createUnmodifiableList(true, builder.relationshipTypes));
        }
        if (builder.nodeLabelsIsSet()) {
            this.initShim.nodeLabels(builder.nodeLabels == null ? Collections.emptyList() : ImmutableWccWriteConfig.createUnmodifiableList(true, builder.nodeLabels));
        }
        if (builder.seedPropertyIsSet()) {
            this.initShim.seedProperty(builder.seedProperty);
        }
        if (builder.consecutiveIdsIsSet()) {
            this.initShim.consecutiveIds(builder.consecutiveIds);
        }
        if (builder.relationshipWeightPropertyIsSet()) {
            this.initShim.relationshipWeightProperty(builder.relationshipWeightProperty);
        }
        if (builder.thresholdIsSet()) {
            this.initShim.threshold(builder.threshold);
        }
        if (builder.hasThresholdIsSet()) {
            this.initShim.hasThreshold(builder.hasThreshold);
        }
        if (builder.writeConcurrencyIsSet()) {
            this.initShim.writeConcurrency(builder.writeConcurrency);
        }
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.seedProperty = this.initShim.seedProperty();
        this.consecutiveIds = this.initShim.consecutiveIds();
        this.relationshipWeightProperty = this.initShim.relationshipWeightProperty();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.threshold = this.initShim.threshold();
        this.hasThreshold = this.initShim.hasThreshold();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.initShim = null;
    }

    private ImmutableWccWriteConfig(@Nullable String usernameOverride, boolean sudo, Collection<String> configKeys, int concurrency, int minBatchSize, List<String> relationshipTypes, List<String> nodeLabels, @Nullable String seedProperty, boolean consecutiveIds, @Nullable String relationshipWeightProperty, double threshold, boolean hasThreshold, int writeConcurrency, String writeProperty, Long minComponentSize) {
        this.initShim.usernameOverride(usernameOverride);
        this.initShim.sudo(sudo);
        this.initShim.configKeys(configKeys);
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(relationshipTypes);
        this.initShim.nodeLabels(nodeLabels);
        this.initShim.seedProperty(seedProperty);
        this.initShim.consecutiveIds(consecutiveIds);
        this.initShim.relationshipWeightProperty(relationshipWeightProperty);
        this.initShim.threshold(threshold);
        this.initShim.hasThreshold(hasThreshold);
        this.initShim.writeConcurrency(writeConcurrency);
        this.writeProperty = writeProperty;
        this.minComponentSize = minComponentSize;
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.seedProperty = this.initShim.seedProperty();
        this.consecutiveIds = this.initShim.consecutiveIds();
        this.relationshipWeightProperty = this.initShim.relationshipWeightProperty();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.threshold = this.initShim.threshold();
        this.hasThreshold = this.initShim.hasThreshold();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.initShim = null;
    }

    @Nullable
    private String usernameOverrideInitialize() {
        return WccWriteConfig.super.usernameOverride();
    }

    private boolean sudoInitialize() {
        return WccWriteConfig.super.sudo();
    }

    private Collection<String> configKeysInitialize() {
        return WccWriteConfig.super.configKeys();
    }

    private Map<String, Object> toMapInitialize() {
        return WccWriteConfig.super.toMap();
    }

    private int concurrencyInitialize() {
        return WccWriteConfig.super.concurrency();
    }

    private int minBatchSizeInitialize() {
        return WccWriteConfig.super.minBatchSize();
    }

    private List<String> relationshipTypesInitialize() {
        return WccWriteConfig.super.relationshipTypes();
    }

    private List<String> nodeLabelsInitialize() {
        return WccWriteConfig.super.nodeLabels();
    }

    @Nullable
    private String seedPropertyInitialize() {
        return WccWriteConfig.super.seedProperty();
    }

    private boolean consecutiveIdsInitialize() {
        return WccWriteConfig.super.consecutiveIds();
    }

    @Nullable
    private String relationshipWeightPropertyInitialize() {
        return WccWriteConfig.super.relationshipWeightProperty();
    }

    private boolean hasRelationshipWeightPropertyInitialize() {
        return WccWriteConfig.super.hasRelationshipWeightProperty();
    }

    private double thresholdInitialize() {
        return WccWriteConfig.super.threshold();
    }

    private boolean hasThresholdInitialize() {
        return WccWriteConfig.super.hasThreshold();
    }

    private int writeConcurrencyInitialize() {
        return WccWriteConfig.super.writeConcurrency();
    }

    @Nullable
    public String usernameOverride() {
        InitShim shim = this.initShim;
        return shim != null ? shim.usernameOverride() : this.usernameOverride;
    }

    public boolean sudo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sudo() : this.sudo;
    }

    public Collection<String> configKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.configKeys() : this.configKeys;
    }

    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    public int concurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.concurrency() : this.concurrency;
    }

    public int minBatchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.minBatchSize() : this.minBatchSize;
    }

    public List<String> relationshipTypes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipTypes() : this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nodeLabels() : this.nodeLabels;
    }

    @Nullable
    public String seedProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.seedProperty() : this.seedProperty;
    }

    public boolean consecutiveIds() {
        InitShim shim = this.initShim;
        return shim != null ? shim.consecutiveIds() : this.consecutiveIds;
    }

    @Nullable
    public String relationshipWeightProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipWeightProperty() : this.relationshipWeightProperty;
    }

    public boolean hasRelationshipWeightProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasRelationshipWeightProperty() : this.hasRelationshipWeightProperty;
    }

    @Override
    public double threshold() {
        InitShim shim = this.initShim;
        return shim != null ? shim.threshold() : this.threshold;
    }

    @Override
    public boolean hasThreshold() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasThreshold() : this.hasThreshold;
    }

    public int writeConcurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.writeConcurrency() : this.writeConcurrency;
    }

    public String writeProperty() {
        return this.writeProperty;
    }

    public Optional<Long> minComponentSize() {
        return Optional.ofNullable(this.minComponentSize);
    }

    public final ImmutableWccWriteConfig withUsernameOverride(@Nullable String value) {
        if (Objects.equals(this.usernameOverride, value)) {
            return this;
        }
        return ImmutableWccWriteConfig.validate(new ImmutableWccWriteConfig(value, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.seedProperty, this.consecutiveIds, this.relationshipWeightProperty, this.threshold, this.hasThreshold, this.writeConcurrency, this.writeProperty, this.minComponentSize));
    }

    public final ImmutableWccWriteConfig withSudo(boolean value) {
        if (this.sudo == value) {
            return this;
        }
        return ImmutableWccWriteConfig.validate(new ImmutableWccWriteConfig(this.usernameOverride, value, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.seedProperty, this.consecutiveIds, this.relationshipWeightProperty, this.threshold, this.hasThreshold, this.writeConcurrency, this.writeProperty, this.minComponentSize));
    }

    public final ImmutableWccWriteConfig withConfigKeys(Collection<String> value) {
        if (this.configKeys == value) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(value, "configKeys");
        return ImmutableWccWriteConfig.validate(new ImmutableWccWriteConfig(this.usernameOverride, this.sudo, newValue, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.seedProperty, this.consecutiveIds, this.relationshipWeightProperty, this.threshold, this.hasThreshold, this.writeConcurrency, this.writeProperty, this.minComponentSize));
    }

    public final ImmutableWccWriteConfig withConcurrency(int value) {
        if (this.concurrency == value) {
            return this;
        }
        return ImmutableWccWriteConfig.validate(new ImmutableWccWriteConfig(this.usernameOverride, this.sudo, this.configKeys, value, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.seedProperty, this.consecutiveIds, this.relationshipWeightProperty, this.threshold, this.hasThreshold, this.writeConcurrency, this.writeProperty, this.minComponentSize));
    }

    public final ImmutableWccWriteConfig withMinBatchSize(int value) {
        if (this.minBatchSize == value) {
            return this;
        }
        return ImmutableWccWriteConfig.validate(new ImmutableWccWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, value, this.relationshipTypes, this.nodeLabels, this.seedProperty, this.consecutiveIds, this.relationshipWeightProperty, this.threshold, this.hasThreshold, this.writeConcurrency, this.writeProperty, this.minComponentSize));
    }

    public final ImmutableWccWriteConfig withRelationshipTypes(String ... elements) {
        List<String> newValue = ImmutableWccWriteConfig.createUnmodifiableList(false, ImmutableWccWriteConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableWccWriteConfig.validate(new ImmutableWccWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, newValue, this.nodeLabels, this.seedProperty, this.consecutiveIds, this.relationshipWeightProperty, this.threshold, this.hasThreshold, this.writeConcurrency, this.writeProperty, this.minComponentSize));
    }

    public final ImmutableWccWriteConfig withRelationshipTypes(Iterable<String> elements) {
        if (this.relationshipTypes == elements) {
            return this;
        }
        List<String> newValue = ImmutableWccWriteConfig.createUnmodifiableList(false, ImmutableWccWriteConfig.createSafeList(elements, true, false));
        return ImmutableWccWriteConfig.validate(new ImmutableWccWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, newValue, this.nodeLabels, this.seedProperty, this.consecutiveIds, this.relationshipWeightProperty, this.threshold, this.hasThreshold, this.writeConcurrency, this.writeProperty, this.minComponentSize));
    }

    public final ImmutableWccWriteConfig withNodeLabels(String ... elements) {
        List<String> newValue = ImmutableWccWriteConfig.createUnmodifiableList(false, ImmutableWccWriteConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableWccWriteConfig.validate(new ImmutableWccWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, newValue, this.seedProperty, this.consecutiveIds, this.relationshipWeightProperty, this.threshold, this.hasThreshold, this.writeConcurrency, this.writeProperty, this.minComponentSize));
    }

    public final ImmutableWccWriteConfig withNodeLabels(Iterable<String> elements) {
        if (this.nodeLabels == elements) {
            return this;
        }
        List<String> newValue = ImmutableWccWriteConfig.createUnmodifiableList(false, ImmutableWccWriteConfig.createSafeList(elements, true, false));
        return ImmutableWccWriteConfig.validate(new ImmutableWccWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, newValue, this.seedProperty, this.consecutiveIds, this.relationshipWeightProperty, this.threshold, this.hasThreshold, this.writeConcurrency, this.writeProperty, this.minComponentSize));
    }

    public final ImmutableWccWriteConfig withSeedProperty(@Nullable String value) {
        if (Objects.equals(this.seedProperty, value)) {
            return this;
        }
        return ImmutableWccWriteConfig.validate(new ImmutableWccWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, value, this.consecutiveIds, this.relationshipWeightProperty, this.threshold, this.hasThreshold, this.writeConcurrency, this.writeProperty, this.minComponentSize));
    }

    public final ImmutableWccWriteConfig withConsecutiveIds(boolean value) {
        if (this.consecutiveIds == value) {
            return this;
        }
        return ImmutableWccWriteConfig.validate(new ImmutableWccWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.seedProperty, value, this.relationshipWeightProperty, this.threshold, this.hasThreshold, this.writeConcurrency, this.writeProperty, this.minComponentSize));
    }

    public final ImmutableWccWriteConfig withRelationshipWeightProperty(@Nullable String value) {
        if (Objects.equals(this.relationshipWeightProperty, value)) {
            return this;
        }
        return ImmutableWccWriteConfig.validate(new ImmutableWccWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.seedProperty, this.consecutiveIds, value, this.threshold, this.hasThreshold, this.writeConcurrency, this.writeProperty, this.minComponentSize));
    }

    public final ImmutableWccWriteConfig withThreshold(double value) {
        if (Double.doubleToLongBits(this.threshold) == Double.doubleToLongBits(value)) {
            return this;
        }
        return ImmutableWccWriteConfig.validate(new ImmutableWccWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.seedProperty, this.consecutiveIds, this.relationshipWeightProperty, value, this.hasThreshold, this.writeConcurrency, this.writeProperty, this.minComponentSize));
    }

    public final ImmutableWccWriteConfig withHasThreshold(boolean value) {
        if (this.hasThreshold == value) {
            return this;
        }
        return ImmutableWccWriteConfig.validate(new ImmutableWccWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.seedProperty, this.consecutiveIds, this.relationshipWeightProperty, this.threshold, value, this.writeConcurrency, this.writeProperty, this.minComponentSize));
    }

    public final ImmutableWccWriteConfig withWriteConcurrency(int value) {
        if (this.writeConcurrency == value) {
            return this;
        }
        return ImmutableWccWriteConfig.validate(new ImmutableWccWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.seedProperty, this.consecutiveIds, this.relationshipWeightProperty, this.threshold, this.hasThreshold, value, this.writeProperty, this.minComponentSize));
    }

    public final ImmutableWccWriteConfig withWriteProperty(String value) {
        String newValue = Objects.requireNonNull(value, "writeProperty");
        if (this.writeProperty.equals(newValue)) {
            return this;
        }
        return ImmutableWccWriteConfig.validate(new ImmutableWccWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.seedProperty, this.consecutiveIds, this.relationshipWeightProperty, this.threshold, this.hasThreshold, this.writeConcurrency, newValue, this.minComponentSize));
    }

    public final ImmutableWccWriteConfig withMinComponentSize(Long value) {
        Long newValue = value;
        if (Objects.equals(this.minComponentSize, newValue)) {
            return this;
        }
        return ImmutableWccWriteConfig.validate(new ImmutableWccWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.seedProperty, this.consecutiveIds, this.relationshipWeightProperty, this.threshold, this.hasThreshold, this.writeConcurrency, this.writeProperty, newValue));
    }

    public final ImmutableWccWriteConfig withMinComponentSize(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.minComponentSize, value)) {
            return this;
        }
        return ImmutableWccWriteConfig.validate(new ImmutableWccWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.seedProperty, this.consecutiveIds, this.relationshipWeightProperty, this.threshold, this.hasThreshold, this.writeConcurrency, this.writeProperty, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableWccWriteConfig && this.equalTo((ImmutableWccWriteConfig)another);
    }

    private boolean equalTo(ImmutableWccWriteConfig another) {
        return Objects.equals(this.usernameOverride, another.usernameOverride) && this.sudo == another.sudo && this.concurrency == another.concurrency && this.minBatchSize == another.minBatchSize && this.relationshipTypes.equals(another.relationshipTypes) && this.nodeLabels.equals(another.nodeLabels) && Objects.equals(this.seedProperty, another.seedProperty) && this.consecutiveIds == another.consecutiveIds && Objects.equals(this.relationshipWeightProperty, another.relationshipWeightProperty) && this.hasRelationshipWeightProperty == another.hasRelationshipWeightProperty && Double.doubleToLongBits(this.threshold) == Double.doubleToLongBits(another.threshold) && this.hasThreshold == another.hasThreshold && this.writeConcurrency == another.writeConcurrency && this.writeProperty.equals(another.writeProperty) && Objects.equals(this.minComponentSize, another.minComponentSize);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.usernameOverride);
        h += (h << 5) + Boolean.hashCode(this.sudo);
        h += (h << 5) + this.concurrency;
        h += (h << 5) + this.minBatchSize;
        h += (h << 5) + this.relationshipTypes.hashCode();
        h += (h << 5) + this.nodeLabels.hashCode();
        h += (h << 5) + Objects.hashCode(this.seedProperty);
        h += (h << 5) + Boolean.hashCode(this.consecutiveIds);
        h += (h << 5) + Objects.hashCode(this.relationshipWeightProperty);
        h += (h << 5) + Boolean.hashCode(this.hasRelationshipWeightProperty);
        h += (h << 5) + Double.hashCode(this.threshold);
        h += (h << 5) + Boolean.hashCode(this.hasThreshold);
        h += (h << 5) + this.writeConcurrency;
        h += (h << 5) + this.writeProperty.hashCode();
        h += (h << 5) + Objects.hashCode(this.minComponentSize);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("WccWriteConfig{");
        if (this.usernameOverride != null) {
            builder.append("usernameOverride=").append(this.usernameOverride);
        }
        if (builder.length() > 15) {
            builder.append(", ");
        }
        builder.append("sudo=").append(this.sudo);
        builder.append(", ");
        builder.append("concurrency=").append(this.concurrency);
        builder.append(", ");
        builder.append("minBatchSize=").append(this.minBatchSize);
        builder.append(", ");
        builder.append("relationshipTypes=").append(this.relationshipTypes);
        builder.append(", ");
        builder.append("nodeLabels=").append(this.nodeLabels);
        if (this.seedProperty != null) {
            builder.append(", ");
            builder.append("seedProperty=").append(this.seedProperty);
        }
        builder.append(", ");
        builder.append("consecutiveIds=").append(this.consecutiveIds);
        if (this.relationshipWeightProperty != null) {
            builder.append(", ");
            builder.append("relationshipWeightProperty=").append(this.relationshipWeightProperty);
        }
        builder.append(", ");
        builder.append("hasRelationshipWeightProperty=").append(this.hasRelationshipWeightProperty);
        builder.append(", ");
        builder.append("threshold=").append(this.threshold);
        builder.append(", ");
        builder.append("hasThreshold=").append(this.hasThreshold);
        builder.append(", ");
        builder.append("writeConcurrency=").append(this.writeConcurrency);
        builder.append(", ");
        builder.append("writeProperty=").append(this.writeProperty);
        if (this.minComponentSize != null) {
            builder.append(", ");
            builder.append("minComponentSize=").append(this.minComponentSize);
        }
        return builder.append("}").toString();
    }

    public static WccWriteConfig of(int concurrency, int minBatchSize, List<String> relationshipTypes, List<String> nodeLabels, @Nullable String seedProperty, boolean consecutiveIds, @Nullable String relationshipWeightProperty, double threshold, boolean hasThreshold, int writeConcurrency, String writeProperty, Optional<Long> minComponentSize) {
        return ImmutableWccWriteConfig.of(concurrency, minBatchSize, relationshipTypes, nodeLabels, seedProperty, consecutiveIds, relationshipWeightProperty, threshold, hasThreshold, writeConcurrency, writeProperty, minComponentSize);
    }

    public static WccWriteConfig of(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, @Nullable String seedProperty, boolean consecutiveIds, @Nullable String relationshipWeightProperty, double threshold, boolean hasThreshold, int writeConcurrency, String writeProperty, Optional<Long> minComponentSize) {
        return ImmutableWccWriteConfig.validate(new ImmutableWccWriteConfig(concurrency, minBatchSize, relationshipTypes, nodeLabels, seedProperty, consecutiveIds, relationshipWeightProperty, threshold, hasThreshold, writeConcurrency, writeProperty, minComponentSize));
    }

    public static WccWriteConfig of(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, @Nullable String seedProperty, boolean consecutiveIds, @Nullable String relationshipWeightProperty, double threshold, boolean hasThreshold, int writeConcurrency, String writeProperty, Long minComponentSize) {
        return ImmutableWccWriteConfig.validate(new ImmutableWccWriteConfig(concurrency, minBatchSize, relationshipTypes, nodeLabels, seedProperty, consecutiveIds, relationshipWeightProperty, threshold, hasThreshold, writeConcurrency, writeProperty, minComponentSize));
    }

    private static ImmutableWccWriteConfig validate(ImmutableWccWriteConfig instance) {
        instance.validateWriteConcurrency();
        instance.validate();
        instance.forbidSeedingAndConsecutiveIds();
        instance.validateConcurrency();
        return instance;
    }

    public static WccWriteConfig copyOf(WccWriteConfig instance) {
        if (instance instanceof ImmutableWccWriteConfig) {
            return (ImmutableWccWriteConfig)instance;
        }
        return ImmutableWccWriteConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="WccWriteConfig", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_WRITE_PROPERTY = 1L;
        private static final long OPT_BIT_USERNAME_OVERRIDE = 1L;
        private static final long OPT_BIT_SUDO = 2L;
        private static final long OPT_BIT_CONCURRENCY = 4L;
        private static final long OPT_BIT_MIN_BATCH_SIZE = 8L;
        private static final long OPT_BIT_RELATIONSHIP_TYPES = 16L;
        private static final long OPT_BIT_NODE_LABELS = 32L;
        private static final long OPT_BIT_SEED_PROPERTY = 64L;
        private static final long OPT_BIT_CONSECUTIVE_IDS = 128L;
        private static final long OPT_BIT_RELATIONSHIP_WEIGHT_PROPERTY = 256L;
        private static final long OPT_BIT_THRESHOLD = 512L;
        private static final long OPT_BIT_HAS_THRESHOLD = 1024L;
        private static final long OPT_BIT_WRITE_CONCURRENCY = 2048L;
        private long initBits = 1L;
        private long optBits;
        private String usernameOverride;
        private boolean sudo;
        private Collection<String> configKeys;
        private int concurrency;
        private int minBatchSize;
        private List<String> relationshipTypes = null;
        private List<String> nodeLabels = null;
        private String seedProperty;
        private boolean consecutiveIds;
        private String relationshipWeightProperty;
        private double threshold;
        private boolean hasThreshold;
        private int writeConcurrency;
        private String writeProperty;
        private Long minComponentSize;

        private Builder() {
        }

        public final Builder from(RelationshipWeightConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(WriteConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(WritePropertyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ConcurrencyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ConsecutiveIdsConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AlgoBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(WccBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SeedConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ComponentSizeConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(WccWriteConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Optional minComponentSizeOptional;
            String seedPropertyValue;
            RelationshipWeightConfig instance;
            String relationshipWeightPropertyValue;
            if (object instanceof RelationshipWeightConfig && (relationshipWeightPropertyValue = (instance = (RelationshipWeightConfig)object).relationshipWeightProperty()) != null) {
                this.relationshipWeightProperty(relationshipWeightPropertyValue);
            }
            if (object instanceof WriteConfig) {
                instance = (WriteConfig)object;
                this.writeConcurrency(instance.writeConcurrency());
            }
            if (object instanceof WritePropertyConfig) {
                instance = (WritePropertyConfig)object;
                this.writeProperty(instance.writeProperty());
            }
            if (object instanceof ConcurrencyConfig) {
                instance = (ConcurrencyConfig)object;
                this.minBatchSize(instance.minBatchSize());
                this.concurrency(instance.concurrency());
            }
            if (object instanceof ConsecutiveIdsConfig) {
                instance = (ConsecutiveIdsConfig)object;
                this.consecutiveIds(instance.consecutiveIds());
            }
            if (object instanceof BaseConfig) {
                instance = (BaseConfig)object;
                @Nullable String usernameOverrideValue = instance.usernameOverride();
                if (usernameOverrideValue != null) {
                    this.usernameOverride(usernameOverrideValue);
                }
                this.configKeys(instance.configKeys());
                this.sudo(instance.sudo());
            }
            if (object instanceof AlgoBaseConfig) {
                instance = (AlgoBaseConfig)object;
                this.addAllRelationshipTypes(instance.relationshipTypes());
                this.addAllNodeLabels(instance.nodeLabels());
            }
            if (object instanceof WccBaseConfig) {
                instance = (WccBaseConfig)object;
                this.hasThreshold(instance.hasThreshold());
                this.threshold(instance.threshold());
            }
            if (object instanceof SeedConfig && (seedPropertyValue = (instance = (SeedConfig)object).seedProperty()) != null) {
                this.seedProperty(seedPropertyValue);
            }
            if (object instanceof ComponentSizeConfig && (minComponentSizeOptional = (instance = (ComponentSizeConfig)object).minComponentSize()).isPresent()) {
                this.minComponentSize(minComponentSizeOptional);
            }
        }

        public final Builder usernameOverride(@Nullable String usernameOverride) {
            this.usernameOverride = usernameOverride;
            this.optBits |= 1L;
            return this;
        }

        public final Builder sudo(boolean sudo) {
            this.sudo = sudo;
            this.optBits |= 2L;
            return this;
        }

        public final Builder configKeys(Collection<String> configKeys) {
            this.configKeys = Objects.requireNonNull(configKeys, "configKeys");
            return this;
        }

        public final Builder concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.optBits |= 4L;
            return this;
        }

        public final Builder minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.optBits |= 8L;
            return this;
        }

        public final Builder addRelationshipType(String element) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addRelationshipTypes(String ... elements) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder relationshipTypes(Iterable<String> elements) {
            this.relationshipTypes = new ArrayList<String>();
            return this.addAllRelationshipTypes(elements);
        }

        public final Builder addAllRelationshipTypes(Iterable<String> elements) {
            Objects.requireNonNull(elements, "relationshipTypes element");
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addNodeLabel(String element) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder addNodeLabels(String ... elements) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder nodeLabels(Iterable<String> elements) {
            this.nodeLabels = new ArrayList<String>();
            return this.addAllNodeLabels(elements);
        }

        public final Builder addAllNodeLabels(Iterable<String> elements) {
            Objects.requireNonNull(elements, "nodeLabels element");
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder seedProperty(@Nullable String seedProperty) {
            this.seedProperty = seedProperty;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder consecutiveIds(boolean consecutiveIds) {
            this.consecutiveIds = consecutiveIds;
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder relationshipWeightProperty(@Nullable String relationshipWeightProperty) {
            this.relationshipWeightProperty = relationshipWeightProperty;
            this.optBits |= 0x100L;
            return this;
        }

        public final Builder threshold(double threshold) {
            this.threshold = threshold;
            this.optBits |= 0x200L;
            return this;
        }

        public final Builder hasThreshold(boolean hasThreshold) {
            this.hasThreshold = hasThreshold;
            this.optBits |= 0x400L;
            return this;
        }

        public final Builder writeConcurrency(int writeConcurrency) {
            this.writeConcurrency = writeConcurrency;
            this.optBits |= 0x800L;
            return this;
        }

        public final Builder writeProperty(String writeProperty) {
            this.writeProperty = Objects.requireNonNull(writeProperty, "writeProperty");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder minComponentSize(Long minComponentSize) {
            this.minComponentSize = minComponentSize;
            return this;
        }

        public final Builder minComponentSize(Optional<Long> minComponentSize) {
            this.minComponentSize = minComponentSize.orElse(null);
            return this;
        }

        public Builder clear() {
            this.initBits = 1L;
            this.optBits = 0L;
            this.usernameOverride = null;
            this.sudo = false;
            this.configKeys = null;
            this.concurrency = 0;
            this.minBatchSize = 0;
            if (this.relationshipTypes != null) {
                this.relationshipTypes.clear();
            }
            if (this.nodeLabels != null) {
                this.nodeLabels.clear();
            }
            this.seedProperty = null;
            this.consecutiveIds = false;
            this.relationshipWeightProperty = null;
            this.threshold = 0.0;
            this.hasThreshold = false;
            this.writeConcurrency = 0;
            this.writeProperty = null;
            this.minComponentSize = null;
            return this;
        }

        public WccWriteConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableWccWriteConfig.validate(new ImmutableWccWriteConfig(this));
        }

        private boolean usernameOverrideIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean sudoIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean concurrencyIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean minBatchSizeIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean relationshipTypesIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean nodeLabelsIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean seedPropertyIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean consecutiveIdsIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean relationshipWeightPropertyIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }

        private boolean thresholdIsSet() {
            return (this.optBits & 0x200L) != 0L;
        }

        private boolean hasThresholdIsSet() {
            return (this.optBits & 0x400L) != 0L;
        }

        private boolean writeConcurrencyIsSet() {
            return (this.optBits & 0x800L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("writeProperty");
            }
            return "Cannot build WccWriteConfig, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="WccWriteConfig", generator="Immutables")
    private final class InitShim {
        private byte usernameOverrideBuildStage = 0;
        private String usernameOverride;
        private byte sudoBuildStage = 0;
        private boolean sudo;
        private byte configKeysBuildStage = 0;
        private Collection<String> configKeys;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;
        private byte concurrencyBuildStage = 0;
        private int concurrency;
        private byte minBatchSizeBuildStage = 0;
        private int minBatchSize;
        private byte relationshipTypesBuildStage = 0;
        private List<String> relationshipTypes;
        private byte nodeLabelsBuildStage = 0;
        private List<String> nodeLabels;
        private byte seedPropertyBuildStage = 0;
        private String seedProperty;
        private byte consecutiveIdsBuildStage = 0;
        private boolean consecutiveIds;
        private byte relationshipWeightPropertyBuildStage = 0;
        private String relationshipWeightProperty;
        private byte hasRelationshipWeightPropertyBuildStage = 0;
        private boolean hasRelationshipWeightProperty;
        private byte thresholdBuildStage = 0;
        private double threshold;
        private byte hasThresholdBuildStage = 0;
        private boolean hasThreshold;
        private byte writeConcurrencyBuildStage = 0;
        private int writeConcurrency;

        private InitShim() {
        }

        String usernameOverride() {
            if (this.usernameOverrideBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.usernameOverrideBuildStage == 0) {
                this.usernameOverrideBuildStage = (byte)-1;
                this.usernameOverride = ImmutableWccWriteConfig.this.usernameOverrideInitialize();
                this.usernameOverrideBuildStage = 1;
            }
            return this.usernameOverride;
        }

        void usernameOverride(String usernameOverride) {
            this.usernameOverride = usernameOverride;
            this.usernameOverrideBuildStage = 1;
        }

        boolean sudo() {
            if (this.sudoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sudoBuildStage == 0) {
                this.sudoBuildStage = (byte)-1;
                this.sudo = ImmutableWccWriteConfig.this.sudoInitialize();
                this.sudoBuildStage = 1;
            }
            return this.sudo;
        }

        void sudo(boolean sudo) {
            this.sudo = sudo;
            this.sudoBuildStage = 1;
        }

        Collection<String> configKeys() {
            if (this.configKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.configKeysBuildStage == 0) {
                this.configKeysBuildStage = (byte)-1;
                this.configKeys = Objects.requireNonNull(ImmutableWccWriteConfig.this.configKeysInitialize(), "configKeys");
                this.configKeysBuildStage = 1;
            }
            return this.configKeys;
        }

        void configKeys(Collection<String> configKeys) {
            this.configKeys = configKeys;
            this.configKeysBuildStage = 1;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutableWccWriteConfig.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        int concurrency() {
            if (this.concurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.concurrencyBuildStage == 0) {
                this.concurrencyBuildStage = (byte)-1;
                this.concurrency = ImmutableWccWriteConfig.this.concurrencyInitialize();
                this.concurrencyBuildStage = 1;
            }
            return this.concurrency;
        }

        void concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.concurrencyBuildStage = 1;
        }

        int minBatchSize() {
            if (this.minBatchSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minBatchSizeBuildStage == 0) {
                this.minBatchSizeBuildStage = (byte)-1;
                this.minBatchSize = ImmutableWccWriteConfig.this.minBatchSizeInitialize();
                this.minBatchSizeBuildStage = 1;
            }
            return this.minBatchSize;
        }

        void minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.minBatchSizeBuildStage = 1;
        }

        List<String> relationshipTypes() {
            if (this.relationshipTypesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipTypesBuildStage == 0) {
                this.relationshipTypesBuildStage = (byte)-1;
                this.relationshipTypes = ImmutableWccWriteConfig.createUnmodifiableList(false, ImmutableWccWriteConfig.createSafeList(ImmutableWccWriteConfig.this.relationshipTypesInitialize(), true, false));
                this.relationshipTypesBuildStage = 1;
            }
            return this.relationshipTypes;
        }

        void relationshipTypes(List<String> relationshipTypes) {
            this.relationshipTypes = relationshipTypes;
            this.relationshipTypesBuildStage = 1;
        }

        List<String> nodeLabels() {
            if (this.nodeLabelsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nodeLabelsBuildStage == 0) {
                this.nodeLabelsBuildStage = (byte)-1;
                this.nodeLabels = ImmutableWccWriteConfig.createUnmodifiableList(false, ImmutableWccWriteConfig.createSafeList(ImmutableWccWriteConfig.this.nodeLabelsInitialize(), true, false));
                this.nodeLabelsBuildStage = 1;
            }
            return this.nodeLabels;
        }

        void nodeLabels(List<String> nodeLabels) {
            this.nodeLabels = nodeLabels;
            this.nodeLabelsBuildStage = 1;
        }

        String seedProperty() {
            if (this.seedPropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.seedPropertyBuildStage == 0) {
                this.seedPropertyBuildStage = (byte)-1;
                this.seedProperty = ImmutableWccWriteConfig.this.seedPropertyInitialize();
                this.seedPropertyBuildStage = 1;
            }
            return this.seedProperty;
        }

        void seedProperty(String seedProperty) {
            this.seedProperty = seedProperty;
            this.seedPropertyBuildStage = 1;
        }

        boolean consecutiveIds() {
            if (this.consecutiveIdsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.consecutiveIdsBuildStage == 0) {
                this.consecutiveIdsBuildStage = (byte)-1;
                this.consecutiveIds = ImmutableWccWriteConfig.this.consecutiveIdsInitialize();
                this.consecutiveIdsBuildStage = 1;
            }
            return this.consecutiveIds;
        }

        void consecutiveIds(boolean consecutiveIds) {
            this.consecutiveIds = consecutiveIds;
            this.consecutiveIdsBuildStage = 1;
        }

        String relationshipWeightProperty() {
            if (this.relationshipWeightPropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipWeightPropertyBuildStage == 0) {
                this.relationshipWeightPropertyBuildStage = (byte)-1;
                this.relationshipWeightProperty = ImmutableWccWriteConfig.this.relationshipWeightPropertyInitialize();
                this.relationshipWeightPropertyBuildStage = 1;
            }
            return this.relationshipWeightProperty;
        }

        void relationshipWeightProperty(String relationshipWeightProperty) {
            this.relationshipWeightProperty = relationshipWeightProperty;
            this.relationshipWeightPropertyBuildStage = 1;
        }

        boolean hasRelationshipWeightProperty() {
            if (this.hasRelationshipWeightPropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasRelationshipWeightPropertyBuildStage == 0) {
                this.hasRelationshipWeightPropertyBuildStage = (byte)-1;
                this.hasRelationshipWeightProperty = ImmutableWccWriteConfig.this.hasRelationshipWeightPropertyInitialize();
                this.hasRelationshipWeightPropertyBuildStage = 1;
            }
            return this.hasRelationshipWeightProperty;
        }

        double threshold() {
            if (this.thresholdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.thresholdBuildStage == 0) {
                this.thresholdBuildStage = (byte)-1;
                this.threshold = ImmutableWccWriteConfig.this.thresholdInitialize();
                this.thresholdBuildStage = 1;
            }
            return this.threshold;
        }

        void threshold(double threshold) {
            this.threshold = threshold;
            this.thresholdBuildStage = 1;
        }

        boolean hasThreshold() {
            if (this.hasThresholdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasThresholdBuildStage == 0) {
                this.hasThresholdBuildStage = (byte)-1;
                this.hasThreshold = ImmutableWccWriteConfig.this.hasThresholdInitialize();
                this.hasThresholdBuildStage = 1;
            }
            return this.hasThreshold;
        }

        void hasThreshold(boolean hasThreshold) {
            this.hasThreshold = hasThreshold;
            this.hasThresholdBuildStage = 1;
        }

        int writeConcurrency() {
            if (this.writeConcurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.writeConcurrencyBuildStage == 0) {
                this.writeConcurrencyBuildStage = (byte)-1;
                this.writeConcurrency = ImmutableWccWriteConfig.this.writeConcurrencyInitialize();
                this.writeConcurrencyBuildStage = 1;
            }
            return this.writeConcurrency;
        }

        void writeConcurrency(int writeConcurrency) {
            this.writeConcurrency = writeConcurrency;
            this.writeConcurrencyBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.usernameOverrideBuildStage == -1) {
                attributes.add("usernameOverride");
            }
            if (this.sudoBuildStage == -1) {
                attributes.add("sudo");
            }
            if (this.configKeysBuildStage == -1) {
                attributes.add("configKeys");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            if (this.concurrencyBuildStage == -1) {
                attributes.add("concurrency");
            }
            if (this.minBatchSizeBuildStage == -1) {
                attributes.add("minBatchSize");
            }
            if (this.relationshipTypesBuildStage == -1) {
                attributes.add("relationshipTypes");
            }
            if (this.nodeLabelsBuildStage == -1) {
                attributes.add("nodeLabels");
            }
            if (this.seedPropertyBuildStage == -1) {
                attributes.add("seedProperty");
            }
            if (this.consecutiveIdsBuildStage == -1) {
                attributes.add("consecutiveIds");
            }
            if (this.relationshipWeightPropertyBuildStage == -1) {
                attributes.add("relationshipWeightProperty");
            }
            if (this.hasRelationshipWeightPropertyBuildStage == -1) {
                attributes.add("hasRelationshipWeightProperty");
            }
            if (this.thresholdBuildStage == -1) {
                attributes.add("threshold");
            }
            if (this.hasThresholdBuildStage == -1) {
                attributes.add("hasThreshold");
            }
            if (this.writeConcurrencyBuildStage == -1) {
                attributes.add("writeConcurrency");
            }
            return "Cannot build WccWriteConfig, attribute initializers form cycle " + attributes;
        }
    }
}

