/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.wcc;

import org.immutables.value.Value;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.ConsecutiveIdsConfig;
import org.neo4j.gds.config.RelationshipWeightConfig;
import org.neo4j.gds.config.SeedConfig;

public interface WccBaseConfig
extends AlgoBaseConfig,
SeedConfig,
ConsecutiveIdsConfig,
RelationshipWeightConfig {
    @Value.Default
    default public double threshold() {
        return 0.0;
    }

    @Value.Default
    @Configuration.Ignore
    default public boolean hasThreshold() {
        return !Double.isNaN(this.threshold()) && this.threshold() > 0.0;
    }

    @Value.Check
    default public void validate() {
        if (this.threshold() > 0.0 && this.relationshipWeightProperty() == null) {
            throw new IllegalArgumentException("Specifying a threshold requires `relationshipWeightProperty` to be set.");
        }
    }
}

