/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.indexInverse;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.gds.GraphStoreAlgorithmFactory;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.beta.indexInverse.InverseRelationships;
import org.neo4j.gds.beta.indexInverse.InverseRelationshipsConfig;
import org.neo4j.gds.core.compress.AdjacencyListBehavior;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.mem.MemoryRange;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.progress.tasks.Tasks;

public class InverseRelationshipsAlgorithmFactory
extends GraphStoreAlgorithmFactory<InverseRelationships, InverseRelationshipsConfig> {
    public InverseRelationships build(GraphStore graphStore, InverseRelationshipsConfig configuration, ProgressTracker progressTracker) {
        return new InverseRelationships(graphStore, configuration, progressTracker, Pools.DEFAULT);
    }

    public String taskName() {
        return "IndexInverse";
    }

    public Task progressTask(GraphStore graphStore, InverseRelationshipsConfig config) {
        long nodeCount = graphStore.nodeCount();
        Collection relationshipTypes = config.internalRelationshipTypes(graphStore);
        List tasks = relationshipTypes.stream().flatMap(type -> Stream.of(Tasks.leaf((String)String.format(Locale.US, "Create inverse relationships of type '%s'", type.name), (long)nodeCount), Tasks.leaf((String)"Build Adjacency list"))).collect(Collectors.toList());
        return Tasks.task((String)this.taskName(), tasks);
    }

    public MemoryEstimation memoryEstimation(InverseRelationshipsConfig configuration) {
        List<String> relationshipTypes = configuration.relationshipTypes();
        MemoryEstimations.Builder builder = MemoryEstimations.builder(InverseRelationships.class);
        for (String typeName : relationshipTypes) {
            RelationshipType relationshipType = RelationshipType.of((String)typeName);
            MemoryEstimations.Builder builderForType = MemoryEstimations.builder();
            builderForType.add("relationships", AdjacencyListBehavior.adjacencyListEstimation((RelationshipType)relationshipType, (boolean)false));
            builderForType.perGraphDimension("properties", (graphDimensions, concurrency) -> {
                MemoryRange singlePropertyEstimation = AdjacencyListBehavior.adjacencyPropertiesEstimation((RelationshipType)relationshipType, (boolean)false).estimate(graphDimensions, concurrency.intValue()).memoryUsage();
                return singlePropertyEstimation.times((long)graphDimensions.relationshipPropertyTokens().size());
            });
            builder.add(String.format(Locale.US, "Inverse '%s'", typeName), builderForType.build());
        }
        return builder.build();
    }
}

