/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.indexInverse;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.ElementIdentifier;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.api.schema.RelationshipSchema;
import org.neo4j.gds.beta.indexInverse.InverseRelationshipsConfigImpl;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.core.CypherMapAccess;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.StringIdentifierValidations;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.gds.utils.StringJoining;

@Configuration
public interface InverseRelationshipsConfig
extends AlgoBaseConfig {
    @Nullable
    public static List<String> parseRelTypes(Object input) {
        if (input instanceof String) {
            String strInput = (String)input;
            StringIdentifierValidations.validateNoWhiteCharacter((String)StringIdentifierValidations.emptyToNull((String)strInput), (String)"relationshipType");
            return List.of(strInput);
        }
        if (input instanceof List) {
            return ((List)input).stream().flatMap(i -> InverseRelationshipsConfig.parseRelTypes(i).stream()).collect(Collectors.toList());
        }
        throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Expected relationship type to be a String. Got %s.", (Object[])new Object[]{input.getClass().getSimpleName()}));
    }

    @Configuration.ConvertWith(method="parseRelTypes")
    public List<String> relationshipTypes();

    @Configuration.Ignore
    default public List<String> nodeLabels() {
        return List.of("*");
    }

    public static InverseRelationshipsConfig of(CypherMapWrapper configuration) {
        return new InverseRelationshipsConfigImpl((CypherMapAccess)configuration);
    }

    @Configuration.GraphStoreValidationCheck
    default public void validateNotIndexed(GraphStore graphStore, Collection<NodeLabel> selectedLabels, Collection<RelationshipType> selectedRelationshipTypes) {
        Set indexTypes = graphStore.inverseIndexedRelationshipTypes();
        List alreadyIndexedTypes = selectedRelationshipTypes.stream().filter(indexTypes::contains).map(ElementIdentifier::name).collect(Collectors.toList());
        if (!alreadyIndexedTypes.isEmpty()) {
            throw new UnsupportedOperationException(String.format(Locale.US, "Inverse index already exists for %s.", StringJoining.join(alreadyIndexedTypes)));
        }
    }

    @Configuration.GraphStoreValidationCheck
    default public void validateNotUndirected(GraphStore graphStore, Collection<NodeLabel> selectedLabels, Collection<RelationshipType> selectedRelationshipTypes) {
        Set indexTypes = graphStore.inverseIndexedRelationshipTypes();
        RelationshipSchema relationshipSchema = graphStore.schema().relationshipSchema();
        List undirectedTypes = selectedRelationshipTypes.stream().filter(arg_0 -> ((RelationshipSchema)relationshipSchema).isUndirected(arg_0)).map(ElementIdentifier::name).collect(Collectors.toList());
        if (!undirectedTypes.isEmpty()) {
            throw new UnsupportedOperationException(String.format(Locale.US, "Creating an inverse index for undirected relationships is not supported. Undirected relationship types are %s.", StringJoining.join(undirectedTypes)));
        }
    }
}

