/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.k1coloring;

import com.carrotsearch.hppc.BitSet;
import org.apache.commons.lang3.mutable.MutableLong;
import org.neo4j.gds.api.RelationshipIterator;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.core.utils.partition.Partition;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;

public final class ColoringStep
implements Runnable {
    public static final int INITIAL_FORBIDDEN_COLORS = 1000;
    private final RelationshipIterator graph;
    private final HugeLongArray colors;
    private final BitSet nodesToColor;
    private final BitSet forbiddenColors;
    private final Partition partition;
    private final ProgressTracker progressTracker;
    private final long[] resetMask;

    public ColoringStep(RelationshipIterator graph, HugeLongArray colors, BitSet nodesToColor, Partition partition, ProgressTracker progressTracker) {
        this.graph = graph;
        this.colors = colors;
        this.nodesToColor = nodesToColor;
        this.partition = partition;
        this.forbiddenColors = new BitSet(1000L);
        this.resetMask = new long[1000];
        this.progressTracker = progressTracker;
    }

    @Override
    public void run() {
        MutableLong coloredNodes = new MutableLong(0L);
        this.partition.consume(nodeId -> {
            if (this.nodesToColor.get(nodeId)) {
                coloredNodes.increment();
                this.resetForbiddenColors();
                this.graph.forEachRelationship(nodeId, (s, target) -> {
                    if (s != target) {
                        this.forbiddenColors.set(this.colors.get(target));
                    }
                    return true;
                });
                long nextColor = 0L;
                while (this.forbiddenColors.get(nextColor)) {
                    ++nextColor;
                }
                this.colors.set(nodeId, nextColor);
            }
        });
        this.progressTracker.logProgress(coloredNodes.longValue());
    }

    private void resetForbiddenColors() {
        for (int i = 0; i <= this.forbiddenColors.bits.length; i += this.resetMask.length) {
            System.arraycopy(this.resetMask, 0, this.forbiddenColors.bits, i, Math.min(this.forbiddenColors.bits.length - i, 1000));
            this.forbiddenColors.wlen = 0;
        }
    }
}

