/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.k1coloring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.neo4j.gds.beta.k1coloring.K1ColoringConfig;
import org.neo4j.gds.beta.k1coloring.K1ColoringStreamConfig;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.ConcurrencyConfig;
import org.neo4j.gds.config.IterationsConfig;
import org.neo4j.gds.config.JobIdConfig;
import org.neo4j.gds.core.utils.progress.JobId;

@Generated(from="K1ColoringStreamConfig", generator="Immutables")
public final class ImmutableK1ColoringStreamConfig
implements K1ColoringStreamConfig {
    private final String usernameOverride;
    private final boolean sudo;
    private final boolean logProgress;
    private final Collection<String> configKeys;
    private final transient Map<String, Object> toMap;
    private final int concurrency;
    private final int minBatchSize;
    private final JobId jobId;
    private final List<String> relationshipTypes;
    private final List<String> nodeLabels;
    private final int maxIterations;
    private final int batchSize;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableK1ColoringStreamConfig(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, int maxIterations, int batchSize) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(ImmutableK1ColoringStreamConfig.createUnmodifiableList(false, ImmutableK1ColoringStreamConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableK1ColoringStreamConfig.createUnmodifiableList(false, ImmutableK1ColoringStreamConfig.createSafeList(nodeLabels, true, false)));
        this.initShim.maxIterations(maxIterations);
        this.initShim.batchSize(batchSize);
        this.usernameOverride = null;
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.maxIterations = this.initShim.maxIterations();
        this.batchSize = this.initShim.batchSize();
        this.initShim = null;
    }

    private ImmutableK1ColoringStreamConfig(Builder builder) {
        this.usernameOverride = builder.usernameOverride;
        if (builder.sudoIsSet()) {
            this.initShim.sudo(builder.sudo);
        }
        if (builder.logProgressIsSet()) {
            this.initShim.logProgress(builder.logProgress);
        }
        if (builder.configKeys != null) {
            this.initShim.configKeys(builder.configKeys);
        }
        if (builder.concurrencyIsSet()) {
            this.initShim.concurrency(builder.concurrency);
        }
        if (builder.minBatchSizeIsSet()) {
            this.initShim.minBatchSize(builder.minBatchSize);
        }
        if (builder.jobId != null) {
            this.initShim.jobId(builder.jobId);
        }
        if (builder.relationshipTypesIsSet()) {
            this.initShim.relationshipTypes(builder.relationshipTypes == null ? Collections.emptyList() : ImmutableK1ColoringStreamConfig.createUnmodifiableList(true, builder.relationshipTypes));
        }
        if (builder.nodeLabelsIsSet()) {
            this.initShim.nodeLabels(builder.nodeLabels == null ? Collections.emptyList() : ImmutableK1ColoringStreamConfig.createUnmodifiableList(true, builder.nodeLabels));
        }
        if (builder.maxIterationsIsSet()) {
            this.initShim.maxIterations(builder.maxIterations);
        }
        if (builder.batchSizeIsSet()) {
            this.initShim.batchSize(builder.batchSize);
        }
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.maxIterations = this.initShim.maxIterations();
        this.batchSize = this.initShim.batchSize();
        this.initShim = null;
    }

    private ImmutableK1ColoringStreamConfig(String usernameOverride, boolean sudo, boolean logProgress, Collection<String> configKeys, int concurrency, int minBatchSize, JobId jobId, List<String> relationshipTypes, List<String> nodeLabels, int maxIterations, int batchSize) {
        this.usernameOverride = usernameOverride;
        this.initShim.sudo(sudo);
        this.initShim.logProgress(logProgress);
        this.initShim.configKeys(configKeys);
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.jobId(jobId);
        this.initShim.relationshipTypes(relationshipTypes);
        this.initShim.nodeLabels(nodeLabels);
        this.initShim.maxIterations(maxIterations);
        this.initShim.batchSize(batchSize);
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.maxIterations = this.initShim.maxIterations();
        this.batchSize = this.initShim.batchSize();
        this.initShim = null;
    }

    private boolean sudoInitialize() {
        return K1ColoringStreamConfig.super.sudo();
    }

    private boolean logProgressInitialize() {
        return K1ColoringStreamConfig.super.logProgress();
    }

    private Collection<String> configKeysInitialize() {
        return K1ColoringStreamConfig.super.configKeys();
    }

    private Map<String, Object> toMapInitialize() {
        return K1ColoringStreamConfig.super.toMap();
    }

    private int concurrencyInitialize() {
        return K1ColoringStreamConfig.super.concurrency();
    }

    private int minBatchSizeInitialize() {
        return K1ColoringStreamConfig.super.minBatchSize();
    }

    private JobId jobIdInitialize() {
        return K1ColoringStreamConfig.super.jobId();
    }

    private List<String> relationshipTypesInitialize() {
        return K1ColoringStreamConfig.super.relationshipTypes();
    }

    private List<String> nodeLabelsInitialize() {
        return K1ColoringStreamConfig.super.nodeLabels();
    }

    private int maxIterationsInitialize() {
        return K1ColoringStreamConfig.super.maxIterations();
    }

    private int batchSizeInitialize() {
        return K1ColoringStreamConfig.super.batchSize();
    }

    public Optional<String> usernameOverride() {
        return Optional.ofNullable(this.usernameOverride);
    }

    public boolean sudo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sudo() : this.sudo;
    }

    public boolean logProgress() {
        InitShim shim = this.initShim;
        return shim != null ? shim.logProgress() : this.logProgress;
    }

    public Collection<String> configKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.configKeys() : this.configKeys;
    }

    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    public int concurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.concurrency() : this.concurrency;
    }

    public int minBatchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.minBatchSize() : this.minBatchSize;
    }

    public JobId jobId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.jobId() : this.jobId;
    }

    public List<String> relationshipTypes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipTypes() : this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nodeLabels() : this.nodeLabels;
    }

    @Override
    public int maxIterations() {
        InitShim shim = this.initShim;
        return shim != null ? shim.maxIterations() : this.maxIterations;
    }

    @Override
    public int batchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.batchSize() : this.batchSize;
    }

    public final ImmutableK1ColoringStreamConfig withUsernameOverride(String value) {
        String newValue = value;
        if (Objects.equals(this.usernameOverride, newValue)) {
            return this;
        }
        return ImmutableK1ColoringStreamConfig.validate(new ImmutableK1ColoringStreamConfig(newValue, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.maxIterations, this.batchSize));
    }

    public final ImmutableK1ColoringStreamConfig withUsernameOverride(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.usernameOverride, value)) {
            return this;
        }
        return ImmutableK1ColoringStreamConfig.validate(new ImmutableK1ColoringStreamConfig(value, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.maxIterations, this.batchSize));
    }

    public final ImmutableK1ColoringStreamConfig withSudo(boolean value) {
        if (this.sudo == value) {
            return this;
        }
        return ImmutableK1ColoringStreamConfig.validate(new ImmutableK1ColoringStreamConfig(this.usernameOverride, value, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.maxIterations, this.batchSize));
    }

    public final ImmutableK1ColoringStreamConfig withLogProgress(boolean value) {
        if (this.logProgress == value) {
            return this;
        }
        return ImmutableK1ColoringStreamConfig.validate(new ImmutableK1ColoringStreamConfig(this.usernameOverride, this.sudo, value, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.maxIterations, this.batchSize));
    }

    public final ImmutableK1ColoringStreamConfig withConfigKeys(Collection<String> value) {
        if (this.configKeys == value) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(value, "configKeys");
        return ImmutableK1ColoringStreamConfig.validate(new ImmutableK1ColoringStreamConfig(this.usernameOverride, this.sudo, this.logProgress, newValue, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.maxIterations, this.batchSize));
    }

    public final ImmutableK1ColoringStreamConfig withConcurrency(int value) {
        if (this.concurrency == value) {
            return this;
        }
        return ImmutableK1ColoringStreamConfig.validate(new ImmutableK1ColoringStreamConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, value, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.maxIterations, this.batchSize));
    }

    public final ImmutableK1ColoringStreamConfig withMinBatchSize(int value) {
        if (this.minBatchSize == value) {
            return this;
        }
        return ImmutableK1ColoringStreamConfig.validate(new ImmutableK1ColoringStreamConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, value, this.jobId, this.relationshipTypes, this.nodeLabels, this.maxIterations, this.batchSize));
    }

    public final ImmutableK1ColoringStreamConfig withJobId(JobId value) {
        if (this.jobId == value) {
            return this;
        }
        JobId newValue = Objects.requireNonNull(value, "jobId");
        return ImmutableK1ColoringStreamConfig.validate(new ImmutableK1ColoringStreamConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, newValue, this.relationshipTypes, this.nodeLabels, this.maxIterations, this.batchSize));
    }

    public final ImmutableK1ColoringStreamConfig withRelationshipTypes(String ... elements) {
        List<String> newValue = ImmutableK1ColoringStreamConfig.createUnmodifiableList(false, ImmutableK1ColoringStreamConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableK1ColoringStreamConfig.validate(new ImmutableK1ColoringStreamConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, newValue, this.nodeLabels, this.maxIterations, this.batchSize));
    }

    public final ImmutableK1ColoringStreamConfig withRelationshipTypes(Iterable<String> elements) {
        if (this.relationshipTypes == elements) {
            return this;
        }
        List<String> newValue = ImmutableK1ColoringStreamConfig.createUnmodifiableList(false, ImmutableK1ColoringStreamConfig.createSafeList(elements, true, false));
        return ImmutableK1ColoringStreamConfig.validate(new ImmutableK1ColoringStreamConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, newValue, this.nodeLabels, this.maxIterations, this.batchSize));
    }

    public final ImmutableK1ColoringStreamConfig withNodeLabels(String ... elements) {
        List<String> newValue = ImmutableK1ColoringStreamConfig.createUnmodifiableList(false, ImmutableK1ColoringStreamConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableK1ColoringStreamConfig.validate(new ImmutableK1ColoringStreamConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, newValue, this.maxIterations, this.batchSize));
    }

    public final ImmutableK1ColoringStreamConfig withNodeLabels(Iterable<String> elements) {
        if (this.nodeLabels == elements) {
            return this;
        }
        List<String> newValue = ImmutableK1ColoringStreamConfig.createUnmodifiableList(false, ImmutableK1ColoringStreamConfig.createSafeList(elements, true, false));
        return ImmutableK1ColoringStreamConfig.validate(new ImmutableK1ColoringStreamConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, newValue, this.maxIterations, this.batchSize));
    }

    public final ImmutableK1ColoringStreamConfig withMaxIterations(int value) {
        if (this.maxIterations == value) {
            return this;
        }
        return ImmutableK1ColoringStreamConfig.validate(new ImmutableK1ColoringStreamConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, value, this.batchSize));
    }

    public final ImmutableK1ColoringStreamConfig withBatchSize(int value) {
        if (this.batchSize == value) {
            return this;
        }
        return ImmutableK1ColoringStreamConfig.validate(new ImmutableK1ColoringStreamConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.maxIterations, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableK1ColoringStreamConfig && this.equalTo((ImmutableK1ColoringStreamConfig)another);
    }

    private boolean equalTo(ImmutableK1ColoringStreamConfig another) {
        return Objects.equals(this.usernameOverride, another.usernameOverride) && this.sudo == another.sudo && this.logProgress == another.logProgress && this.concurrency == another.concurrency && this.minBatchSize == another.minBatchSize && this.jobId.equals((Object)another.jobId) && this.relationshipTypes.equals(another.relationshipTypes) && this.nodeLabels.equals(another.nodeLabels) && this.maxIterations == another.maxIterations && this.batchSize == another.batchSize;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.usernameOverride);
        h += (h << 5) + Boolean.hashCode(this.sudo);
        h += (h << 5) + Boolean.hashCode(this.logProgress);
        h += (h << 5) + this.concurrency;
        h += (h << 5) + this.minBatchSize;
        h += (h << 5) + this.jobId.hashCode();
        h += (h << 5) + this.relationshipTypes.hashCode();
        h += (h << 5) + this.nodeLabels.hashCode();
        h += (h << 5) + this.maxIterations;
        h += (h << 5) + this.batchSize;
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("K1ColoringStreamConfig{");
        if (this.usernameOverride != null) {
            builder.append("usernameOverride=").append(this.usernameOverride);
        }
        if (builder.length() > 23) {
            builder.append(", ");
        }
        builder.append("sudo=").append(this.sudo);
        builder.append(", ");
        builder.append("logProgress=").append(this.logProgress);
        builder.append(", ");
        builder.append("concurrency=").append(this.concurrency);
        builder.append(", ");
        builder.append("minBatchSize=").append(this.minBatchSize);
        builder.append(", ");
        builder.append("jobId=").append(this.jobId);
        builder.append(", ");
        builder.append("relationshipTypes=").append(this.relationshipTypes);
        builder.append(", ");
        builder.append("nodeLabels=").append(this.nodeLabels);
        builder.append(", ");
        builder.append("maxIterations=").append(this.maxIterations);
        builder.append(", ");
        builder.append("batchSize=").append(this.batchSize);
        return builder.append("}").toString();
    }

    public static K1ColoringStreamConfig of(int concurrency, int minBatchSize, List<String> relationshipTypes, List<String> nodeLabels, int maxIterations, int batchSize) {
        return ImmutableK1ColoringStreamConfig.of(concurrency, minBatchSize, relationshipTypes, nodeLabels, maxIterations, batchSize);
    }

    public static K1ColoringStreamConfig of(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, int maxIterations, int batchSize) {
        return ImmutableK1ColoringStreamConfig.validate(new ImmutableK1ColoringStreamConfig(concurrency, minBatchSize, relationshipTypes, nodeLabels, maxIterations, batchSize));
    }

    private static ImmutableK1ColoringStreamConfig validate(ImmutableK1ColoringStreamConfig instance) {
        instance.validateConcurrency();
        return instance;
    }

    public static K1ColoringStreamConfig copyOf(K1ColoringStreamConfig instance) {
        if (instance instanceof ImmutableK1ColoringStreamConfig) {
            return (ImmutableK1ColoringStreamConfig)instance;
        }
        return ImmutableK1ColoringStreamConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="K1ColoringStreamConfig", generator="Immutables")
    public static final class Builder {
        private static final long OPT_BIT_SUDO = 1L;
        private static final long OPT_BIT_LOG_PROGRESS = 2L;
        private static final long OPT_BIT_CONCURRENCY = 4L;
        private static final long OPT_BIT_MIN_BATCH_SIZE = 8L;
        private static final long OPT_BIT_RELATIONSHIP_TYPES = 16L;
        private static final long OPT_BIT_NODE_LABELS = 32L;
        private static final long OPT_BIT_MAX_ITERATIONS = 64L;
        private static final long OPT_BIT_BATCH_SIZE = 128L;
        private long optBits;
        private String usernameOverride;
        private boolean sudo;
        private boolean logProgress;
        private Collection<String> configKeys;
        private int concurrency;
        private int minBatchSize;
        private JobId jobId;
        private List<String> relationshipTypes = null;
        private List<String> nodeLabels = null;
        private int maxIterations;
        private int batchSize;

        private Builder() {
        }

        public final Builder from(K1ColoringConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(JobIdConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ConcurrencyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AlgoBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(IterationsConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(K1ColoringStreamConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            K1ColoringConfig instance;
            long bits = 0L;
            if (object instanceof K1ColoringConfig) {
                instance = (K1ColoringConfig)object;
                this.batchSize(instance.batchSize());
                if ((bits & 1L) == 0L) {
                    this.maxIterations(instance.maxIterations());
                    bits |= 1L;
                }
            }
            if (object instanceof JobIdConfig) {
                instance = (JobIdConfig)object;
                this.jobId(instance.jobId());
            }
            if (object instanceof ConcurrencyConfig) {
                instance = (ConcurrencyConfig)object;
                this.minBatchSize(instance.minBatchSize());
                this.concurrency(instance.concurrency());
            }
            if (object instanceof BaseConfig) {
                instance = (BaseConfig)object;
                this.logProgress(instance.logProgress());
                this.sudo(instance.sudo());
                Optional usernameOverrideOptional = instance.usernameOverride();
                if (usernameOverrideOptional.isPresent()) {
                    this.usernameOverride(usernameOverrideOptional);
                }
                this.configKeys(instance.configKeys());
            }
            if (object instanceof AlgoBaseConfig) {
                instance = (AlgoBaseConfig)object;
                this.addAllRelationshipTypes(instance.relationshipTypes());
                this.addAllNodeLabels(instance.nodeLabels());
            }
            if (object instanceof IterationsConfig) {
                instance = (IterationsConfig)object;
                if ((bits & 1L) == 0L) {
                    this.maxIterations(instance.maxIterations());
                    bits |= 1L;
                }
            }
        }

        public final Builder usernameOverride(String usernameOverride) {
            this.usernameOverride = usernameOverride;
            return this;
        }

        public final Builder usernameOverride(Optional<String> usernameOverride) {
            this.usernameOverride = usernameOverride.orElse(null);
            return this;
        }

        public final Builder sudo(boolean sudo) {
            this.sudo = sudo;
            this.optBits |= 1L;
            return this;
        }

        public final Builder logProgress(boolean logProgress) {
            this.logProgress = logProgress;
            this.optBits |= 2L;
            return this;
        }

        public final Builder configKeys(Collection<String> configKeys) {
            this.configKeys = Objects.requireNonNull(configKeys, "configKeys");
            return this;
        }

        public final Builder concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.optBits |= 4L;
            return this;
        }

        public final Builder minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.optBits |= 8L;
            return this;
        }

        public final Builder jobId(JobId jobId) {
            this.jobId = Objects.requireNonNull(jobId, "jobId");
            return this;
        }

        public final Builder addRelationshipType(String element) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addRelationshipTypes(String ... elements) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder relationshipTypes(Iterable<String> elements) {
            this.relationshipTypes = new ArrayList<String>();
            return this.addAllRelationshipTypes(elements);
        }

        public final Builder addAllRelationshipTypes(Iterable<String> elements) {
            Objects.requireNonNull(elements, "relationshipTypes element");
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addNodeLabel(String element) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder addNodeLabels(String ... elements) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder nodeLabels(Iterable<String> elements) {
            this.nodeLabels = new ArrayList<String>();
            return this.addAllNodeLabels(elements);
        }

        public final Builder addAllNodeLabels(Iterable<String> elements) {
            Objects.requireNonNull(elements, "nodeLabels element");
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder maxIterations(int maxIterations) {
            this.maxIterations = maxIterations;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder batchSize(int batchSize) {
            this.batchSize = batchSize;
            this.optBits |= 0x80L;
            return this;
        }

        public Builder clear() {
            this.optBits = 0L;
            this.usernameOverride = null;
            this.sudo = false;
            this.logProgress = false;
            this.configKeys = null;
            this.concurrency = 0;
            this.minBatchSize = 0;
            this.jobId = null;
            if (this.relationshipTypes != null) {
                this.relationshipTypes.clear();
            }
            if (this.nodeLabels != null) {
                this.nodeLabels.clear();
            }
            this.maxIterations = 0;
            this.batchSize = 0;
            return this;
        }

        public K1ColoringStreamConfig build() {
            return ImmutableK1ColoringStreamConfig.validate(new ImmutableK1ColoringStreamConfig(this));
        }

        private boolean sudoIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean logProgressIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean concurrencyIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean minBatchSizeIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean relationshipTypesIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean nodeLabelsIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean maxIterationsIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean batchSizeIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }
    }

    @Generated(from="K1ColoringStreamConfig", generator="Immutables")
    private final class InitShim {
        private byte sudoBuildStage = 0;
        private boolean sudo;
        private byte logProgressBuildStage = 0;
        private boolean logProgress;
        private byte configKeysBuildStage = 0;
        private Collection<String> configKeys;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;
        private byte concurrencyBuildStage = 0;
        private int concurrency;
        private byte minBatchSizeBuildStage = 0;
        private int minBatchSize;
        private byte jobIdBuildStage = 0;
        private JobId jobId;
        private byte relationshipTypesBuildStage = 0;
        private List<String> relationshipTypes;
        private byte nodeLabelsBuildStage = 0;
        private List<String> nodeLabels;
        private byte maxIterationsBuildStage = 0;
        private int maxIterations;
        private byte batchSizeBuildStage = 0;
        private int batchSize;

        private InitShim() {
        }

        boolean sudo() {
            if (this.sudoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sudoBuildStage == 0) {
                this.sudoBuildStage = (byte)-1;
                this.sudo = ImmutableK1ColoringStreamConfig.this.sudoInitialize();
                this.sudoBuildStage = 1;
            }
            return this.sudo;
        }

        void sudo(boolean sudo) {
            this.sudo = sudo;
            this.sudoBuildStage = 1;
        }

        boolean logProgress() {
            if (this.logProgressBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.logProgressBuildStage == 0) {
                this.logProgressBuildStage = (byte)-1;
                this.logProgress = ImmutableK1ColoringStreamConfig.this.logProgressInitialize();
                this.logProgressBuildStage = 1;
            }
            return this.logProgress;
        }

        void logProgress(boolean logProgress) {
            this.logProgress = logProgress;
            this.logProgressBuildStage = 1;
        }

        Collection<String> configKeys() {
            if (this.configKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.configKeysBuildStage == 0) {
                this.configKeysBuildStage = (byte)-1;
                this.configKeys = Objects.requireNonNull(ImmutableK1ColoringStreamConfig.this.configKeysInitialize(), "configKeys");
                this.configKeysBuildStage = 1;
            }
            return this.configKeys;
        }

        void configKeys(Collection<String> configKeys) {
            this.configKeys = configKeys;
            this.configKeysBuildStage = 1;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutableK1ColoringStreamConfig.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        int concurrency() {
            if (this.concurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.concurrencyBuildStage == 0) {
                this.concurrencyBuildStage = (byte)-1;
                this.concurrency = ImmutableK1ColoringStreamConfig.this.concurrencyInitialize();
                this.concurrencyBuildStage = 1;
            }
            return this.concurrency;
        }

        void concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.concurrencyBuildStage = 1;
        }

        int minBatchSize() {
            if (this.minBatchSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minBatchSizeBuildStage == 0) {
                this.minBatchSizeBuildStage = (byte)-1;
                this.minBatchSize = ImmutableK1ColoringStreamConfig.this.minBatchSizeInitialize();
                this.minBatchSizeBuildStage = 1;
            }
            return this.minBatchSize;
        }

        void minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.minBatchSizeBuildStage = 1;
        }

        JobId jobId() {
            if (this.jobIdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.jobIdBuildStage == 0) {
                this.jobIdBuildStage = (byte)-1;
                this.jobId = Objects.requireNonNull(ImmutableK1ColoringStreamConfig.this.jobIdInitialize(), "jobId");
                this.jobIdBuildStage = 1;
            }
            return this.jobId;
        }

        void jobId(JobId jobId) {
            this.jobId = jobId;
            this.jobIdBuildStage = 1;
        }

        List<String> relationshipTypes() {
            if (this.relationshipTypesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipTypesBuildStage == 0) {
                this.relationshipTypesBuildStage = (byte)-1;
                this.relationshipTypes = ImmutableK1ColoringStreamConfig.createUnmodifiableList(false, ImmutableK1ColoringStreamConfig.createSafeList(ImmutableK1ColoringStreamConfig.this.relationshipTypesInitialize(), true, false));
                this.relationshipTypesBuildStage = 1;
            }
            return this.relationshipTypes;
        }

        void relationshipTypes(List<String> relationshipTypes) {
            this.relationshipTypes = relationshipTypes;
            this.relationshipTypesBuildStage = 1;
        }

        List<String> nodeLabels() {
            if (this.nodeLabelsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nodeLabelsBuildStage == 0) {
                this.nodeLabelsBuildStage = (byte)-1;
                this.nodeLabels = ImmutableK1ColoringStreamConfig.createUnmodifiableList(false, ImmutableK1ColoringStreamConfig.createSafeList(ImmutableK1ColoringStreamConfig.this.nodeLabelsInitialize(), true, false));
                this.nodeLabelsBuildStage = 1;
            }
            return this.nodeLabels;
        }

        void nodeLabels(List<String> nodeLabels) {
            this.nodeLabels = nodeLabels;
            this.nodeLabelsBuildStage = 1;
        }

        int maxIterations() {
            if (this.maxIterationsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.maxIterationsBuildStage == 0) {
                this.maxIterationsBuildStage = (byte)-1;
                this.maxIterations = ImmutableK1ColoringStreamConfig.this.maxIterationsInitialize();
                this.maxIterationsBuildStage = 1;
            }
            return this.maxIterations;
        }

        void maxIterations(int maxIterations) {
            this.maxIterations = maxIterations;
            this.maxIterationsBuildStage = 1;
        }

        int batchSize() {
            if (this.batchSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.batchSizeBuildStage == 0) {
                this.batchSizeBuildStage = (byte)-1;
                this.batchSize = ImmutableK1ColoringStreamConfig.this.batchSizeInitialize();
                this.batchSizeBuildStage = 1;
            }
            return this.batchSize;
        }

        void batchSize(int batchSize) {
            this.batchSize = batchSize;
            this.batchSizeBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.sudoBuildStage == -1) {
                attributes.add("sudo");
            }
            if (this.logProgressBuildStage == -1) {
                attributes.add("logProgress");
            }
            if (this.configKeysBuildStage == -1) {
                attributes.add("configKeys");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            if (this.concurrencyBuildStage == -1) {
                attributes.add("concurrency");
            }
            if (this.minBatchSizeBuildStage == -1) {
                attributes.add("minBatchSize");
            }
            if (this.jobIdBuildStage == -1) {
                attributes.add("jobId");
            }
            if (this.relationshipTypesBuildStage == -1) {
                attributes.add("relationshipTypes");
            }
            if (this.nodeLabelsBuildStage == -1) {
                attributes.add("nodeLabels");
            }
            if (this.maxIterationsBuildStage == -1) {
                attributes.add("maxIterations");
            }
            if (this.batchSizeBuildStage == -1) {
                attributes.add("batchSize");
            }
            return "Cannot build K1ColoringStreamConfig, attribute initializers form cycle " + attributes;
        }
    }
}

