/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.k1coloring;

import com.carrotsearch.hppc.BitSet;
import java.util.List;
import java.util.PrimitiveIterator;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.neo4j.gds.Algorithm;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.RelationshipIterator;
import org.neo4j.gds.beta.k1coloring.ColoringStep;
import org.neo4j.gds.beta.k1coloring.ValidationStep;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.concurrency.RunWithConcurrency;
import org.neo4j.gds.core.utils.SetBitsIterable;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.core.utils.partition.Partition;
import org.neo4j.gds.core.utils.partition.PartitionUtils;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.mem.BitUtil;

public class K1Coloring
extends Algorithm<HugeLongArray> {
    private final Graph graph;
    private final long nodeCount;
    private final ExecutorService executor;
    private final int minBatchSize;
    private final int concurrency;
    private final long maxIterations;
    private BitSet nodesToColor;
    private HugeLongArray colors;
    private long ranIterations;
    private boolean didConverge;
    private BitSet usedColors;

    public K1Coloring(Graph graph, long maxIterations, int minBatchSize, int concurrency, ExecutorService executor, ProgressTracker progressTracker) {
        super(progressTracker);
        this.graph = graph;
        this.minBatchSize = minBatchSize;
        this.concurrency = concurrency;
        this.executor = executor;
        this.nodeCount = graph.nodeCount();
        this.maxIterations = maxIterations;
        this.nodesToColor = new BitSet(this.nodeCount);
        if (maxIterations <= 0L) {
            throw new IllegalArgumentException("Must iterate at least 1 time");
        }
    }

    public void release() {
        this.graph.release();
        this.nodesToColor = null;
    }

    public long ranIterations() {
        return this.ranIterations;
    }

    public boolean didConverge() {
        return this.didConverge;
    }

    public BitSet usedColors() {
        if (this.usedColors == null) {
            this.usedColors = new BitSet(this.nodeCount);
            this.graph.forEachNode(nodeId -> {
                this.usedColors.set(this.colors.get(nodeId));
                return true;
            });
        }
        return this.usedColors;
    }

    public HugeLongArray colors() {
        return this.colors;
    }

    public HugeLongArray compute() {
        this.progressTracker.beginSubTask();
        this.colors = HugeLongArray.newArray((long)this.nodeCount);
        this.colors.setAll(nodeId -> 1000L);
        this.ranIterations = 0L;
        this.nodesToColor.set(0L, this.nodeCount);
        long currentVolume = this.nodeCount;
        while (this.ranIterations < this.maxIterations && !this.nodesToColor.isEmpty()) {
            this.terminationFlag.assertRunning();
            this.runColoring(currentVolume);
            this.terminationFlag.assertRunning();
            this.runValidation(currentVolume);
            ++this.ranIterations;
            if (this.ranIterations >= this.maxIterations || this.nodesToColor.isEmpty()) continue;
            currentVolume = this.nodesToColor.cardinality();
        }
        this.didConverge = this.ranIterations < this.maxIterations;
        this.progressTracker.endSubTask();
        return this.colors();
    }

    private void runColoring(long volume) {
        this.progressTracker.beginSubTask(volume);
        long nodeCount = this.graph.nodeCount();
        long approximateRelationshipCount = BitUtil.ceilDiv((long)this.graph.relationshipCount(), (long)nodeCount) * this.nodesToColor.cardinality();
        long adjustedBatchSize = ParallelUtil.adjustedBatchSize((long)approximateRelationshipCount, (int)this.concurrency, (long)this.minBatchSize, (long)Integer.MAX_VALUE);
        List steps = PartitionUtils.degreePartitionWithBatchSize((PrimitiveIterator.OfLong)new SetBitsIterable(this.nodesToColor).primitiveLongIterator(), arg_0 -> ((Graph)this.graph).degree(arg_0), (long)adjustedBatchSize, partition -> new ColoringStep((RelationshipIterator)this.graph.concurrentCopy(), this.colors, this.nodesToColor, (Partition)partition, this.getProgressTracker()));
        RunWithConcurrency.builder().concurrency(this.concurrency).tasks((Iterable)steps).executor(this.executor).run();
        this.progressTracker.endSubTask();
    }

    private void runValidation(long volume) {
        this.progressTracker.beginSubTask(volume);
        BitSet nextNodesToColor = new BitSet(this.nodeCount);
        List partitions = PartitionUtils.numberAlignedPartitioning((int)this.concurrency, (long)this.nodeCount, (long)64L);
        List steps = partitions.stream().map(partition -> new ValidationStep((RelationshipIterator)this.graph.concurrentCopy(), this.colors, this.nodesToColor, nextNodesToColor, (Partition)partition, this.progressTracker)).collect(Collectors.toList());
        RunWithConcurrency.builder().concurrency(this.concurrency).tasks(steps).executor(this.executor).run();
        this.nodesToColor = nextNodesToColor;
        this.progressTracker.endSubTask();
    }
}

