/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.k1coloring;

import java.util.List;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.beta.k1coloring.ColoringStep;
import org.neo4j.gds.beta.k1coloring.K1Coloring;
import org.neo4j.gds.beta.k1coloring.K1ColoringConfig;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.IterationsConfig;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.progress.tasks.Tasks;
import org.neo4j.gds.mem.MemoryUsage;

public class K1ColoringFactory<T extends K1ColoringConfig>
extends GraphAlgorithmFactory<K1Coloring, T> {
    private static final String K1_COLORING_TASK_NAME = "K1Coloring";

    public String taskName() {
        return K1_COLORING_TASK_NAME;
    }

    public K1Coloring build(Graph graph, T configuration, ProgressTracker progressTracker) {
        return new K1Coloring(graph, configuration.maxIterations(), configuration.batchSize(), configuration.concurrency(), Pools.DEFAULT, progressTracker);
    }

    public MemoryEstimation memoryEstimation(T config) {
        return MemoryEstimations.builder(K1Coloring.class).perNode("colors", HugeLongArray::memoryEstimation).perNode("nodesToColor", MemoryUsage::sizeOfBitset).perThread("coloring", MemoryEstimations.builder().field("coloringStep", ColoringStep.class).perNode("forbiddenColors", MemoryUsage::sizeOfBitset).build()).build();
    }

    public Task progressTask(Graph graph, T config) {
        return K1ColoringFactory.k1ColoringProgressTask(graph, config);
    }

    public static <T extends BaseConfig & IterationsConfig> Task k1ColoringProgressTask(Graph graph, T config) {
        return Tasks.iterativeDynamic((String)K1_COLORING_TASK_NAME, () -> List.of(Tasks.leaf((String)"color nodes", (long)graph.nodeCount()), Tasks.leaf((String)"validate nodes", (long)graph.nodeCount())), (int)((IterationsConfig)config).maxIterations());
    }
}

