/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.undirected;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.Algorithm;
import org.neo4j.gds.ElementIdentifier;
import org.neo4j.gds.Orientation;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.CompositeRelationshipIterator;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.api.PartialIdMap;
import org.neo4j.gds.api.RelationshipIterator;
import org.neo4j.gds.api.schema.PropertySchema;
import org.neo4j.gds.api.schema.RelationshipPropertySchema;
import org.neo4j.gds.beta.undirected.ToUndirectedConfig;
import org.neo4j.gds.core.concurrency.RunWithConcurrency;
import org.neo4j.gds.core.loading.SingleTypeRelationships;
import org.neo4j.gds.core.loading.construction.GraphFactory;
import org.neo4j.gds.core.loading.construction.RelationshipsBuilder;
import org.neo4j.gds.core.loading.construction.RelationshipsBuilderBuilder;
import org.neo4j.gds.core.utils.partition.DegreePartition;
import org.neo4j.gds.core.utils.partition.PartitionUtils;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;

public class ToUndirected
extends Algorithm<SingleTypeRelationships> {
    private final GraphStore graphStore;
    private final ToUndirectedConfig config;
    private final ExecutorService executorService;

    protected ToUndirected(GraphStore graphStore, ToUndirectedConfig config, ProgressTracker progressTracker, ExecutorService executorService) {
        super(progressTracker);
        this.graphStore = graphStore;
        this.config = config;
        this.executorService = executorService;
    }

    public SingleTypeRelationships compute() {
        this.progressTracker.beginSubTask();
        RelationshipType fromRelationshipType = RelationshipType.of((String)this.config.relationshipType());
        List propertySchemas = this.graphStore.schema().relationshipSchema().propertySchemasFor((ElementIdentifier)fromRelationshipType);
        List<String> propertyKeys = propertySchemas.stream().map(PropertySchema::key).collect(Collectors.toList());
        RelationshipsBuilder relationshipsBuilder = this.initializeRelationshipsBuilder(RelationshipType.of((String)this.config.mutateRelationshipType()), propertySchemas);
        List<Runnable> tasks = this.createTasks(fromRelationshipType, propertyKeys, relationshipsBuilder);
        this.progressTracker.beginSubTask();
        RunWithConcurrency.builder().tasks(tasks).concurrency(this.config.concurrency()).executor(this.executorService).terminationFlag(this.terminationFlag).build().run();
        this.progressTracker.endSubTask();
        this.progressTracker.beginSubTask();
        SingleTypeRelationships relationships = relationshipsBuilder.build();
        this.progressTracker.endSubTask();
        this.progressTracker.endSubTask();
        return relationships;
    }

    @NotNull
    private RelationshipsBuilder initializeRelationshipsBuilder(RelationshipType relationshipType, List<RelationshipPropertySchema> propertySchemas) {
        RelationshipsBuilderBuilder relationshipsBuilderBuilder = GraphFactory.initRelationshipsBuilder().relationshipType(relationshipType).concurrency(this.config.concurrency()).nodes((PartialIdMap)this.graphStore.nodes()).executorService(this.executorService).orientation(Orientation.UNDIRECTED).validateRelationships(false);
        propertySchemas.forEach(propertySchema -> relationshipsBuilderBuilder.addPropertyConfig(propertySchema.key(), propertySchema.aggregation(), propertySchema.defaultValue(), propertySchema.state()));
        return relationshipsBuilderBuilder.build();
    }

    @NotNull
    private List<Runnable> createTasks(RelationshipType fromRelationshipType, List<String> propertyKeys, RelationshipsBuilder relationshipsBuilder) {
        Function<DegreePartition, Runnable> taskCreator;
        if (propertyKeys.size() == 1) {
            Graph graph = this.graphStore.getGraph(fromRelationshipType, Optional.of(propertyKeys.get(0)));
            taskCreator = partition -> new ToUndirectedTaskWithSingleProperty(relationshipsBuilder, (RelationshipIterator)graph.concurrentCopy(), (DegreePartition)partition, this.progressTracker);
        } else {
            CompositeRelationshipIterator relationshipIterator = this.graphStore.getCompositeRelationshipIterator(fromRelationshipType, propertyKeys);
            taskCreator = partition -> new ToUndirectedTaskWithMultipleProperties(relationshipsBuilder, relationshipIterator.concurrentCopy(), (DegreePartition)partition, this.progressTracker);
        }
        return PartitionUtils.degreePartition((Graph)this.graphStore.getGraph(new RelationshipType[]{fromRelationshipType}), (int)this.config.concurrency(), taskCreator, Optional.empty());
    }

    public void release() {
    }

    private static final class ToUndirectedTaskWithMultipleProperties
    implements Runnable {
        private final RelationshipsBuilder relationshipsBuilder;
        private final CompositeRelationshipIterator relationshipIterator;
        private final DegreePartition partition;
        private final ProgressTracker progressTracker;

        private ToUndirectedTaskWithMultipleProperties(RelationshipsBuilder relationshipsBuilder, CompositeRelationshipIterator relationshipIterator, DegreePartition partition, ProgressTracker progressTracker) {
            this.relationshipsBuilder = relationshipsBuilder;
            this.relationshipIterator = relationshipIterator;
            this.partition = partition;
            this.progressTracker = progressTracker;
        }

        @Override
        public void run() {
            for (long i = this.partition.startNode(); i < this.partition.startNode() + this.partition.nodeCount(); ++i) {
                this.relationshipIterator.forEachRelationship(i, (source, target, properties) -> {
                    this.relationshipsBuilder.addFromInternal(target, source, properties);
                    return true;
                });
                this.progressTracker.logProgress();
            }
        }
    }

    private static final class ToUndirectedTaskWithSingleProperty
    implements Runnable {
        private final RelationshipsBuilder relationshipsBuilder;
        private final RelationshipIterator relationshipIterator;
        private final DegreePartition partition;
        private final ProgressTracker progressTracker;

        private ToUndirectedTaskWithSingleProperty(RelationshipsBuilder relationshipsBuilder, RelationshipIterator relationshipIterator, DegreePartition partition, ProgressTracker progressTracker) {
            this.relationshipsBuilder = relationshipsBuilder;
            this.relationshipIterator = relationshipIterator;
            this.partition = partition;
            this.progressTracker = progressTracker;
        }

        @Override
        public void run() {
            for (long i = this.partition.startNode(); i < this.partition.startNode() + this.partition.nodeCount(); ++i) {
                this.relationshipIterator.forEachRelationship(i, 0.0, (source, target, property) -> {
                    this.relationshipsBuilder.addFromInternal(target, source, property);
                    return true;
                });
                this.progressTracker.logProgress();
            }
        }
    }
}

