/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.undirected;

import org.neo4j.gds.GraphStoreAlgorithmFactory;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.beta.undirected.ToUndirected;
import org.neo4j.gds.beta.undirected.ToUndirectedConfig;
import org.neo4j.gds.core.GraphDimensions;
import org.neo4j.gds.core.compress.AdjacencyListBehavior;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.mem.MemoryRange;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.progress.tasks.Tasks;

public class ToUndirectedAlgorithmFactory
extends GraphStoreAlgorithmFactory<ToUndirected, ToUndirectedConfig> {
    public ToUndirected build(GraphStore graphStore, ToUndirectedConfig configuration, ProgressTracker progressTracker) {
        return new ToUndirected(graphStore, configuration, progressTracker, Pools.DEFAULT);
    }

    public String taskName() {
        return "ToUndirected";
    }

    public Task progressTask(GraphStore graphStore, ToUndirectedConfig config) {
        return Tasks.task((String)"ToUndirected", (Task)Tasks.leaf((String)"Create Undirected Relationships", (long)graphStore.nodeCount()), (Task[])new Task[]{Tasks.leaf((String)"Build undirected Adjacency list")});
    }

    public MemoryEstimation memoryEstimation(ToUndirectedConfig configuration) {
        RelationshipType relationshipType = RelationshipType.of((String)configuration.relationshipType());
        MemoryEstimations.Builder builder = MemoryEstimations.builder(ToUndirected.class).add("relationships", AdjacencyListBehavior.adjacencyListEstimation((RelationshipType)relationshipType, (boolean)true));
        builder.perGraphDimension("properties", (graphDimensions, concurrency) -> {
            long max = graphDimensions.relationshipPropertyTokens().keySet().stream().mapToLong(__ -> AdjacencyListBehavior.adjacencyPropertiesEstimation((RelationshipType)relationshipType, (boolean)true).estimate((GraphDimensions)graphDimensions, (int)concurrency.intValue()).memoryUsage().max).sum();
            return MemoryRange.of((long)0L, (long)max);
        });
        return builder.build();
    }
}

