/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.undirected;

import java.util.List;
import org.immutables.value.Value;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.beta.undirected.ToUndirectedConfigImpl;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.MutateRelationshipConfig;
import org.neo4j.gds.core.CypherMapAccess;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.StringIdentifierValidations;

@Configuration
public interface ToUndirectedConfig
extends AlgoBaseConfig,
MutateRelationshipConfig {
    @Configuration.ConvertWith(method="validateRelationshipTypeIdentifier")
    public String relationshipType();

    @Configuration.Ignore
    default public List<String> relationshipTypes() {
        return List.of("*");
    }

    @Configuration.Ignore
    default public List<String> nodeLabels() {
        return List.of("*");
    }

    public static ToUndirectedConfig of(CypherMapWrapper configuration) {
        return new ToUndirectedConfigImpl((CypherMapAccess)configuration);
    }

    @Value.Check
    default public void validateRelationshipTypeNotStar() {
        if (this.relationshipType().equals("*")) {
            throw new UnsupportedOperationException("`relationshipType` cannot be `*`. Please specify the concrete relationship type.");
        }
    }

    @Nullable
    public static String validateRelationshipTypeIdentifier(String input) {
        return StringIdentifierValidations.validateNoWhiteCharacter((String)StringIdentifierValidations.emptyToNull((String)input), (String)"relationshipType");
    }
}

