/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.walking;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.neo4j.gds.Algorithm;
import org.neo4j.gds.Orientation;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.PartialIdMap;
import org.neo4j.gds.beta.walking.CollapsePathTaskSupplier;
import org.neo4j.gds.core.Aggregation;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.concurrency.RunWithConcurrency;
import org.neo4j.gds.core.loading.SingleTypeRelationships;
import org.neo4j.gds.core.loading.construction.GraphFactory;
import org.neo4j.gds.core.loading.construction.RelationshipsBuilder;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;

public class CollapsePath
extends Algorithm<SingleTypeRelationships> {
    private final List<Graph[]> pathTemplates;
    private final long nodeCount;
    private final boolean allowSelfLoops;
    private RelationshipType mutateRelationshipType;
    private final int concurrency;
    private final ExecutorService executorService;

    public CollapsePath(List<Graph[]> pathTemplates, boolean allowSelfLoops, RelationshipType mutateRelationshipType, int concurrency, ExecutorService executorService) {
        super(ProgressTracker.NULL_TRACKER);
        this.pathTemplates = pathTemplates;
        this.nodeCount = pathTemplates.get(0)[0].nodeCount();
        this.allowSelfLoops = allowSelfLoops;
        this.mutateRelationshipType = mutateRelationshipType;
        this.concurrency = concurrency;
        this.executorService = executorService;
    }

    public SingleTypeRelationships compute() {
        RelationshipsBuilder relImporter = GraphFactory.initRelationshipsBuilder().nodes((PartialIdMap)this.pathTemplates.get(0)[0]).relationshipType(this.mutateRelationshipType).orientation(Orientation.NATURAL).aggregation(Aggregation.NONE).concurrency(this.concurrency).executorService(this.executorService).build();
        Supplier<Runnable> collapsePathTaskSupplier = CollapsePathTaskSupplier.create(relImporter, this.allowSelfLoops, this.pathTemplates, this.nodeCount);
        Collection tasks = ParallelUtil.tasks((int)this.concurrency, collapsePathTaskSupplier);
        RunWithConcurrency.builder().concurrency(this.concurrency).tasks((Iterable)tasks).run();
        return relImporter.build();
    }

    public void release() {
    }
}

