/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.walking;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.gds.GraphStoreAlgorithmFactory;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.beta.walking.CollapsePath;
import org.neo4j.gds.beta.walking.CollapsePathConfig;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;

public class CollapsePathAlgorithmFactory
extends GraphStoreAlgorithmFactory<CollapsePath, CollapsePathConfig> {
    public CollapsePath build(GraphStore graphStore, CollapsePathConfig config, ProgressTracker progressTracker) {
        Collection nodeLabels = config.nodeLabelIdentifiers(graphStore);
        List<Graph[]> pathTemplatesEncodedAsListsOfSingleRelationshipTypeGraphs = config.pathTemplates().stream().map(path -> (Graph[])path.stream().map(relationshipTypeAsString -> graphStore.getGraph(nodeLabels, Set.of(RelationshipType.of((String)relationshipTypeAsString)), Optional.empty())).toArray(Graph[]::new)).collect(Collectors.toList());
        return new CollapsePath(pathTemplatesEncodedAsListsOfSingleRelationshipTypeGraphs, config.allowSelfLoops(), RelationshipType.of((String)config.mutateRelationshipType()), config.concurrency(), Pools.DEFAULT);
    }

    public String taskName() {
        return "CollapsePath";
    }
}

