/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.walking;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.RelationshipIterator;
import org.neo4j.gds.beta.walking.NoLoopTraversalConsumer;
import org.neo4j.gds.beta.walking.TraversalConsumer;
import org.neo4j.gds.beta.walking.TraversalToEdgeMSBFSStrategy;
import org.neo4j.gds.core.loading.construction.RelationshipsBuilder;
import org.neo4j.gds.msbfs.MultiSourceBFSRunnable;

public final class CollapsePathTaskSupplier
implements Supplier<Runnable> {
    private final AtomicInteger globalSharedPathTemplateIndex = new AtomicInteger(0);
    private final List<AtomicLong> globalSharedBatchOffsets;
    private final List<Graph[]> pathTemplates;
    private final long nodeCount;
    private final List<TraversalConsumer> bfsConsumers;
    private final boolean allowSelfLoops;

    static Supplier<Runnable> create(RelationshipsBuilder relationshipsBuilder, boolean allowSelfLoops, List<Graph[]> pathTemplates, long nodeCount) {
        List<TraversalConsumer> traversalConsumers = pathTemplates.stream().map(pathTemplate -> allowSelfLoops ? new TraversalConsumer(relationshipsBuilder, ((Graph[])pathTemplate).length) : new NoLoopTraversalConsumer(relationshipsBuilder, ((Graph[])pathTemplate).length)).collect(Collectors.toList());
        List<AtomicLong> globalSharedBatchOffsets = pathTemplates.stream().map(pathTemplate -> new AtomicLong(0L)).collect(Collectors.toList());
        return new CollapsePathTaskSupplier(globalSharedBatchOffsets, pathTemplates, nodeCount, traversalConsumers, allowSelfLoops);
    }

    private CollapsePathTaskSupplier(List<AtomicLong> globalSharedBatchOffsets, List<Graph[]> pathTemplates, long nodeCount, List<TraversalConsumer> bfsConsumers, boolean allowSelfLoops) {
        this.globalSharedBatchOffsets = globalSharedBatchOffsets;
        this.pathTemplates = pathTemplates;
        this.nodeCount = nodeCount;
        this.bfsConsumers = bfsConsumers;
        this.allowSelfLoops = allowSelfLoops;
    }

    @Override
    public Runnable get() {
        return () -> {
            int pathTemplateIndex;
            while ((pathTemplateIndex = this.globalSharedPathTemplateIndex.get()) < this.pathTemplates.size()) {
                RelationshipIterator[] localPathTemplate = this.getPathTemplate(pathTemplateIndex);
                long offset = -1L;
                long[] startNodes = new long[64];
                AtomicLong offsetHolder = this.globalSharedBatchOffsets.get(pathTemplateIndex);
                while ((offset = offsetHolder.getAndAdd(64L)) < this.nodeCount) {
                    if (offset + 64L >= this.nodeCount) {
                        int numberOfNodesRemaining = (int)(this.nodeCount - offset);
                        startNodes = new long[numberOfNodesRemaining];
                    }
                    for (int i = 0; i < startNodes.length; ++i) {
                        startNodes[i] = offset + (long)i;
                    }
                    MultiSourceBFSRunnable msbfsTask = this.createMSBFSTask(localPathTemplate, startNodes, pathTemplateIndex);
                    msbfsTask.run();
                }
                this.globalSharedPathTemplateIndex.compareAndSet(pathTemplateIndex, pathTemplateIndex + 1);
            }
            return;
        };
    }

    @NotNull
    private RelationshipIterator[] getPathTemplate(int pathTemplateIndex) {
        Graph[] pathTemplate = this.pathTemplates.get(pathTemplateIndex);
        RelationshipIterator[] localPathTemplate = new RelationshipIterator[pathTemplate.length];
        for (int i = 0; i < pathTemplate.length; ++i) {
            localPathTemplate[i] = pathTemplate[i].concurrentCopy();
        }
        return localPathTemplate;
    }

    private MultiSourceBFSRunnable createMSBFSTask(RelationshipIterator[] localPathTemplate, long[] startNodes, int pathTemplateIndex) {
        TraversalToEdgeMSBFSStrategy executionStrategy = new TraversalToEdgeMSBFSStrategy(localPathTemplate, this.bfsConsumers.get(pathTemplateIndex));
        return MultiSourceBFSRunnable.createWithoutSeensNext(this.nodeCount, null, executionStrategy, this.allowSelfLoops, startNodes);
    }
}

