/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.walking;

import org.neo4j.gds.api.RelationshipIterator;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.msbfs.ANPStrategy;
import org.neo4j.gds.msbfs.BfsConsumer;

final class TraversalToEdgeMSBFSStrategy
extends ANPStrategy {
    private final RelationshipIterator[] relationshipIterators;

    TraversalToEdgeMSBFSStrategy(RelationshipIterator[] relationshipIterators, BfsConsumer perNodeAction) {
        super(perNodeAction);
        this.relationshipIterators = relationshipIterators;
    }

    @Override
    protected boolean stopTraversal(boolean hasNext, int depth) {
        return !hasNext || depth >= this.relationshipIterators.length;
    }

    @Override
    protected void prepareNextVisit(RelationshipIterator ignored, long nodeVisit, long nodeId, HugeLongArray nextSet, int depth) {
        RelationshipIterator relationshipIterator = this.relationshipIterators[depth];
        relationshipIterator.forEachRelationship(nodeId, (src, tgt) -> {
            nextSet.or(tgt, nodeVisit);
            return true;
        });
    }
}

