/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.betweenness;

import com.carrotsearch.hppc.LongArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import org.neo4j.gds.Algorithm;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.betweenness.ForwardTraverser;
import org.neo4j.gds.betweenness.SelectionStrategy;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.utils.paged.HugeAtomicDoubleArray;
import org.neo4j.gds.core.utils.paged.HugeCursor;
import org.neo4j.gds.core.utils.paged.HugeDoubleArray;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.core.utils.paged.HugeLongArrayStack;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;

public class BetweennessCentrality
extends Algorithm<HugeAtomicDoubleArray> {
    private final Graph graph;
    private final long nodeCount;
    private final double divisor;
    private final ForwardTraverser.Factory traverserFactory;
    private HugeAtomicDoubleArray centrality;
    private SelectionStrategy selectionStrategy;
    private final ExecutorService executorService;
    private final int concurrency;

    public BetweennessCentrality(Graph graph, SelectionStrategy selectionStrategy, ForwardTraverser.Factory traverserFactory, ExecutorService executorService, int concurrency, ProgressTracker progressTracker) {
        super(progressTracker);
        this.graph = graph;
        this.executorService = executorService;
        this.concurrency = concurrency;
        this.nodeCount = graph.nodeCount();
        this.centrality = HugeAtomicDoubleArray.newArray((long)this.nodeCount);
        this.selectionStrategy = selectionStrategy;
        this.selectionStrategy.init(graph, executorService, concurrency);
        this.divisor = graph.schema().isUndirected() ? 2.0 : 1.0;
        this.traverserFactory = traverserFactory;
    }

    public HugeAtomicDoubleArray compute() {
        this.progressTracker.beginSubTask();
        ParallelUtil.run((Collection)ParallelUtil.tasks((int)this.concurrency, () -> new BCTask()), (ExecutorService)this.executorService);
        this.progressTracker.endSubTask();
        return this.centrality;
    }

    public void release() {
        this.centrality = null;
        this.selectionStrategy = null;
    }

    final class BCTask
    implements Runnable {
        private final HugeObjectArray<LongArrayList> predecessors;
        private final HugeCursor<LongArrayList[]> predecessorsCursor;
        private final HugeLongArrayStack backwardNodes;
        private final HugeDoubleArray delta;
        private final HugeLongArray sigma;

        private BCTask() {
            this.predecessors = HugeObjectArray.newArray(LongArrayList.class, (long)BetweennessCentrality.this.nodeCount);
            this.predecessorsCursor = this.predecessors.newCursor();
            this.backwardNodes = HugeLongArrayStack.newStack((long)BetweennessCentrality.this.nodeCount);
            this.sigma = HugeLongArray.newArray((long)BetweennessCentrality.this.nodeCount);
            this.delta = HugeDoubleArray.newArray((long)BetweennessCentrality.this.nodeCount);
        }

        @Override
        public void run() {
            ForwardTraverser forwardTraversor = BetweennessCentrality.this.traverserFactory.create(BetweennessCentrality.this.graph.concurrentCopy(), this.predecessors, this.backwardNodes, this.sigma, BetweennessCentrality.this.terminationFlag);
            long startNodeId;
            block0: while ((startNodeId = BetweennessCentrality.this.selectionStrategy.next()) != -1L && BetweennessCentrality.this.terminationFlag.running()) {
                BetweennessCentrality.this.getProgressTracker().logProgress();
                this.clear();
                forwardTraversor.clear();
                this.sigma.addTo(startNodeId, 1L);
                forwardTraversor.traverse(startNodeId);
                while (true) {
                    double current;
                    if (this.backwardNodes.isEmpty()) continue block0;
                    long node = this.backwardNodes.pop();
                    LongArrayList predecessors = (LongArrayList)this.predecessors.get(node);
                    double dependencyNode = this.delta.get(node);
                    double sigmaNode = this.sigma.get(node);
                    if (null != predecessors) {
                        predecessors.forEach(predecessor -> {
                            double sigmaPredecessor = this.sigma.get(predecessor.value);
                            double dependency = sigmaPredecessor / sigmaNode * (dependencyNode + 1.0);
                            this.delta.addTo(predecessor.value, dependency);
                        });
                    }
                    if (node == startNodeId) continue;
                    while (!BetweennessCentrality.this.centrality.compareAndSet(node, current = BetweennessCentrality.this.centrality.get(node), current + dependencyNode / BetweennessCentrality.this.divisor)) {
                    }
                }
                break;
            }
            return;
        }

        private void clear() {
            this.sigma.fill(0L);
            this.delta.fill(0.0);
            this.predecessors.initCursor(this.predecessorsCursor);
            while (this.predecessorsCursor.next()) {
                for (int i = this.predecessorsCursor.offset; i < this.predecessorsCursor.limit; ++i) {
                    if (((LongArrayList[])this.predecessorsCursor.array)[i] == null) continue;
                    ((LongArrayList[])this.predecessorsCursor.array)[i].elementsCount = 0;
                }
            }
        }
    }
}

