/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.betweenness;

import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.betweenness.BetweennessCentrality;
import org.neo4j.gds.betweenness.BetweennessCentralityBaseConfig;
import org.neo4j.gds.betweenness.ForwardTraverser;
import org.neo4j.gds.betweenness.FullSelectionStrategy;
import org.neo4j.gds.betweenness.RandomDegreeSelectionStrategy;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.paged.HugeAtomicDoubleArray;
import org.neo4j.gds.core.utils.paged.HugeDoubleArray;
import org.neo4j.gds.core.utils.paged.HugeIntArray;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.progress.tasks.Tasks;
import org.neo4j.gds.core.utils.queue.HugeLongPriorityQueue;
import org.neo4j.gds.mem.MemoryUsage;

public class BetweennessCentralityFactory<CONFIG extends BetweennessCentralityBaseConfig>
extends GraphAlgorithmFactory<BetweennessCentrality, CONFIG> {
    public String taskName() {
        return "BetweennessCentrality";
    }

    public BetweennessCentrality build(Graph graph, CONFIG configuration, ProgressTracker progressTracker) {
        Optional<Long> samplingSize = configuration.samplingSize();
        Optional<Long> samplingSeed = configuration.samplingSeed();
        FullSelectionStrategy strategy = samplingSize.isPresent() && samplingSize.get() < graph.nodeCount() ? new RandomDegreeSelectionStrategy(samplingSize.get(), samplingSeed) : new FullSelectionStrategy();
        ForwardTraverser.Factory traverserFactory = configuration.hasRelationshipWeightProperty() ? ForwardTraverser.Factory.weighted() : ForwardTraverser.Factory.unweighted();
        return new BetweennessCentrality(graph, strategy, traverserFactory, Pools.DEFAULT, configuration.concurrency(), progressTracker);
    }

    public MemoryEstimation memoryEstimation(CONFIG configuration) {
        MemoryEstimations.Builder builder = MemoryEstimations.builder(BetweennessCentrality.class).perNode("centrality scores", HugeAtomicDoubleArray::memoryEstimation).perThread("compute task", BetweennessCentralityFactory.bcTaskMemoryEstimationBuilder(configuration.hasRelationshipWeightProperty()).build());
        return builder.build();
    }

    @NotNull
    private static MemoryEstimations.Builder bcTaskMemoryEstimationBuilder(boolean weighted) {
        MemoryEstimations.Builder builder = MemoryEstimations.builder(BetweennessCentrality.BCTask.class).add("predecessors", MemoryEstimations.setup((String)"", (dimensions, concurrency) -> {
            long averagePredecessorSize = MemoryUsage.sizeOfLongArray((long)dimensions.averageDegree());
            return MemoryEstimations.builder(HugeObjectArray.class).perNode("array", nodeCount -> nodeCount * averagePredecessorSize).build();
        })).perNode("backwardNodes", HugeLongArray::memoryEstimation).perNode("deltas", HugeDoubleArray::memoryEstimation).perNode("sigmas", HugeLongArray::memoryEstimation);
        if (weighted) {
            builder.add("ForwardTraverser", MemoryEstimations.setup((String)"traverser", (dimensions, concurrency) -> MemoryEstimations.builder(ForwardTraverser.class).add("nodeQueue", HugeLongPriorityQueue.memoryEstimation()).perNode("visited", MemoryUsage::sizeOfBitset).build()));
        } else {
            builder.add("ForwardTraverser", MemoryEstimations.setup((String)"traverser", (dimensions, concurrency) -> MemoryEstimations.builder(ForwardTraverser.class).perNode("distances", HugeIntArray::memoryEstimation).perNode("forwardNodes", HugeLongArray::memoryEstimation).build()));
        }
        return builder;
    }

    public Task progressTask(Graph graph, CONFIG config) {
        return Tasks.leaf((String)this.taskName(), (long)config.samplingSize().orElse(graph.nodeCount()));
    }
}

