/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.betweenness;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.betweenness.SelectionStrategy;

public class FullSelectionStrategy
implements SelectionStrategy {
    private final AtomicLong nodeQueue = new AtomicLong();
    private long graphSize = 0L;

    @Override
    public void init(Graph graph, ExecutorService executorService, int concurrency) {
        this.graphSize = graph.nodeCount();
        this.nodeQueue.set(0L);
    }

    @Override
    public long next() {
        long nextNodeId = this.nodeQueue.getAndIncrement();
        if (nextNodeId >= this.graphSize) {
            return -1L;
        }
        return nextNodeId;
    }
}

